/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class CashInTreasureTrainMessage
extends AttributeMessage {
    public static final String TAG = "cashInTreasureTrain";
    private static final String UNIT_TAG = "unit";

    public CashInTreasureTrainMessage(Unit unit) {
        super(TAG, UNIT_TAG, unit.getId());
    }

    public CashInTreasureTrainMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.canCarryTreasure()) {
            return serverPlayer.clientError("Can not cash in unit " + unitId + ", can not carry treasure.");
        }
        if (!unit.canCashInTreasureTrain()) {
            return serverPlayer.clientError("Can not cash in unit " + unitId + ", unsuitable location.");
        }
        return this.igc(freeColServer).cashInTreasureTrain(serverPlayer, unit);
    }
}

