/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import ddf.minim.AudioSource;
import ddf.minim.Polyphonic;
import ddf.minim.SignalChain;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.AudioSynthesizer;

public class AudioOutput
extends AudioSource
implements Polyphonic {
    private AudioSynthesizer synth;
    private SignalChain signals;

    public AudioOutput(AudioSynthesizer synthesizer) {
        super((AudioStream)synthesizer);
        this.synth = synthesizer;
        this.signals = new SignalChain();
        this.synth.setAudioSignal((AudioSignal)this.signals);
    }

    public void addSignal(AudioSignal signal) {
        this.signals.add(signal);
    }

    public AudioSignal getSignal(int i) {
        return this.signals.get(i);
    }

    public void removeSignal(AudioSignal signal) {
        this.signals.remove(signal);
    }

    public AudioSignal removeSignal(int i) {
        return this.signals.remove(i);
    }

    public void clearSignals() {
        this.signals.clear();
    }

    public void disableSignal(int i) {
        this.signals.disable(i);
    }

    public void disableSignal(AudioSignal signal) {
        this.signals.disable(signal);
    }

    public void enableSignal(int i) {
        this.signals.enable(i);
    }

    public void enableSignal(AudioSignal signal) {
        this.signals.enable(signal);
    }

    public boolean isEnabled(AudioSignal signal) {
        return this.signals.isEnabled(signal);
    }

    public boolean isSounding() {
        return this.signals.hasEnabled();
    }

    public void noSound() {
        this.signals.disableAll();
    }

    public int signalCount() {
        return this.signals.size();
    }

    public void sound() {
        this.signals.enableAll();
    }

    public boolean hasSignal(AudioSignal signal) {
        return this.signals.contains(signal);
    }
}

