--
-- This file is part of TALER
-- Copyright (C) 2026 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>

-- @file merchant-0029.sql
-- @brief Add field for long-poll signalling to taler-merchant-kyccheck
-- @author Christian Grothoff

BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0029', NULL, NULL);

SET search_path TO merchant;

ALTER TABLE merchant_kyc
  ADD COLUMN next_kyc_poll INT8 NOT NULL DEFAULT 0,
  ADD COLUMN kyc_backoff INT8 NOT NULL DEFAULT 0;
COMMENT ON COLUMN merchant_kyc.next_kyc_poll
  IS 'When should we next do a KYC poll on this exchange and bank account';
COMMENT ON COLUMN merchant_kyc.kyc_backoff
  IS 'What is the current backoff value between KYC polls';

CREATE INDEX merchant_kyc_by_next_kyc_poll
  ON merchant_kyc
  (next_kyc_poll ASC);

COMMIT;
