'''OpenGL extension EXT.protected_textures

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.protected_textures to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension requires another extension like EGL_EXT_protected_content to
	have created a protected context.  A protected context enables the
	driver to put the GPU into a protected mode where it is able to operate on
	protected surfaces.
	
	This extension enables allocating standard GL textures as protected
	surfaces. Previously these textures would have had to have been created as
	special EGL surfaces.  This allows use-cases such as depth, stencil, or
	mipmapped textures to be supported as destinations for rendering within
	a protected context.
	
	An explanation of undefined behavior in this extension:  Several places
	in this extension mention undefined behavior can result, which can
	include program termination.  The reason for this is because one way
	to handle protected content is by using a protected virtual to physical
	memory translation layer.  With this sort of solution a system may generate
	read or write faults when a non-protected context tries to access the
	buffer.  Depending on the system these faults might be ignored or they might
	cause process termination.  This undefined behavior should not include
	actually allowing copying any protected content to a non-protected surface.
	
	This extension does not guarantee that the implementation abides by a
	system's digital rights management requirements.  It must be verified beyond
	the existence of this extension that the implementation of this extension is
	trustworthy according to the requirements of a content protection system.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/protected_textures.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.protected_textures import *
from OpenGL.raw.GLES2.EXT.protected_textures import _EXTENSION_NAME

def glInitProtectedTexturesEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION