/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks.highlight;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.IssueLink;
import com.almworks.tracklink.codelinks.CodeLink;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.StyleConstants;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLTextRange
implements IssueLink {
    private static final Key<URLTextRange> STATIC_HIGHLIGHTER_KEY = Key.create((String)"StaticLinkHighlighter");
    private final CodeLink myCodeLink;
    private final CodeLinkType myCodeLinkType;
    private boolean myActive;
    private int myStartOffset;
    private int myEndOffset;
    private int myHash;

    public URLTextRange(int startOffset, int endOffset, @NotNull CodeLink codeLink, @NotNull CodeLinkType codeLinkType, boolean isActive) {
        if (codeLink == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/URLTextRange.<init> must not be null");
        }
        if (codeLinkType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/almworks/tracklink/codelinks/highlight/URLTextRange.<init> must not be null");
        }
        this.myHash = 0;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myCodeLink = codeLink;
        this.myCodeLinkType = codeLinkType;
        this.myActive = isActive;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CodeLink getCodeLink() {
        CodeLink codeLink = this.myCodeLink;
        if (codeLink == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/codelinks/highlight/URLTextRange.getCodeLink must not return null");
        }
        return codeLink;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CodeLinkType getCodeLinkType() {
        CodeLinkType codeLinkType = this.myCodeLinkType;
        if (codeLinkType == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/codelinks/highlight/URLTextRange.getCodeLinkType must not return null");
        }
        return codeLinkType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getURL() {
        String string = this.myCodeLink.getUrl();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/codelinks/highlight/URLTextRange.getURL must not return null");
        }
        return string;
    }

    @Nullable
    public String getIssueName() {
        return this.myCodeLink.getCodeFragment();
    }

    public boolean isActive() {
        return this.myActive;
    }

    public void setActive(boolean active) {
        this.myActive = active;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URLTextRange) {
            URLTextRange r = (URLTextRange)obj;
            return this.myStartOffset == r.myStartOffset && this.myEndOffset == r.myEndOffset && Utils.equals(r.myCodeLink, this.myCodeLink);
        }
        return false;
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0) {
            this.myHash = h = this.myStartOffset + this.myEndOffset + 31 * Comparing.hashcode((Object)this.myCodeLink);
        }
        return h;
    }

    public String toString() {
        return this.myCodeLink + "(" + this.myStartOffset + ".." + this.myEndOffset + ")[" + (this.isActive() ? "Active" : "Passive") + "]";
    }

    public synchronized void shift(int shift) {
        this.myStartOffset += shift;
        this.myEndOffset += shift;
        if (this.myHash != 0) {
            this.myHash += 2 * shift;
        }
    }

    public void addStaticHighlighter(Editor editor) {
        String summary;
        MarkupModel markupModel = editor.getMarkupModel();
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(this.getStartOffset(), this.getEndOffset(), 5000, StyleConstants.STATIC_TEXT_ATTRIBUTES, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setErrorStripeMarkColor(StyleConstants.CORPORATE);
        ArtifactInfoCache cache = Utils.getArtifactInfoCache();
        if (cache != null) {
            ArtifactInfo info = cache.getArtifactInfoSnapshot(this.getURL());
            summary = (String)info.getPresentation(GenericKeys.SUMMARY);
            if (summary == null) {
                summary = "";
            } else if (summary.length() > 40) {
                summary = summary.substring(0, 38) + " ...";
            }
        } else {
            summary = "";
        }
        highlighter.setErrorStripeTooltip((Object)(this.getCodeLink().getCodeFragment() + " " + summary));
        highlighter.putUserData(STATIC_HIGHLIGHTER_KEY, (Object)this);
    }

    public static URLTextRange getFrom(RangeHighlighter highlighter) {
        return (URLTextRange)highlighter.getUserData(STATIC_HIGHLIGHTER_KEY);
    }
}

