/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class DebugUtils {
    private static final Logger logger = Logger.getLogger(DebugUtils.class.getName());

    private static void reconnect(FreeColClient freeColClient) {
        freeColClient.getConnectController().requestLogout(Game.LogoutReason.RECONNECT);
    }

    public static void addBuildings(FreeColClient freeColClient, String title) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        Specification spec = game.getSpecification();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        Function<BuildingType, ChoiceItem> mapper = bt -> new ChoiceItem<BuildingType>(Messages.getName(bt), (BuildingType)bt);
        StringTemplate tmpl = StringTemplate.name(title);
        BuildingType buildingType = (BuildingType)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(spec.getBuildingTypeList(), CollectionUtils.alwaysTrue(), mapper, Comparator.naturalOrder()));
        if (buildingType == null) {
            return;
        }
        ServerGame sGame = server.getGame();
        BuildingType sBuildingType = server.getSpecification().getBuildingType(buildingType.getId());
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        int fails = 0;
        List<Colony> sColonies = sPlayer.getColonyList();
        ArrayList<String> results = new ArrayList<String>(sColonies.size());
        for (Colony sColony : sColonies) {
            Colony.NoBuildReason reason = sColony.getNoBuildReason(sBuildingType, null);
            results.add(sColony.getName() + ": " + reason);
            if (reason == Colony.NoBuildReason.NONE) {
                List<Object> present;
                Building sBuilding = sColony.getBuilding(sBuildingType);
                List<Object> list = present = sBuilding == null ? Collections.emptyList() : sBuilding.getUnitList();
                if (sBuildingType.isDefenceType()) {
                    sColony.getTile().cacheUnseen();
                }
                sBuilding = new ServerBuilding(sGame, sColony, sBuildingType);
                sColony.addBuilding(sBuilding);
                for (Unit unit : present) {
                    unit.setLocation(sBuilding);
                }
                continue;
            }
            ++fails;
        }
        gui.showInformationPanel(StringUtils.join(", ", results));
        if (fails < sPlayer.getSettlementCount()) {
            DebugUtils.reconnect(freeColClient);
        }
    }

    public static void addFathers(FreeColClient freeColClient, String fatherTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        Predicate<FoundingFather> noFatherPred = f -> !sPlayer.hasFather((FoundingFather)f);
        Function<FoundingFather, ChoiceItem> mapper = f -> new ChoiceItem<FoundingFather>(Messages.getName(f), (FoundingFather)f);
        StringTemplate tmpl = StringTemplate.name(fatherTitle);
        FoundingFather father = (FoundingFather)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(sSpec.getFoundingFathers(), noFatherPred, mapper, Comparator.naturalOrder()));
        if (father != null) {
            server.getInGameController().addFoundingFather(sPlayer, father);
        }
    }

    public static void addGold(FreeColClient freeColClient) {
        int gold;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.getInput(null, StringTemplate.template("prompt.selectGold"), Integer.toString(1000), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            gold = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.modifyGold(gold);
        sPlayer.modifyGold(gold);
    }

    public static void addGoodsAdditionEntry(FreeColClient fcc, Unit unit, JPopupMenu menu) {
        JMenuItem addg = new JMenuItem("Add goods");
        addg.setOpaque(false);
        addg.addActionListener(ae -> DebugUtils.addUnitGoods(fcc, unit));
        addg.setEnabled(true);
        menu.add(addg);
    }

    public static void addImmigration(FreeColClient freeColClient) {
        int crosses;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        String response = gui.getInput(null, StringTemplate.template("prompt.selectImmigration"), Integer.toString(100), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            crosses = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        player.modifyImmigration(crosses);
        sPlayer.modifyImmigration(crosses);
    }

    public static void addLiberty(FreeColClient freeColClient) {
        int liberty;
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Player player = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        String response = gui.getInput(null, StringTemplate.template("prompt.selectLiberty"), Integer.toString(100), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            liberty = Integer.parseInt(response);
        }
        catch (NumberFormatException x) {
            return;
        }
        for (Colony c : player.getColonyList()) {
            c.addLiberty(liberty);
            sGame.getFreeColGameObject(c.getId(), Colony.class).addLiberty(liberty);
        }
    }

    public static void addSkipChangeListener(FreeColClient freeColClient, JMenu menu, JMenuItem item) {
        FreeColServer server = freeColClient.getFreeColServer();
        if (server == null) {
            return;
        }
        menu.addChangeListener(e -> {
            boolean skipping = server.getInGameController().getSkippedTurns() > 0;
            item.setText(Messages.message(skipping ? "menuBar.debug.stopSkippingTurns" : "menuBar.debug.skipTurns"));
        });
    }

    public static void addNewUnitToTile(FreeColClient freeColClient, Tile tile) {
        Unit unit;
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        Player player = freeColClient.getMyPlayer();
        Player sPlayer = sGame.getFreeColGameObject(player.getId(), Player.class);
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        GUI gui = freeColClient.getGUI();
        Function<UnitType, ChoiceItem> mapper = ut -> new ChoiceItem<UnitType>(Messages.getName(ut), (UnitType)ut);
        StringTemplate tmpl = StringTemplate.template("prompt.selectUnitType");
        UnitType unitChoice = (UnitType)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(sSpec.getUnitTypeList(), CollectionUtils.alwaysTrue(), mapper, Comparator.naturalOrder()));
        if (unitChoice == null) {
            return;
        }
        Unit sCarrier = sTile.isLand() || unitChoice.isNaval() ? null : CollectionUtils.find(sTile.getUnitList(), u -> u.isNaval() && u.getSpaceLeft() >= unitChoice.getSpaceTaken());
        ServerUnit sUnit = new ServerUnit(sGame, sCarrier != null ? sCarrier : sTile, sPlayer, unitChoice);
        ((ServerPlayer)sPlayer).exploreForUnit(sUnit);
        sUnit.setMovesLeft(sUnit.getInitialMovesLeft());
        sPlayer.invalidateCanSeeTiles();
        DebugUtils.reconnect(freeColClient);
        Game game = freeColClient.getGame();
        if (game != null && (unit = game.getFreeColGameObject(sUnit.getId(), Unit.class)) != null) {
            gui.changeView(unit, false);
        }
    }

    private static void addUnitGoods(FreeColClient freeColClient, Unit unit) {
        int a;
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = sGame.getSpecification();
        GUI gui = freeColClient.getGUI();
        Predicate<GoodsType> goodsPred = gt -> !gt.isFoodType() || gt == sSpec.getPrimaryFoodType();
        Function<GoodsType, ChoiceItem> mapper = gt -> new ChoiceItem<GoodsType>(Messages.getName(gt), (GoodsType)gt);
        StringTemplate tmpl = StringTemplate.template("prompt.selectGoodsType");
        GoodsType goodsType = (GoodsType)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(sSpec.getGoodsTypeList(), goodsPred, mapper, Comparator.naturalOrder()));
        if (goodsType == null) {
            return;
        }
        String amount = gui.getInput(null, StringTemplate.template("prompt.selectGoodsAmount"), "20", "ok", "cancel");
        if (amount == null) {
            return;
        }
        try {
            a = Integer.parseInt(amount);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer ugc = unit.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(ugc.getId(), GoodsContainer.class);
        ugc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void applyDisaster(FreeColClient freeColClient, Colony colony) {
        GUI gui = freeColClient.getGUI();
        Function<RandomChoice, ChoiceItem> mapper = rc -> new ChoiceItem<Disaster>(Messages.getName((Named)rc.getObject()) + " " + Integer.toString(rc.getProbability()), (Disaster)rc.getObject());
        List disasters = CollectionUtils.transform(colony.getDisasterChoices(), CollectionUtils.alwaysTrue(), mapper, Comparator.naturalOrder());
        if (disasters.isEmpty()) {
            gui.showErrorPanel((StringTemplate)StringTemplate.template("error.disasterNotAvailable").addName("%colony%", colony.getName()));
            return;
        }
        StringTemplate tmpl = StringTemplate.template("prompt.selectDisaster");
        Disaster disaster = (Disaster)gui.getChoice(tmpl, "cancel", disasters);
        if (disaster == null) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        ServerColony sColony = sGame.getFreeColGameObject(colony.getId(), ServerColony.class);
        Disaster sDisaster = sGame.getSpecification().getDisaster(disaster.getId());
        if (server.getInGameController().debugApplyDisaster(sColony, sDisaster) <= 0) {
            gui.showErrorPanel((StringTemplate)((StringTemplate)StringTemplate.template("error.disasterAvoided").addName("%colony%", colony.getName())).addNamed("%disaster%", disaster));
        }
        freeColClient.getInGameController().nextModelMessage();
    }

    public static void changeOwnership(FreeColClient freeColClient, Colony colony) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        ServerColony sColony = sGame.getFreeColGameObject(colony.getId(), ServerColony.class);
        GUI gui = freeColClient.getGUI();
        Game game = freeColClient.getGame();
        Function<Player, ChoiceItem> mapper = p -> new ChoiceItem<Player>(Messages.message(p.getCountryLabel()), (Player)p);
        StringTemplate tmpl = StringTemplate.template("prompt.selectOwner");
        Player player = (Player)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(game.getLiveEuropeanPlayers(colony.getOwner()), CollectionUtils.alwaysTrue(), mapper, Comparator.naturalOrder()));
        if (player == null) {
            return;
        }
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        server.getInGameController().debugChangeOwner(sColony, sPlayer);
        Player myPlayer = freeColClient.getMyPlayer();
        if (gui.getActiveUnit() != null && gui.getActiveUnit().getOwner() != myPlayer) {
            freeColClient.getInGameController().nextActiveUnit();
        }
    }

    public static void changeOwnership(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        Game game = unit.getGame();
        Function<Player, ChoiceItem> mapper = p -> new ChoiceItem<Player>(Messages.message(p.getCountryLabel()), (Player)p);
        StringTemplate tmpl = StringTemplate.template("prompt.selectOwner");
        Player player = (Player)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(game.getLivePlayers(new Player[0]), p -> unit.getType().isAvailableTo((FreeColObject)p), mapper, Comparator.naturalOrder()));
        if (player == null || unit.getOwner() == player) {
            return;
        }
        ServerGame sGame = server.getGame();
        ServerUnit sUnit = sGame.getFreeColGameObject(unit.getId(), ServerUnit.class);
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        server.getInGameController().debugChangeOwner(sUnit, sPlayer);
        Player myPlayer = freeColClient.getMyPlayer();
        if (myPlayer.owns(unit)) {
            gui.changeView(unit, true);
        }
    }

    public static void changeRole(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Unit sUnit = sGame.getFreeColGameObject(unit.getId(), Unit.class);
        GUI gui = freeColClient.getGUI();
        Function<Role, ChoiceItem> roleMapper = r -> new ChoiceItem<Role>(r.getId(), (Role)r);
        StringTemplate tmpl = StringTemplate.template("prompt.selectRole");
        Role roleChoice = (Role)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(sGame.getSpecification().getRoles(), CollectionUtils.alwaysTrue(), roleMapper, Comparator.naturalOrder()));
        if (roleChoice == null) {
            return;
        }
        sUnit.changeRole(roleChoice, roleChoice.getMaximumCount());
        DebugUtils.reconnect(freeColClient);
    }

    public static boolean checkDesyncAction(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game cGame = freeColClient.getGame();
        Player cPlayer = freeColClient.getMyPlayer();
        ServerGame sGame = server.getGame();
        Map sMap = sGame.getMap();
        ServerPlayer sPlayer = sGame.getFreeColGameObject(cPlayer.getId(), ServerPlayer.class);
        LogBuilder lb = new LogBuilder(256);
        lb.add("Desynchronization detected\n");
        lb.mark();
        sMap.forEachTile(t -> sPlayer.canSee((Tile)t), t -> DebugUtils.checkDesyncTile(cGame, sPlayer, t, lb));
        boolean problemDetected = lb.grew(new Object[0]);
        boolean goodsProblemDetected = false;
        Market cMarket = cPlayer.getMarket();
        Market sMarket = sPlayer.getMarket();
        if (sMarket != null && cMarket != null) {
            for (GoodsType sg : sGame.getSpecification().getGoodsTypeList()) {
                GoodsType cg;
                int cPrice;
                int sPrice = sMarket.getBidPrice(sg, 1);
                if (sPrice == (cPrice = cMarket.getBidPrice(cg = cGame.getSpecification().getGoodsType(sg.getId()), 1))) continue;
                lb.add("Goods prices for ", sg, " differ: ", sPrice, "!=", cPrice, " ");
                goodsProblemDetected = true;
            }
        }
        if (goodsProblemDetected) {
            lb.add("  Server:\n", sPlayer.getMarket(), "\n", "  Client:\n", cPlayer.getMarket(), "\n");
            problemDetected = true;
        }
        if (problemDetected) {
            lb.shrink("\n");
            String err = lb.toString();
            freeColClient.getGUI().showInformationPanel(err);
            logger.severe(err);
        }
        return problemDetected;
    }

    private static void checkDesyncTile(Game cGame, ServerPlayer sPlayer, Tile sTile, LogBuilder lb) {
        Tile cTile = cGame.getFreeColGameObject(sTile.getId(), Tile.class);
        for (Unit su : CollectionUtils.transform(sTile.getUnits(), u -> sPlayer.canSeeUnit((Unit)u))) {
            Unit cu = cGame.getFreeColGameObject(su.getId(), Unit.class);
            if (cu == null) {
                lb.add("Unit missing on client-side.\n", "  Server: ", su.getDescription(Unit.UnitLabelType.NATIONAL), "(", su.getId(), ") from: ", su.getLocation().getId(), ".\n");
                try {
                    lb.add("  Client: ", cTile.getFirstUnit(), "\n");
                }
                catch (NullPointerException nullPointerException) {}
                continue;
            }
            if (!cu.hasTile() || cu.getTile().getId().equals(su.getTile().getId())) continue;
            lb.add("Unit located on different tiles.\n", "  Server: ", su.getDescription(Unit.UnitLabelType.NATIONAL), "(", su.getId(), ") from: ", su.getLocation().getId(), "\n", "  Client: ", cu.getDescription(Unit.UnitLabelType.NATIONAL), "(", cu.getId(), ") at: ", cu.getLocation().getId(), "\n");
        }
        Settlement sSettlement = sTile.getSettlement();
        Settlement cSettlement = cTile.getSettlement();
        if (sSettlement == null) {
            if (cSettlement != null) {
                lb.add("Settlement still present in client: ", cSettlement);
            }
        } else if (cSettlement == null) {
            lb.add("Settlement not present in client: ", sSettlement);
        } else if (!sSettlement.getId().equals(cSettlement.getId())) {
            lb.add("Settlements differ.\n  Server: ", sSettlement.toString(), "\n  Client: ", cSettlement.toString(), "\n");
        }
    }

    public static void displayColonyPlan(FreeColClient freeColClient, Colony colony) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIColony aiColony = aiMain.getAIColony(colony);
        if (aiColony == null) {
            freeColClient.getGUI().showErrorPanel((StringTemplate)StringTemplate.template("error.notAIColony").addName("%colony%", colony.getName()));
        } else {
            freeColClient.getGUI().showInformationPanel(aiColony.planToString());
        }
    }

    public static String getColonyValue(Tile tile) {
        Player player = FreeColDebugger.debugDisplayColonyValuePlayer();
        if (player == null) {
            return null;
        }
        int value = player.getColonyValue(tile);
        if (value < 0) {
            return Player.NoValueType.fromValue(value).toString();
        }
        return Integer.toString(value);
    }

    public static void displayEurope(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        LogBuilder lb = new LogBuilder(256);
        ArrayList<Unit> inEurope = new ArrayList<Unit>();
        ArrayList<Unit> toEurope = new ArrayList<Unit>();
        ArrayList<Unit> toAmerica = new ArrayList<Unit>();
        HashMap<String, ArrayList<Unit>> units = new HashMap<String, ArrayList<Unit>>();
        for (Player tp : sGame.getLiveEuropeanPlayerList(new Player[0])) {
            Player p = sGame.getFreeColGameObject(tp.getId(), Player.class);
            if (p.getEurope() == null) continue;
            inEurope.clear();
            toEurope.clear();
            toAmerica.clear();
            units.clear();
            units.put(Messages.message("sailingToEurope"), toEurope);
            units.put(Messages.getName(p.getEurope()), inEurope);
            units.put(Messages.message("sailingToAmerica"), toAmerica);
            lb.add("\n==", Messages.message(p.getCountryLabel()), "==\n");
            for (Unit u : p.getEurope().getUnitList()) {
                if (u.getDestination() instanceof Map) {
                    toAmerica.add(u);
                    continue;
                }
                if (u.getDestination() instanceof Europe) {
                    toEurope.add(u);
                    continue;
                }
                inEurope.add(u);
            }
            CollectionUtils.forEachMapEntry(units, e -> DebugUtils.logEurope(aiMain, lb, (String)e.getKey(), (List)e.getValue()));
            lb.add("\n->", Messages.message("immigrants"), "\n\n");
            for (AbstractUnit au : p.getEurope().getExpandedRecruitables(false)) {
                lb.add(Messages.message(au.getSingleLabel()), "\n");
            }
            lb.add("\n");
        }
        freeColClient.getGUI().showInformationPanel(lb.toString());
    }

    private static void logEurope(AIMain aiMain, LogBuilder lb, String label, List<Unit> units) {
        if (units.isEmpty()) {
            return;
        }
        lb.add("\n->", label, "\n");
        for (Unit u : units) {
            lb.add("\n", u.getDescription(Unit.UnitLabelType.NATIONAL));
            if (u.isDamagedAndUnderForcedRepair()) {
                lb.add(" (", Messages.message(u.getRepairLabel()), ")");
                continue;
            }
            lb.add("    ");
            AIUnit aiu = aiMain.getAIUnit(u);
            if (!aiu.hasMission()) {
                lb.add(" (", Messages.message("none"), ")");
                continue;
            }
            lb.add(aiu.getMission().toString().replaceAll("\n", "    \n"));
        }
        lb.add("\n");
    }

    public static void displayMission(FreeColClient freeColClient, Unit unit) {
        FreeColServer server = freeColClient.getFreeColServer();
        AIMain aiMain = server.getAIMain();
        AIUnit aiUnit = aiMain.getAIUnit(unit);
        Mission m = aiUnit.getMission();
        String msg = m == null ? Messages.message("none") : (m instanceof TransportMission ? ((TransportMission)m).toFullString() : m.toString());
        freeColClient.getGUI().showInformationPanel(msg);
    }

    public static void displayUnits(FreeColClient freeColClient) {
        Unit u;
        Player player = freeColClient.getMyPlayer();
        Set<Unit> all = player.getUnitSet();
        LogBuilder lb = new LogBuilder(256);
        lb.add("\nActive units:\n");
        Unit first = player.getNextActiveUnit();
        if (first != null) {
            lb.add(first.toString(), "\nat ", first.getLocation(), "\n");
            all.remove(first);
            while (player.hasNextActiveUnit() && (u = player.getNextActiveUnit()) != first) {
                lb.add(u, "\nat ", u.getLocation(), "\n");
                all.remove(u);
            }
        }
        lb.add("Going-to units:\n");
        first = player.getNextGoingToUnit();
        if (first != null) {
            all.remove(first);
            lb.add(first, "\nat ", first.getLocation(), "\n");
            while (player.hasNextGoingToUnit() && (u = player.getNextGoingToUnit()) != first) {
                lb.add(u, "\nat ", u.getLocation(), "\n");
                all.remove(u);
            }
        }
        lb.add("Remaining units:\n");
        for (Unit x : all) {
            lb.add(x, "\nat ", x.getLocation(), "\n");
        }
        freeColClient.getGUI().showInformationPanel(lb.toString());
    }

    public static void dumpTile(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        System.err.println("\nClient (" + game.getClientUserName() + "/" + player.getId() + "):");
        tile.save(System.err, FreeColXMLWriter.WriteScope.toClient(player), true);
        System.err.println("\n\nServer:");
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        sTile.save(System.err, FreeColXMLWriter.WriteScope.toServer(), true);
        System.err.println("\n\nSave:");
        sTile.save(System.err, FreeColXMLWriter.WriteScope.toSave(), true);
        System.err.println('\n');
    }

    public static void resetMoves(FreeColClient freeColClient, List<Unit> units) {
        if (units.isEmpty()) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        GUI gui = freeColClient.getGUI();
        for (Unit u : units) {
            Unit su = sGame.getFreeColGameObject(u.getId(), Unit.class);
            u.setMovesLeft(u.getInitialMovesLeft());
            su.setMovesLeft(su.getInitialMovesLeft());
            for (Unit u2 : u.getUnitList()) {
                Unit su2 = sGame.getFreeColGameObject(u2.getId(), Unit.class);
                u2.setMovesLeft(u2.getInitialMovesLeft());
                su2.setMovesLeft(su2.getInitialMovesLeft());
            }
        }
        Unit unit = units.get(0);
        gui.changeView(unit, true);
    }

    public static void revealMap(FreeColClient freeColClient, boolean reveal) {
        FreeColServer server = freeColClient.getFreeColServer();
        Game game = freeColClient.getGame();
        Specification spec = game.getSpecification();
        server.exploreMapForAllPlayers(reveal);
        if (reveal) {
            FreeColDebugger.setNormalGameFogOfWar(spec.getBoolean("model.option.fogOfWar"));
            spec.setBoolean("model.option.fogOfWar", false);
        } else {
            spec.setBoolean("model.option.fogOfWar", FreeColDebugger.getNormalGameFogOfWar());
        }
    }

    public static void setColonyGoods(FreeColClient freeColClient, Colony colony) {
        int a;
        Specification spec = colony.getSpecification();
        GUI gui = freeColClient.getGUI();
        Predicate<GoodsType> goodsPred = gt -> !gt.isFoodType() || gt == spec.getPrimaryFoodType();
        Function<GoodsType, ChoiceItem> mapper = gt -> new ChoiceItem<GoodsType>(Messages.getName(gt), (GoodsType)gt);
        StringTemplate tmpl = StringTemplate.template("prompt.selectGoodsType");
        GoodsType goodsType = (GoodsType)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(spec.getGoodsTypeList(), goodsPred, mapper, Comparator.naturalOrder()));
        if (goodsType == null) {
            return;
        }
        String response = gui.getInput(null, StringTemplate.template("prompt.selectGoodsAmount"), Integer.toString(colony.getGoodsCount(goodsType)), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            a = Integer.parseInt(response);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Specification sSpec = server.getSpecification();
        GoodsType sGoodsType = sSpec.getGoodsType(goodsType.getId());
        GoodsContainer cgc = colony.getGoodsContainer();
        GoodsContainer sgc = sGame.getFreeColGameObject(cgc.getId(), GoodsContainer.class);
        cgc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
    }

    public static void setCommsLogging(FreeColClient freeColClient, boolean log) {
        FreeColServer server = freeColClient.getFreeColServer();
        if (server != null) {
            server.getServer().setCommsLogging(log);
        }
    }

    public static void setMonarchAction(FreeColClient freeColClient, String monarchTitle) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Player player = freeColClient.getMyPlayer();
        ServerPlayer sPlayer = sGame.getFreeColGameObject(player.getId(), ServerPlayer.class);
        GUI gui = freeColClient.getGUI();
        Function<Monarch.MonarchAction, ChoiceItem> mapper = a -> new ChoiceItem<Monarch.MonarchAction>((Monarch.MonarchAction)((Object)a));
        StringTemplate tmpl = StringTemplate.name(monarchTitle);
        Monarch.MonarchAction action = (Monarch.MonarchAction)((Object)gui.getChoice(tmpl, "cancel", CollectionUtils.transform(Monarch.MonarchAction.values(), CollectionUtils.alwaysTrue(), mapper, Comparator.naturalOrder())));
        if (action == null) {
            return;
        }
        server.getInGameController().setMonarchAction(sPlayer, action);
    }

    public static void setRumourType(FreeColClient freeColClient, Tile tile) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Tile sTile = sGame.getFreeColGameObject(tile.getId(), Tile.class);
        Predicate<LostCityRumour.RumourType> realRumourPred = r -> r != LostCityRumour.RumourType.NO_SUCH_RUMOUR;
        Function<LostCityRumour.RumourType, ChoiceItem> mapper = r -> new ChoiceItem<LostCityRumour.RumourType>(r.toString(), (LostCityRumour.RumourType)((Object)r));
        StringTemplate tmpl = StringTemplate.template("prompt.selectLostCityRumour");
        LostCityRumour.RumourType rumourChoice = (LostCityRumour.RumourType)((Object)freeColClient.getGUI().getChoice(tmpl, "cancel", CollectionUtils.transform(LostCityRumour.RumourType.values(), realRumourPred, mapper, Comparator.naturalOrder())));
        if (rumourChoice == null) {
            return;
        }
        tile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
        sTile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
    }

    public static void showForeignColony(FreeColClient freeColClient, Colony colony) {
        if (colony == null || !FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            return;
        }
        FreeColServer server = freeColClient.getFreeColServer();
        if (server == null) {
            return;
        }
        colony = server.getGame().getFreeColGameObject(colony.getId(), Colony.class);
        freeColClient.getGUI().showColonyPanel(colony, null);
    }

    public static void skipTurns(FreeColClient freeColClient) {
        int skip;
        FreeColServer server = freeColClient.getFreeColServer();
        if (server != null && server.getInGameController().getSkippedTurns() > 0) {
            freeColClient.skipTurns(0);
            return;
        }
        freeColClient.skipTurns(0);
        String response = freeColClient.getGUI().getInput(null, StringTemplate.key("prompt.selectTurnsToSkip"), Integer.toString(10), "ok", "cancel");
        if (response == null || response.isEmpty()) {
            return;
        }
        try {
            skip = Integer.parseInt(response);
        }
        catch (NumberFormatException nfe) {
            skip = -1;
        }
        if (skip > 0) {
            freeColClient.skipTurns(skip);
        }
    }

    public static void statistics(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        Game cGame = freeColClient.getGame();
        GUI gui = freeColClient.getGUI();
        java.util.Map<String, String> serverStats = sGame.getStatistics();
        serverStats.putAll(server.getAIMain().getAIStatistics());
        java.util.Map<String, String> clientStats = cGame.getStatistics();
        gui.showStatisticsPanel(serverStats, clientStats);
    }

    public static void stepRNG(FreeColClient freeColClient) {
        FreeColServer server = freeColClient.getFreeColServer();
        GUI gui = freeColClient.getGUI();
        boolean more = true;
        while (more) {
            int val = server.getInGameController().stepRandom();
            more = gui.confirm((StringTemplate)StringTemplate.template("prompt.stepRNG").addAmount("%value%", val), "more", "cancel");
        }
    }

    public static void summarizeSettlement(FreeColClient freeColClient, IndianSettlement is) {
        FreeColServer server = freeColClient.getFreeColServer();
        ServerGame sGame = server.getGame();
        AIMain aiMain = server.getAIMain();
        Specification sSpec = sGame.getSpecification();
        IndianSettlement sis = sGame.getFreeColGameObject(is.getId(), IndianSettlement.class);
        List<GoodsType> sGoodsTypes = sSpec.getGoodsTypeList();
        LogBuilder lb = new LogBuilder(256);
        lb.add(sis.getName(), "\n\nAlarm\n");
        Player mostHated = sis.getMostHated();
        for (Player p : sGame.getLiveEuropeanPlayerList(new Player[0])) {
            Tension tension = sis.getAlarm(p);
            lb.add(new Object[]{Messages.message(p.getNationLabel()), " ", tension == null ? "(none)" : Integer.toString(tension.getValue()), mostHated == p ? " (most hated)" : "", " ", Messages.message(sis.getAlarmLevelKey(p)), " ", sis.getContactLevel(p), "\n"});
        }
        lb.add("\nGoods\n");
        for (GoodsType gt : sGoodsTypes) {
            int amount = sis.getGoodsCount(gt);
            int prod = sis.getTotalProductionOf(gt);
            if (amount <= 0 && prod == 0) continue;
            lb.add(Messages.message(new AbstractGoods(gt, amount).getLabel()), " ", prod > 0 ? "+" : "", prod, "\n");
        }
        lb.add("\nPotential sales\n");
        for (Goods g : sis.getSellGoods(null)) {
            lb.add(Messages.getName(g.getType()), " ", g.getAmount(), " = ", sis.getPriceToSell(g.getType(), g.getAmount()), "\n");
        }
        lb.add("\nPrices (buy 1/100 / sell 1/100)\n");
        List<GoodsType> wanted = sis.getWantedGoods();
        for (GoodsType type : sSpec.getStorableGoodsTypeList()) {
            int idx = wanted.indexOf(type);
            lb.add(Messages.getName(type), ": ", sis.getPriceToBuy(type, 1), "/", sis.getPriceToBuy(type, 100), " / ", sis.getPriceToSell(type, 1), "/", sis.getPriceToSell(type, 100), idx < 0 ? "" : " wanted[" + Integer.toString(idx) + "]", "\n");
        }
        lb.add("\nUnits present\n");
        for (Unit u : sis.getUnitList()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            lb.add(u, " at ", u.getLocation());
            if (m != null) {
                lb.add(" ", m.getClass(), ".");
            }
            lb.add("\n");
        }
        lb.add("\nUnits owned\n");
        for (Unit u : sis.getOwnedUnitList()) {
            Mission m = aiMain.getAIUnit(u).getMission();
            lb.add(u, " at ", u.getLocation());
            if (m != null) {
                lb.add(" ", m.getClass(), ".");
            }
            lb.add("\n");
        }
        lb.add("\nTiles\n");
        for (Tile t : sis.getOwnedTiles()) {
            lb.add(t, "\n");
        }
        lb.add("\nConvert Progress = ", sis.getConvertProgress());
        lb.add("\nLast Tribute = ", sis.getLastTribute());
        freeColClient.getGUI().showInformationPanel(lb.toString());
    }
}

