/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public abstract class UnitLocation
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(UnitLocation.class.getName());
    private final List<Unit> units = new ArrayList<Unit>();

    public UnitLocation(Game game) {
        super(game);
    }

    public UnitLocation(Game game, String id) {
        super(game, id);
    }

    @Override
    public void intern() {
        super.intern();
        for (Unit u : this.units) {
            u.intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addUnit(Unit u) {
        if (u == null) {
            return false;
        }
        boolean ret = false;
        u.setLocationNoUpdate(this);
        List<Unit> list = this.units;
        synchronized (list) {
            ret = this.units.add(u);
        }
        return ret;
    }

    public final boolean isEmpty() {
        return this.getUnitCount() == 0;
    }

    public final boolean isFull() {
        return this.getUnitCount() >= this.getUnitCapacity();
    }

    public final Unit getFirstUnit() {
        return CollectionUtils.first(this.getUnits());
    }

    public final Unit getLastUnit() {
        if (this.isEmpty()) {
            return null;
        }
        List<Unit> units = this.getUnitList();
        return units.get(units.size() - 1);
    }

    public int getTotalUnitCount() {
        return CollectionUtils.sum(this.getUnits(), u -> 1 + u.getUnitCount());
    }

    public boolean hasCarrierWithSpace(int space) {
        return CollectionUtils.any(this.getUnits(), u -> u.isCarrier() && !u.isDamagedAndUnderForcedRepair() && u.getSpaceLeft() >= space);
    }

    public List<Unit> getNavalUnits() {
        return CollectionUtils.transform(this.getUnits(), Unit::isNaval);
    }

    public Unit getCarrierForUnit(Unit unit) {
        return CollectionUtils.find(this.getUnits(), u -> u.couldCarry(unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<FreeColGameObject> getDisposables() {
        List<Unit> list = this.units;
        synchronized (list) {
            return CollectionUtils.concat(CollectionUtils.flatten(this.units, GoodsLocation::getDisposables), super.getDisposables());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeResources() {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.clear();
        }
        super.disposeResources();
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key(this.getId());
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.getLocationLabel();
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (this.contains(unit)) {
                return true;
            }
            if (this.canAdd(unit)) {
                return this.addUnit(unit);
            }
        } else {
            if (locatable instanceof Goods) {
                locatable.setLocation(null);
                logger.finest("Dumped " + locatable + " in UnitLocation with id " + this.getId());
                return true;
            }
            logger.warning("Tried to add Locatable " + locatable + " to UnitLocation with id " + this.getId() + ".");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            List<Unit> list = this.units;
            synchronized (list) {
                if (!this.units.remove(unit)) {
                    return false;
                }
            }
            unit.setLocationNoUpdate(null);
            return true;
        }
        logger.warning("Tried to remove non-Unit " + locatable + " from UnitLocation: " + this.getId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            return false;
        }
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.contains(locatable);
        }
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return this.getNoAddReason(locatable) == NoAddReason.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnitCount() {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<Unit> getUnits() {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Unit> getUnitList() {
        List<Unit> list = this.units;
        synchronized (list) {
            return this.units.isEmpty() ? Collections.emptyList() : new ArrayList<Unit>(this.units);
        }
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public Colony getColony() {
        Settlement settlement = this.getSettlement();
        return settlement instanceof Colony ? (Colony)settlement : null;
    }

    @Override
    public IndianSettlement getIndianSettlement() {
        Settlement settlement = this.getSettlement();
        return settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
    }

    public int getSpaceTaken() {
        return CollectionUtils.sum(this.getUnits(), Unit::getSpaceTaken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToFront(Unit u) {
        List<Unit> list = this.units;
        synchronized (list) {
            if (this.units.remove(u)) {
                this.units.add(0, u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearUnitList() {
        List<Unit> list = this.units;
        synchronized (list) {
            this.units.clear();
        }
    }

    public NoAddReason getNoAddReason(Locatable locatable) {
        Unit unit;
        Unit unit2 = unit = locatable instanceof Unit ? (Unit)locatable : null;
        return unit == null ? NoAddReason.WRONG_TYPE : (!this.isEmpty() && this.getFirstUnit().getOwner() != unit.getOwner() ? NoAddReason.OCCUPIED_BY_ENEMY : (this.contains(unit) ? NoAddReason.ALREADY_PRESENT : (unit.getSpaceTaken() + this.getSpaceTaken() > this.getUnitCapacity() ? NoAddReason.CAPACITY_EXCEEDED : NoAddReason.NONE)));
    }

    public int getUnitCapacity() {
        return Integer.MAX_VALUE;
    }

    public int priceGoods(List<AbstractGoods> goods) throws FreeColException {
        if (goods.isEmpty()) {
            return 0;
        }
        throw new FreeColException("Not available: " + goods.get(0));
    }

    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        return false;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        UnitLocation o = this.copyInCast(other, UnitLocation.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.clearUnitList();
        for (Unit u : o.units) {
            Unit nu = game.update(u, true);
            this.addUnit(nu);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        List<Unit> list = this.units;
        synchronized (list) {
            for (Unit unit : this.units) {
                if (unit.getLocation() != this) {
                    logger.warning("UnitLocation " + this + " contains unit " + unit + " with bogus location " + unit.getLocation() + ", fixing.");
                    unit.setLocationNoUpdate(this);
                }
                unit.toXML(xw);
            }
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearUnitList();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if ("unit".equals(tag)) {
            this.addUnit(xr.readFreeColObject(this.getGame(), Unit.class));
        } else {
            super.readChild(xr);
        }
    }

    public static enum NoAddReason {
        NONE,
        ALREADY_PRESENT,
        WRONG_TYPE,
        CAPACITY_EXCEEDED,
        OCCUPIED_BY_ENEMY,
        OWNED_BY_ENEMY,
        ANOTHER_COLONY,
        COLONY_CENTER,
        MISSING_ABILITY,
        MISSING_SKILL,
        MINIMUM_SKILL,
        MAXIMUM_SKILL,
        CLAIM_REQUIRED,
        WORKER_DAMAGED;


        private String getKey() {
            return "noAddReason." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }
    }
}

