/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class LoadGoodsMessage
extends AttributeMessage {
    public static final String TAG = "loadGoods";
    private static final String AMOUNT_TAG = "amount";
    private static final String CARRIER_TAG = "carrier";
    private static final String LOCATION_TAG = "location";
    private static final String TYPE_TAG = "type";

    public LoadGoodsMessage(Location loc, GoodsType type, int amount, Unit carrier) {
        super(TAG, LOCATION_TAG, loc.getId(), TYPE_TAG, type.getId(), AMOUNT_TAG, String.valueOf(amount), CARRIER_TAG, carrier.getId());
    }

    public LoadGoodsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, LOCATION_TAG, TYPE_TAG, AMOUNT_TAG, CARRIER_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        int amount;
        Unit carrier;
        ServerGame game = freeColServer.getGame();
        Specification spec = freeColServer.getSpecification();
        String locationId = this.getStringAttribute(LOCATION_TAG);
        String typeId = this.getStringAttribute(TYPE_TAG);
        String carrierId = this.getStringAttribute(CARRIER_TAG);
        String amountString = this.getStringAttribute(AMOUNT_TAG);
        FreeColGameObject fcgo = game.getFreeColGameObject(locationId);
        if (!(fcgo instanceof Location)) {
            return serverPlayer.clientError("Not a location: " + locationId);
        }
        try {
            carrier = serverPlayer.getOurFreeColGameObject(carrierId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return serverPlayer.clientError("Not a goods carrier: " + carrierId);
        }
        if (carrier.getTradeLocation() == null) {
            return serverPlayer.clientError("Not at a trade location: " + carrierId);
        }
        GoodsType type = spec.getGoodsType(typeId);
        if (type == null) {
            return serverPlayer.clientError("Not a goods type: " + typeId);
        }
        try {
            amount = Integer.parseInt(amountString);
        }
        catch (NumberFormatException e) {
            return serverPlayer.clientError("Bad amount: " + amountString);
        }
        if (amount <= 0) {
            return serverPlayer.clientError("Amount must be positive: " + amountString);
        }
        return this.igc(freeColServer).loadGoods(serverPlayer, (Location)((Object)fcgo), type, amount, carrier);
    }
}

