/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class ClassGeneratorSuffixRegistry {
    private static final Map<String, Throwable> SUFFIXES = new ConcurrentHashMap<String, Throwable>();

    public static String register(String suffix) {
        Throwable previous = SUFFIXES.putIfAbsent(suffix, ClassGeneratorSuffixRegistry.markerForSuffix(suffix));
        if (previous != null) {
            throw new IllegalStateException("A class generator with suffix '" + suffix + "' is already registered.", previous);
        }
        return suffix;
    }

    public static String assign(String suffix) {
        if (SUFFIXES.putIfAbsent(suffix, ClassGeneratorSuffixRegistry.markerForSuffix(suffix)) == null) {
            return suffix;
        }
        int index = 1;
        String suffixWithIndex;
        while (SUFFIXES.putIfAbsent(suffixWithIndex = suffix + index, ClassGeneratorSuffixRegistry.markerForSuffix(suffixWithIndex)) != null) {
            ++index;
        }
        return suffixWithIndex;
    }

    @Nonnull
    private static RuntimeException markerForSuffix(String suffix) {
        return new RuntimeException("Class generated with suffix '" + suffix + "' registered.");
    }
}

