/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.broker.Broker;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;

public class DataQuery {
    public static final int UNKNOWN = 0;
    public static final int EXISTS = 1;
    public static final int READENTRY = 2;
    public static final int LIST = 4;
    public static final int SEARCH = 8;
    public static final int MODIFY = 16;
    public static final int COPY = 32;
    public static final int GETRECOC = 128;
    public static final int EXTENDED = 256;
    protected Vector listeners = new Vector();
    protected int type = 0;
    static int noRequests = 0;
    public int id;
    protected boolean myStatus = false;
    protected ArrayList myArrayList = null;
    protected DXEntry myEntry = null;
    protected DXNamingEnumeration myEnum = null;
    protected Exception myEx = null;
    protected DN requestDN = null;
    protected DN oldDN = null;
    protected DXEntry oldEntry = null;
    protected DXEntry newEntry = null;
    protected String filter = null;
    protected String[] returnAttrs = null;
    protected int searchLevel = 2;
    protected Hashtable extendedData = null;
    protected boolean ready = false;
    protected boolean cancelled = false;
    protected boolean working = false;
    protected boolean squelched = false;

    public DataQuery() {
        this.id = noRequests++;
    }

    public DataQuery(int type) {
        this.type = type;
        if (type == 256) {
            this.extendedData = new Hashtable();
        }
        this.id = noRequests++;
    }

    public DataQuery(int type, DN dn) {
        this(type);
        this.requestDN = dn;
        if (type != 4 && type != 2 && type != 1) {
            this.setException(new Exception("Bad Constructor call (ii) for DataQuery of Type " + type));
        }
    }

    public DataQuery(int type, DN oldDN, DN newDN) {
        this(type);
        this.requestDN = newDN;
        this.oldDN = oldDN;
        if (type != 32) {
            this.setException(new Exception("Bad Constructor call (iii) for DataQuery of Type " + type));
        }
    }

    public DataQuery(int type, DXEntry oldEntry, DXEntry newEntry) {
        this(type);
        this.oldEntry = oldEntry;
        this.newEntry = newEntry;
        if (type != 16) {
            this.setException(new Exception("Bad Constructor call (iv) for DataQuery of Type " + type));
        }
    }

    public DataQuery(int type, DN dn, String filter, int level, String[] returnAttrs) {
        this(type);
        this.requestDN = dn;
        this.filter = filter;
        this.returnAttrs = returnAttrs;
        this.searchLevel = level;
        if (type != 8) {
            this.setException(new Exception("Bad Constructor call (v) for DataQuery of Type " + type));
        }
    }

    public void squelch() {
        this.squelched = true;
        this.myArrayList = null;
        this.myEntry = null;
        this.myEnum = null;
        this.myEx = null;
        this.requestDN = null;
        this.oldDN = null;
        this.oldEntry = null;
        this.newEntry = null;
        this.filter = null;
    }

    public boolean isSquelched() {
        return this.squelched;
    }

    public void cancel() {
        this.cancelled = true;
        this.setException(new Exception("Request Cancelled"));
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setRunning() {
        this.working = true;
    }

    public boolean isRunning() {
        return this.working;
    }

    public synchronized void finish() {
        if (this.ready) {
            return;
        }
        this.ready = true;
        if (!this.cancelled) {
            this.notifyAll();
            this.fireDataEvent();
        }
        this.working = false;
    }

    protected void fireDataEvent() {
        while (this.listeners.size() > 0 && !this.squelched) {
            DataListener current = (DataListener)this.listeners.lastElement();
            this.listeners.removeElementAt(this.listeners.size() - 1);
            current.dataReady(this);
        }
    }

    public String getTypeString() {
        switch (this.type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Existance check";
            }
            case 2: {
                return "Read entry";
            }
            case 4: {
                return "List";
            }
            case 8: {
                return "Search";
            }
            case 16: {
                return "Modify";
            }
            case 32: {
                return "Copy";
            }
            case 256: {
                return "Extended request";
            }
        }
        return "UNDEFINED";
    }

    public String toString() {
        String ret = "query (" + this.id + "): " + this.getTypeString();
        if (this.type == 8) {
            ret = ret + " filter: " + this.filter;
        } else if (this.requestDN != null) {
            ret = ret + " on " + this.requestDN;
        }
        if (!this.ready()) {
            return ret + " : (request pending)";
        }
        return ret + " : (completed)";
    }

    public Object getResult() {
        try {
            switch (this.type) {
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return new Boolean(this.getStatus());
                }
                case 2: {
                    return this.getEntry();
                }
                case 4: {
                    return this.getEnumeration();
                }
                case 8: {
                    return this.getEnumeration();
                }
                case 16: {
                    return new Boolean(this.getStatus());
                }
                case 32: {
                    return new Boolean(this.getStatus());
                }
                case 256: {
                    return this.getAllExtendedData();
                }
            }
            return "UNDEFINED";
        }
        catch (NamingException e) {
            return e;
        }
    }

    public DataQuery setArrayList(ArrayList v) {
        this.myArrayList = v;
        return this;
    }

    public DataQuery setStatus(boolean b) {
        this.myStatus = b;
        return this;
    }

    public DataQuery setEntry(DXEntry d) {
        this.myEntry = d;
        return this;
    }

    public DataQuery setEnum(DXNamingEnumeration d) {
        this.myEnum = d;
        return this;
    }

    public DataQuery setException(Exception e) {
        this.myEx = e;
        return this;
    }

    public boolean ready() {
        return this.ready;
    }

    public synchronized void addDataListener(DataListener l) {
        if (this.ready) {
            l.dataReady(this);
        } else {
            this.listeners.add(l);
        }
    }

    synchronized void keepWaiting() throws NamingException {
        String current = Thread.currentThread().getName();
        if ("jndiBroker Thread searchBroker Thread schemaBroker Thread".indexOf(current) > -1) {
            System.err.println("ERROR - Thread " + current + " possibly blocking on self");
            throw new NamingException("Thread Blockage (?) during Naming operation - attempt to force immediate data read from: " + current + " thread.  Consider using unthreaded Broker classes rather than DataQuery.");
        }
        try {
            this.notifyAll();
            this.wait();
        }
        catch (InterruptedException e) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " interrupted in DataQuery:keepWaiting() loop \n    " + e);
        }
    }

    public boolean getStatus() throws NamingException {
        while (!this.ready()) {
            this.keepWaiting();
        }
        if (this.type == 16 || this.type == 32 || this.type == 1) {
            return this.myStatus;
        }
        throw new NamingException("Improper call of getStatus for a DataQuery of Type " + this.getTypeString());
    }

    public DXNamingEnumeration getEnumeration() throws NamingException {
        try {
            while (!this.ready()) {
                this.keepWaiting();
            }
            if (this.type == 4 || this.type == 8) {
                return this.myEnum;
            }
            throw new NamingException("Improper call of getNameClassPairs for a DataQuery of Type " + this.getTypeString());
        }
        catch (NamingException e) {
            throw new NamingException(e.toString());
        }
    }

    public DXEntry getEntry() throws NamingException {
        while (!this.ready()) {
            this.keepWaiting();
        }
        if (this.type == 2) {
            return this.myEntry;
        }
        throw new NamingException("Improper call of getEntry for a DataQuery of Type " + this.getTypeString());
    }

    public ArrayList getObjectClasses() throws NamingException {
        while (!this.ready()) {
            this.keepWaiting();
        }
        if (this.type == 128) {
            return this.myArrayList;
        }
        throw new NamingException("Improper call of getObjectClasses for a DataQuery of Type " + this.getTypeString());
    }

    public Exception getException() {
        try {
            while (!this.ready()) {
                this.keepWaiting();
            }
        }
        catch (NamingException e) {
            return e;
        }
        return this.myEx;
    }

    public boolean hasException() {
        try {
            while (!this.ready()) {
                this.keepWaiting();
            }
        }
        catch (NamingException e) {
            this.myEx = e;
            return true;
        }
        return this.myEx != null;
    }

    public void clearException() {
        this.myEx = null;
    }

    public int getType() {
        return this.type;
    }

    public DN requestDN() {
        return this.requestDN == null ? null : new DN(this.requestDN);
    }

    public DN oldDN() {
        return this.oldDN == null ? null : new DN(this.oldDN);
    }

    public DXEntry oldEntry() {
        return this.oldEntry == null ? null : new DXEntry(this.oldEntry);
    }

    public DXEntry newEntry() {
        return this.newEntry == null ? null : new DXEntry(this.newEntry);
    }

    public String filter() {
        return this.filter == null ? null : this.filter;
    }

    public String[] returnAttributes() {
        return this.returnAttrs == null ? null : this.returnAttrs;
    }

    public int searchLevel() {
        return this.searchLevel;
    }

    public Hashtable getAllExtendedData() {
        return this.extendedData;
    }

    public Object getExtendedData(String name) {
        return this.extendedData.get(name.toLowerCase());
    }

    public void setExtendedData(String name, Object o) {
        if (this.extendedData != null) {
            this.extendedData.put(name.toLowerCase(), o);
        }
    }

    public void doExtendedRequest(Broker b) {
    }
}

