/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.DataSource;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.search.ReturnAttributesDisplay;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public class SearchModel {
    public static ReturnAttributesDisplay rat = null;
    protected Properties properties;
    protected String localDir;
    protected ArrayList dependantFilters = new ArrayList();
    protected ArrayList tempList = new ArrayList();
    protected String searchFilterConfig;
    static final String SEARCH_FILTER_FILENAME = "search_filters.txt";
    static final String NAME = "JXFilter.";
    static final String TEXTNAME = "JXTextFilter.";
    public static final int BUILDFILTER = 1;
    public static final int ALLFILTERS = 2;
    public static final int JOINFILTER = 3;
    public static final int TEXTFILTER = 4;
    public static final int FULLNAMES = 5;
    public static final int BUILDJOIN = 6;
    public static final String BASEDN = "baseDN";
    public static final String RETATTRS = "retAttrs";
    public static final String SEARCHLEVEL = "searchLevel";
    public static final String FIND = "find";
    public static final String SEARCH = "search";
    private static Logger log = Logger.getLogger(SearchModel.class.getName());

    public SearchModel() {
        this.properties = new Properties();
        this.searchFilterConfig = CBUtility.getPropertyConfigPath(SEARCH_FILTER_FILENAME);
        if (!new File(this.searchFilterConfig).exists()) {
            log.info("no search filter config file found at: " + this.searchFilterConfig);
            return;
        }
        this.properties = CBUtility.readPropertyFile(this.searchFilterConfig);
        if (this.properties.size() == 0) {
            log.info("Initialising config file: " + this.searchFilterConfig);
            return;
        }
    }

    public void openRetAttrDisplay(JXplorer jx, String[] attrNames, DataSource ds) {
        rat = new ReturnAttributesDisplay(jx, attrNames);
        rat.registerDataSource(ds);
    }

    protected Enumeration getAllFilters() {
        this.properties = CBUtility.readPropertyFile(this.searchFilterConfig);
        return this.properties.propertyNames();
    }

    public ArrayList getFilterNames(int type) {
        Enumeration list = this.getAllFilters();
        ArrayList<String> loadList = new ArrayList<String>();
        block8: while (list.hasMoreElements()) {
            String temp = list.nextElement().toString();
            switch (type) {
                case 1: {
                    if (!this.properties.get(temp).toString().startsWith("(") || !temp.startsWith(NAME)) continue block8;
                    loadList.add(temp.substring(temp.indexOf(NAME) + 9));
                    continue block8;
                }
                case 2: {
                    if (temp.startsWith(NAME)) {
                        loadList.add(temp.substring(temp.indexOf(NAME) + 9));
                        continue block8;
                    }
                    if (!temp.startsWith(TEXTNAME)) continue block8;
                    loadList.add(temp.substring(temp.indexOf(NAME) + 14));
                    continue block8;
                }
                case 3: {
                    if (this.properties.get(temp).toString().startsWith("(") || !temp.startsWith(NAME)) continue block8;
                    loadList.add(temp.substring(temp.indexOf(NAME) + 9));
                    continue block8;
                }
                case 4: {
                    if (!temp.startsWith(TEXTNAME)) continue block8;
                    loadList.add(temp.substring(temp.indexOf(NAME) + 14));
                    continue block8;
                }
                case 5: {
                    if (!temp.startsWith(NAME) && !temp.startsWith(TEXTNAME)) continue block8;
                    loadList.add(temp);
                    continue block8;
                }
                case 6: {
                    if (!temp.startsWith(NAME)) continue block8;
                    loadList.add(temp.substring(temp.indexOf(NAME) + 9));
                    continue block8;
                }
            }
            loadList.add("");
        }
        return loadList;
    }

    public String getFilter(String name) {
        if (name.startsWith(NAME)) {
            return this.properties.getProperty(name);
        }
        return this.properties.getProperty(NAME + name);
    }

    public String getTextFilter(String name) {
        return this.properties.getProperty(TEXTNAME + name);
    }

    public String getLDAPFilter(String name) {
        ArrayList list = this.getFilterNames(1);
        if (list.contains(name.substring(9))) {
            return this.properties.getProperty(name);
        }
        list.clear();
        list = this.getFilterNames(3);
        if (list.contains(name.substring(9))) {
            return this.getJoinFilter(this.properties.getProperty(name));
        }
        list.clear();
        list = this.getFilterNames(4);
        return this.properties.getProperty(name);
    }

    protected int getOccurences(String string, String substring) {
        int pos = -1;
        int count = 0;
        while ((pos = string.indexOf(substring, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    protected ArrayList getJoinFilterNames(String filter) {
        ArrayList<String> list = new ArrayList<String>();
        int num = this.getOccurences(filter, "JXFilter");
        for (int i = 0; i < num; ++i) {
            String names;
            try {
                names = filter.substring(filter.indexOf(NAME) + 9);
                names = names.substring(0, names.indexOf(NAME));
            }
            catch (Exception e) {
                names = filter.substring(filter.indexOf(NAME) + 9);
            }
            filter = filter.substring(filter.indexOf(names) + names.length());
            list.add(names);
        }
        return list;
    }

    protected String getJoinFilter(String filter) {
        StringBuffer buffy = new StringBuffer();
        this.getOperator(buffy, filter);
        return buffy.toString();
    }

    public void getOperator(StringBuffer buffy, String filter) {
        int i;
        if (filter == null) {
            log.warning("Unexpected error in processing a search filter: no filter supplied.");
            return;
        }
        int count = 0;
        if (filter.startsWith("!")) {
            buffy.append("(!");
            ++count;
            filter = filter.substring(1);
        }
        if (filter.startsWith("&")) {
            buffy.append("(&");
            ++count;
            filter = filter.substring(1);
        } else if (filter.startsWith("|")) {
            buffy.append("(|");
            ++count;
            filter = filter.substring(1);
        }
        ArrayList list = this.getJoinFilterNames(filter);
        String[] names = list.toArray(new String[list.size()]);
        for (i = 0; i < names.length; ++i) {
            String name = names[i];
            this.getValue(buffy, name);
        }
        for (i = 0; i < count; ++i) {
            buffy.append(")");
        }
    }

    protected void getValue(StringBuffer buffy, String filter) {
        ArrayList list = this.getFilterNames(1);
        if (list.contains(filter)) {
            buffy.append(this.getFilter(filter));
        } else {
            this.getOperator(buffy, this.getFilter(filter));
        }
    }

    protected boolean exists(String name) {
        if (this.properties.containsKey(NAME + name)) {
            return true;
        }
        return this.properties.containsKey(TEXTNAME + name);
    }

    protected boolean isTextFilter(String name) {
        return this.properties.containsKey(TEXTNAME + name);
    }

    protected void saveFilter(String name, String filter) {
        this.properties.setProperty(NAME + name, filter);
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    protected void saveTextFilter(String name, String filter) {
        this.properties.setProperty(TEXTNAME + name, filter);
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    protected void saveValue(String name, String type, String value) {
        this.properties.setProperty(name + "." + type, value);
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    protected void saveSearchLevel(String name, int searchLevel) {
        this.properties.setProperty(name + "." + SEARCHLEVEL, Integer.toString(searchLevel));
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    protected void saveAlias(String name, String aliasType, boolean state) {
        if (state) {
            this.properties.setProperty(name + "." + aliasType, "true");
        } else {
            this.properties.setProperty(name + "." + aliasType, "false");
        }
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    public String getValue(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    protected void removeRetAttrs(String value) {
        if (this.properties.containsValue(value)) {
            Enumeration<?> en = this.properties.propertyNames();
            while (en.hasMoreElements()) {
                String temp = en.nextElement().toString();
                if (temp.indexOf(RETATTRS) <= -1 || !this.properties.get(temp).toString().equalsIgnoreCase(value)) continue;
                this.properties.remove(temp);
            }
            CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
        }
    }

    protected void removeFilters(String[] filterNames) {
        for (int i = 0; i < filterNames.length; ++i) {
            this.removeFilter(filterNames[i]);
        }
    }

    protected void removeFilter(String filterName) {
        this.properties.remove(filterName);
        String name = filterName.startsWith(NAME) ? filterName.substring(9) : filterName.substring(13);
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String temp = en.nextElement().toString();
            if (!temp.startsWith(name)) continue;
            this.properties.remove(temp);
        }
        CBUtility.writePropertyFile(this.searchFilterConfig, this.properties, "");
    }

    protected ArrayList getDependants(Object filterName) {
        this.dependantFilters.clear();
        this.tempList.clear();
        if (!this.dependantFilters.contains(filterName)) {
            this.dependantFilters.add(NAME + filterName);
        }
        this.getDependantFilters(NAME + filterName);
        return this.dependantFilters;
    }

    protected void getDependantFilters(Object filterName) {
        Collection<Object> col = this.properties.values();
        Object[] allValues = col.toArray();
        for (int i = 0; i < allValues.length; ++i) {
            String temp;
            if (allValues[i].toString().indexOf(filterName.toString()) <= -1 || (temp = this.getKeyForValue(allValues[i].toString())).equalsIgnoreCase("") || this.dependantFilters.contains(temp)) continue;
            this.dependantFilters.add(temp);
            this.tempList.add(temp);
            this.getDependantFilters(temp);
        }
    }

    protected String getKeyForValue(String value) {
        String[] allKeys = new String[this.properties.size()];
        Enumeration<?> en = this.properties.propertyNames();
        int counter = 0;
        while (en.hasMoreElements()) {
            allKeys[counter] = en.nextElement().toString();
            ++counter;
        }
        for (int i = 0; i < allKeys.length; ++i) {
            if (!this.properties.getProperty(allKeys[i]).equalsIgnoreCase(value) || this.tempList.contains(allKeys[i])) continue;
            return allKeys[i];
        }
        return "";
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((String)o1).compareToIgnoreCase((String)o2);
        }
    }
}

