/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.CompletionStageSupport;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateNode;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

public class ExpressionNode
implements TemplateNode {
    private static final Logger LOG = Logger.getLogger((String)"io.quarkus.qute.nodeResolve");
    final ExpressionImpl expression;
    private final Engine engine;
    private final boolean traceLevel;
    private final boolean hasEngineResultMappers;
    private final boolean unrestrictedCompletionStages;

    ExpressionNode(ExpressionImpl expression, Engine engine) {
        this.expression = expression;
        this.engine = engine;
        this.traceLevel = LOG.isTraceEnabled();
        this.hasEngineResultMappers = !engine.getResultMappers().isEmpty();
        this.unrestrictedCompletionStages = CompletionStageSupport.UNRESTRICTED;
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        if (this.traceLevel) {
            LOG.tracef("Resolve {%s} started:%s", (Object)this.expression.toOriginalString(), (Object)this.expression.getOrigin());
        }
        return context.evaluate(this.expression).thenCompose(this::toResultNode);
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.expression.getOrigin();
    }

    @Override
    public boolean isConstant() {
        return this.expression.isLiteral();
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public TemplateNode.Kind kind() {
        return TemplateNode.Kind.EXPRESSION;
    }

    @Override
    public ExpressionNode asExpression() {
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExpressionNode [expression=").append(this.expression).append("]");
        return builder.toString();
    }

    CompletionStage<ResultNode> toResultNode(Object result) {
        if (this.traceLevel) {
            LOG.tracef("Resolve {%s} completed:%s", (Object)this.expression.toOriginalString(), (Object)this.expression.getOrigin());
        }
        if (result instanceof ResultNode) {
            return CompletedStage.of((ResultNode)result);
        }
        if (result instanceof CompletableFuture) {
            return (CompletableFuture)((CompletionStage)result).thenCompose(this::toResultNode);
        }
        if (result instanceof CompletedStage) {
            return (CompletableFuture)((CompletionStage)result).thenCompose(this::toResultNode);
        }
        if (this.unrestrictedCompletionStages && result instanceof CompletionStage) {
            return ((CompletionStage)result).thenCompose(this::toResultNode);
        }
        return CompletedStage.of(new SingleResultNode(result, this));
    }

    Engine getEngine() {
        return this.engine;
    }

    boolean hasEngineResultMappers() {
        return this.hasEngineResultMappers;
    }

    String mapResult(Object result) {
        return this.engine.mapResult(result, this.expression);
    }
}

