/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.ipatuura_user_spi;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.UserCredentialManager;
import org.keycloak.ipatuura_user_spi.Ipatuura;
import org.keycloak.ipatuura_user_spi.IpatuuraUserModelDelegate;
import org.keycloak.ipatuura_user_spi.IpatuuraUserStorageProviderFactory;
import org.keycloak.ipatuura_user_spi.authenticator.IpatuuraAuthenticator;
import org.keycloak.ipatuura_user_spi.schemas.SCIMError;
import org.keycloak.ipatuura_user_spi.schemas.SCIMUser;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class IpatuuraUserStorageProvider
implements UserStorageProvider,
UserLookupProvider,
CredentialInputValidator,
CredentialAuthentication,
UserRegistrationProvider,
UserQueryProvider,
ImportedUserValidation {
    protected KeycloakSession session;
    protected ComponentModel model;
    protected Ipatuura ipatuura;
    private static final Logger logger = Logger.getLogger(IpatuuraUserStorageProvider.class);
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();
    protected IpatuuraUserStorageProviderFactory factory;

    public IpatuuraUserStorageProvider(KeycloakSession session, ComponentModel model, Ipatuura ipatuura, IpatuuraUserStorageProviderFactory factory) {
        this.session = session;
        this.model = model;
        this.ipatuura = ipatuura;
        this.factory = factory;
        this.supportedCredentialTypes.add("password");
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String username = storageId.getExternalId();
        return this.getUserByUsername(realm, username);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        UserModel user;
        int idx = username.indexOf("@");
        if (idx != -1) {
            username = username.substring(0, idx);
        }
        if ((user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, username)) != null) {
            logger.debug((Object)"User already exists in keycloak");
            return user;
        }
        return this.createUserInKeycloak(realm, username);
    }

    protected UserModel createUserInKeycloak(RealmModel realm, String username) {
        SCIMUser scimuser = this.ipatuura.getUserByUsername(username);
        if (scimuser.getTotalResults() == 0) {
            return null;
        }
        UserModel user = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).addUser(realm, username);
        user.setEmail(this.ipatuura.getEmail(scimuser));
        user.setFirstName(this.ipatuura.getFirstName(scimuser));
        user.setLastName(this.ipatuura.getLastName(scimuser));
        user.setFederationLink(this.model.getId());
        user.setEnabled(this.ipatuura.getActive(scimuser));
        for (String name : this.ipatuura.getGroupsList(scimuser)) {
            Stream groupsStream = this.session.groups().searchForGroupByNameStream(realm, name, Boolean.valueOf(false), null, null);
            GroupModel group = groupsStream.findFirst().orElse(null);
            if (group == null) {
                logger.debugv("No group found, creating group: {0}", (Object)name);
                group = this.session.groups().createGroup(realm, name);
            }
            user.joinGroup(group);
        }
        logger.debugv("Creating SCIM user {0} in keycloak", (Object)username);
        return new IpatuuraUserModelDelegate(this.ipatuura, user, this.model);
    }

    public void close() {
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!this.supportsCredentialType(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        if (((UserCredentialManager)user.credentialManager()).isConfiguredLocally(input.getType())) {
            logger.debugv("Local password validation for {0}", (Object)user.getUsername());
            return false;
        }
        logger.debugv("Delegated password validation for {0}", (Object)user.getUsername());
        Ipatuura ipatuura = this.ipatuura;
        return ipatuura.isValid(user.getUsername(), input.getChallengeResponse());
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        Ipatuura ipatuura = this.ipatuura;
        SCIMUser scimuser = ipatuura.getUserByUsername(local.getUsername());
        String fname = ipatuura.getFirstName(scimuser);
        String lname = ipatuura.getLastName(scimuser);
        String email = ipatuura.getEmail(scimuser);
        if (!local.getFirstName().equals(fname)) {
            local.setFirstName(fname);
        }
        if (!local.getLastName().equals(lname)) {
            local.setLastName(lname);
        }
        if (!local.getEmail().equals(email)) {
            local.setEmail(email);
        }
        return new IpatuuraUserModelDelegate(this.ipatuura, local, this.model);
    }

    public UserModel addUser(RealmModel realm, String username) {
        Ipatuura ipatuura = this.ipatuura;
        SimpleHttp.Response resp = ipatuura.createUser(username);
        try {
            if (resp.getStatus() != 201) {
                logger.warn((Object)"Unexpected create status code returned");
                SCIMError error = (SCIMError)resp.asJson(SCIMError.class);
                logger.warn((Object)error.getDetail());
                resp.close();
                return null;
            }
            resp.close();
        }
        catch (IOException e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return this.createUserInKeycloak(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        logger.debugv("Removing user: {0}", (Object)user.getUsername());
        Ipatuura ipatuura = this.ipatuura;
        SimpleHttp.Response resp = ipatuura.deleteUser(user.getUsername());
        Boolean status = false;
        try {
            status = resp.getStatus() == 204;
            resp.close();
        }
        catch (IOException e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return status;
    }

    private Stream<UserModel> performSearch(RealmModel realm, String search) {
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        Ipatuura ipatuura = this.ipatuura;
        SCIMUser scimuser = ipatuura.getUserByUsername(search);
        if (scimuser.getTotalResults() > 0) {
            logger.debug((Object)"User found by username!");
            if (UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session).getUserByUsername(realm, search) == null) {
                UserModel user = this.getUserByUsername(realm, ipatuura.getUserName(scimuser));
                users.add(user);
            } else {
                logger.debug((Object)"User exists!");
            }
            return users.stream();
        }
        return users.stream();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel arg0, GroupModel arg1, Integer arg2, Integer arg3) {
        return Stream.empty();
    }

    public int getUsersCount(RealmModel realm) {
        Ipatuura ipatuura = this.ipatuura;
        SCIMUser user = null;
        try {
            SimpleHttp.Response response = ipatuura.clientRequest("/Users", "GET", null);
            user = (SCIMUser)response.asJson(SCIMUser.class);
            response.close();
        }
        catch (Exception e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return user.getTotalResults();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        String search = params.get("keycloak.session.realm.users.query.search");
        if (search == null) {
            return Stream.empty();
        }
        return this.performSearch(realm, search);
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return "kerberos".equals(type);
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput input) {
        UserModel user;
        HashMap state = new HashMap();
        String username = null;
        IpatuuraAuthenticator ipatuuraAuthenticator = this.factory.createSCIMAuthenticator();
        String token = ipatuuraAuthenticator.getToken(this.session);
        if (token != null) {
            username = this.ipatuura.gssAuth(token);
            int idx = username.indexOf("@");
            if (idx != -1) {
                username = username.substring(0, idx);
            }
            logger.debug((Object)("GSSAPI authenticating with user " + username));
        }
        if ((user = this.getUserByUsername(realm, username)) == null) {
            logger.debug((Object)"CredentialValidationOutput failed");
            return CredentialValidationOutput.failed();
        }
        logger.debug((Object)"CredentialValidationOutput success!");
        return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
    }
}

