/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.EvaluatableScriptAdapter;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptExecutionException;

abstract class AbstractEvaluatableScriptAdapter
implements EvaluatableScriptAdapter {
    private final ScriptModel scriptModel;

    AbstractEvaluatableScriptAdapter(ScriptModel scriptModel) {
        if (scriptModel == null) {
            throw new IllegalArgumentException("scriptModel must not be null");
        }
        this.scriptModel = scriptModel;
    }

    public Object eval(ScriptBindingsConfigurer bindingsConfigurer) throws ScriptExecutionException {
        return this.evalUnchecked(this.createBindings(bindingsConfigurer));
    }

    public ScriptModel getScriptModel() {
        return this.scriptModel;
    }

    InvocableScriptAdapter prepareInvokableScript(ScriptBindingsConfigurer bindingsConfigurer) {
        Bindings bindings = this.createBindings(bindingsConfigurer);
        this.evalUnchecked(bindings);
        ScriptEngine engine = this.getEngine();
        engine.setBindings(bindings, 100);
        return new InvocableScriptAdapter(this.scriptModel, engine);
    }

    protected String getCode() {
        return this.scriptModel.getCode();
    }

    protected abstract ScriptEngine getEngine();

    protected abstract Object eval(Bindings var1) throws ScriptException;

    private Object evalUnchecked(Bindings bindings) {
        try {
            return this.eval(bindings);
        }
        catch (ScriptException e) {
            throw new ScriptExecutionException(this.scriptModel, (Exception)e);
        }
    }

    private Bindings createBindings(ScriptBindingsConfigurer bindingsConfigurer) {
        if (bindingsConfigurer == null) {
            throw new IllegalArgumentException("bindingsConfigurer must not be null");
        }
        Bindings bindings = this.getEngine().createBindings();
        bindingsConfigurer.configureBindings(bindings);
        return bindings;
    }
}

