/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot.xml;

import io.quarkus.runtime.annotations.RecordableConstructor;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.jaxb.spi.Binding;

public class RecordableXmlMapping {
    private final JaxbEntityMappings ormXmlRoot;
    private final JaxbHbmHibernateMapping hbmXmlRoot;
    private final SourceType originType;
    private final String originName;

    public static RecordableXmlMapping create(Binding<?> binding) {
        Object root = binding.getRoot();
        Origin origin = binding.getOrigin();
        if (root instanceof JaxbEntityMappings) {
            return new RecordableXmlMapping((JaxbEntityMappings)root, null, origin.getType(), origin.getName());
        }
        if (root instanceof JaxbHbmHibernateMapping) {
            return new RecordableXmlMapping(null, (JaxbHbmHibernateMapping)root, origin.getType(), origin.getName());
        }
        throw new IllegalArgumentException("Unsupported mapping file root (unrecognized type): " + String.valueOf(root));
    }

    @RecordableConstructor
    public RecordableXmlMapping(JaxbEntityMappings ormXmlRoot, JaxbHbmHibernateMapping hbmXmlRoot, SourceType originType, String originName) {
        this.ormXmlRoot = ormXmlRoot;
        this.hbmXmlRoot = hbmXmlRoot;
        this.originType = originType;
        this.originName = originName;
    }

    public String toString() {
        return "RecordableXmlMapping{originName='" + this.originName + "'}";
    }

    public JaxbEntityMappings getOrmXmlRoot() {
        return this.ormXmlRoot;
    }

    public JaxbHbmHibernateMapping getHbmXmlRoot() {
        return this.hbmXmlRoot;
    }

    public SourceType getOriginType() {
        return this.originType;
    }

    public String getOriginName() {
        return this.originName;
    }

    public Binding<?> toHibernateOrmBinding() {
        Origin origin = new Origin(this.originType, this.originName);
        if (this.ormXmlRoot != null) {
            return new Binding((Object)this.ormXmlRoot, origin);
        }
        return new Binding((Object)this.hbmXmlRoot, origin);
    }
}

