/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.quarkus.micrometer.runtime.binder.mpmetrics.AnnotatedGaugeAdapter;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Metric;

public class MpMetadata
implements Metadata {
    final String name;
    final MetricType type;
    String description;
    String unit;
    boolean dirty = false;

    public static MpMetadata sanitize(Metadata metadata, MetricType type) {
        if (metadata instanceof MpMetadata) {
            return (MpMetadata)metadata;
        }
        return new MpMetadata(metadata, type);
    }

    MpMetadata(String name, MetricType type) {
        this.name = name;
        this.type = type;
    }

    MpMetadata(Metric annotation, MetricType type) {
        this.name = annotation.name();
        this.description = this.stringOrNull(annotation.description());
        this.unit = this.stringOrNull(annotation.unit());
        this.type = type;
    }

    MpMetadata(String name, String description, String unit, MetricType type) {
        this.name = name;
        this.description = this.stringOrNull(description);
        this.unit = this.stringOrNull(unit);
        this.type = type;
    }

    MpMetadata(Metadata other, MetricType type) {
        this.type = type;
        this.name = other.getName();
        this.description = other.description().orElse(null);
        this.unit = other.unit().orElse(null);
    }

    public boolean mergeSameType(MpMetadata metadata) {
        if (this.type == metadata.type) {
            if (this.description == null) {
                this.dirty = true;
                this.description = this.stringOrNull(metadata.description);
            }
            if (this.unit == null) {
                this.dirty = true;
                this.unit = this.stringOrNull(metadata.unit);
            }
            return true;
        }
        return false;
    }

    public boolean mergeSameType(Metadata metadata) {
        if (metadata.getTypeRaw() == MetricType.INVALID || this.type == metadata.getTypeRaw()) {
            if (this.description == null) {
                this.dirty = true;
                this.description = this.stringOrNull(metadata.description().orElse(null));
            }
            if (this.unit == null) {
                this.dirty = true;
                this.unit = this.stringOrNull(metadata.unit().orElse(null));
            }
            return true;
        }
        return false;
    }

    public boolean mergeSameType(AnnotatedGaugeAdapter annotation) {
        if (this.type == MetricType.GAUGE) {
            if (this.description == null) {
                this.dirty = true;
                this.description = this.stringOrNull(annotation.description());
            }
            if (this.unit == null) {
                this.dirty = true;
                this.unit = this.stringOrNull(annotation.baseUnit());
            }
            return true;
        }
        return false;
    }

    public MpMetadata merge(Metric annotation) {
        if (this.description == null) {
            this.dirty = true;
            this.description = this.stringOrNull(annotation.description());
        }
        if (this.unit == null) {
            this.dirty = true;
            this.unit = this.stringOrNull(annotation.unit());
        }
        return this;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> unit() {
        return Optional.ofNullable(this.unit);
    }

    public boolean cleanDirtyMetadata() {
        boolean precheck = this.dirty;
        this.dirty = false;
        return precheck;
    }

    String stringOrNull(String s) {
        if (s == null || s.isEmpty() || "none".equals(s)) {
            return null;
        }
        return s;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public Optional<String> displayName() {
        return Optional.ofNullable(this.name);
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID).name();
    }

    public MetricType getTypeRaw() {
        return Optional.ofNullable(this.type).orElse(MetricType.INVALID);
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpMetadata that = (MpMetadata)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name + "[" + (String)(this.description == null ? "" : "description=" + this.description + " ") + (String)(this.unit == null ? "" : "unit=" + this.unit + " ") + String.valueOf(this.type) + "]";
    }
}

