/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayFillFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;

public class PostgreSQLArrayFillFunction
extends AbstractArrayFillFunction {
    public PostgreSQLArrayFillFunction(boolean list) {
        super(list);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String elementCastType;
        sqlAppender.append("array_fill(");
        Expression elementExpression = (Expression)sqlAstArguments.get(0);
        if (PostgreSQLArrayFillFunction.needsElementCasting(elementExpression)) {
            elementCastType = DdlTypeHelper.getCastTypeName(elementExpression.getExpressionType(), walker.getSessionFactory().getTypeConfiguration());
            sqlAppender.append("cast(");
        } else {
            elementCastType = null;
        }
        sqlAstArguments.get(0).accept(walker);
        if (elementCastType != null) {
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        }
        sqlAppender.append(",array[");
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append("])");
    }

    private static boolean needsElementCasting(Expression elementExpression) {
        return elementExpression instanceof Literal && (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString() || ((Literal)elementExpression).getLiteralValue() == null);
    }
}

