/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.storage.split.Split;

public class ExecutionContext {
    private final Optional<Split> split;
    private final Integer querySizeLimit;

    public ExecutionContext(Split split) {
        this.split = Optional.of(split);
        this.querySizeLimit = null;
    }

    private ExecutionContext(Optional<Split> split, Integer querySizeLimit) {
        this.split = split;
        this.querySizeLimit = querySizeLimit;
    }

    public static ExecutionContext querySizeLimit(Integer querySizeLimit) {
        return new ExecutionContext(Optional.empty(), querySizeLimit);
    }

    public static ExecutionContext emptyExecutionContext() {
        return new ExecutionContext(Optional.empty(), null);
    }

    @Generated
    public Optional<Split> getSplit() {
        return this.split;
    }

    @Generated
    public Integer getQuerySizeLimit() {
        return this.querySizeLimit;
    }
}

