/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.sql.legacy.executor.format.ErrorMessage;
import org.opensearch.sql.legacy.utils.StringUtils;

public class OpenSearchErrorMessage
extends ErrorMessage<OpenSearchException> {
    OpenSearchErrorMessage(OpenSearchException exception, int defaultStatus) {
        super(exception, exception.status() != null ? exception.status().getStatus() : defaultStatus);
    }

    @Override
    protected String fetchReason() {
        return "Error occurred in OpenSearch engine: " + ((OpenSearchException)((Object)this.exception)).getMessage();
    }

    @Override
    protected String fetchDetails() {
        StringBuilder details = new StringBuilder();
        if (this.exception instanceof SearchPhaseExecutionException) {
            details.append(this.fetchSearchPhaseExecutionExceptionDetails((SearchPhaseExecutionException)this.exception));
        } else {
            details.append(this.defaultDetails((OpenSearchException)((Object)this.exception)));
        }
        details.append("\nFor more details, please send request for Json format to see the raw response from OpenSearch engine.");
        return details.toString();
    }

    private String defaultDetails(OpenSearchException exception) {
        return exception.getDetailedMessage();
    }

    private String fetchSearchPhaseExecutionExceptionDetails(SearchPhaseExecutionException exception) {
        ShardSearchFailure[] shardFailures;
        StringBuilder details = new StringBuilder();
        for (ShardSearchFailure failure : shardFailures = exception.shardFailures()) {
            details.append(StringUtils.format("Shard[%d]: %s\n", failure.shardId(), failure.getCause().toString()));
        }
        return details.toString();
    }
}

