/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch.core.update_by_query_rethrottle.UpdateByQueryRethrottleNode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class UpdateByQueryRethrottleResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateByQueryRethrottleResponse> {
    @Nonnull
    private final List<ErrorCause> nodeFailures;
    @Nonnull
    private final Map<String, UpdateByQueryRethrottleNode> nodes;
    public static final JsonpDeserializer<UpdateByQueryRethrottleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateByQueryRethrottleResponse::setupUpdateByQueryRethrottleResponseDeserializer);

    private UpdateByQueryRethrottleResponse(Builder builder) {
        this.nodeFailures = ApiTypeHelper.unmodifiable(builder.nodeFailures);
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static UpdateByQueryRethrottleResponse of(Function<Builder, ObjectBuilder<UpdateByQueryRethrottleResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    @Nonnull
    public final Map<String, UpdateByQueryRethrottleNode> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodeFailures)) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry entry : this.nodes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((UpdateByQueryRethrottleNode)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateByQueryRethrottleResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(UpdateByQueryRethrottleNode._DESERIALIZER), "nodes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.nodeFailures);
        result = 31 * result + this.nodes.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateByQueryRethrottleResponse other = (UpdateByQueryRethrottleResponse)o;
        return Objects.equals(this.nodeFailures, other.nodeFailures) && this.nodes.equals(other.nodes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, UpdateByQueryRethrottleResponse> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        private Map<String, UpdateByQueryRethrottleNode> nodes;

        public Builder() {
        }

        private Builder(UpdateByQueryRethrottleResponse o) {
            this.nodeFailures = Builder._listCopy(o.nodeFailures);
            this.nodes = Builder._mapCopy(o.nodes);
        }

        private Builder(Builder o) {
            this.nodeFailures = Builder._listCopy(o.nodeFailures);
            this.nodes = Builder._mapCopy(o.nodes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder nodeFailures(List<ErrorCause> list) {
            this.nodeFailures = Builder._listAddAll(this.nodeFailures, list);
            return this;
        }

        @Nonnull
        public final Builder nodeFailures(ErrorCause value, ErrorCause ... values) {
            this.nodeFailures = Builder._listAdd(this.nodeFailures, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        @Nonnull
        public final Builder nodes(Map<String, UpdateByQueryRethrottleNode> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, UpdateByQueryRethrottleNode value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<UpdateByQueryRethrottleNode.Builder, ObjectBuilder<UpdateByQueryRethrottleNode>> fn) {
            return this.nodes(key, fn.apply(new UpdateByQueryRethrottleNode.Builder()).build());
        }

        @Override
        @Nonnull
        public UpdateByQueryRethrottleResponse build() {
            this._checkSingleUse();
            return new UpdateByQueryRethrottleResponse(this);
        }
    }
}

