/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.ad.model.AnomalyDetectorType;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.transport.BaseStatsTransportAction;
import org.opensearch.timeseries.transport.StatsNodesResponse;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.transport.StatsResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class StatsAnomalyDetectorTransportAction
extends BaseStatsTransportAction {
    public static final String DETECTOR_TYPE_AGG = "detector_type_agg";

    @Inject
    public StatsAnomalyDetectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ADStats adStats, ClusterService clusterService) {
        super(transportService, actionFilters, client, adStats, clusterService, StatsAnomalyDetectorAction.NAME);
    }

    @Override
    protected void getClusterStats(Client client, MultiResponsesDelegateActionListener<StatsResponse> listener, StatsRequest adStatsRequest) {
        StatsResponse adStatsResponse = new StatsResponse();
        if ((adStatsRequest.getStatsToBeRetrieved().contains(StatNames.DETECTOR_COUNT.getName()) || adStatsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_STREAM_DETECTOR_COUNT.getName()) || adStatsRequest.getStatsToBeRetrieved().contains(StatNames.HC_DETECTOR_COUNT.getName())) && this.clusterService.state().getRoutingTable().hasIndex(".opendistro-anomaly-detectors")) {
            TermsAggregationBuilder termsAgg = (TermsAggregationBuilder)AggregationBuilders.terms((String)DETECTOR_TYPE_AGG).field("detector_type");
            SearchRequest request = new SearchRequest().indices(new String[]{".opendistro-anomaly-detectors"}).source(new SearchSourceBuilder().aggregation((AggregationBuilder)termsAgg).size(0).trackTotalHits(true));
            client.search(request, ActionListener.wrap(r -> {
                StringTerms aggregation = (StringTerms)r.getAggregations().get(DETECTOR_TYPE_AGG);
                List buckets = aggregation.getBuckets();
                long totalDetectors = r.getHits().getTotalHits().value();
                long totalSingleEntityDetectors = 0L;
                long totalMultiEntityDetectors = 0L;
                for (StringTerms.Bucket b : buckets) {
                    if (AnomalyDetectorType.SINGLE_ENTITY.name().equals(b.getKeyAsString()) || AnomalyDetectorType.REALTIME_SINGLE_ENTITY.name().equals(b.getKeyAsString()) || AnomalyDetectorType.HISTORICAL_SINGLE_ENTITY.name().equals(b.getKeyAsString())) {
                        totalSingleEntityDetectors += b.getDocCount();
                    }
                    if (!AnomalyDetectorType.MULTI_ENTITY.name().equals(b.getKeyAsString()) && !AnomalyDetectorType.REALTIME_MULTI_ENTITY.name().equals(b.getKeyAsString()) && !AnomalyDetectorType.HISTORICAL_MULTI_ENTITY.name().equals(b.getKeyAsString())) continue;
                    totalMultiEntityDetectors += b.getDocCount();
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.DETECTOR_COUNT.getName())) {
                    this.stats.getStat(StatNames.DETECTOR_COUNT.getName()).setValue(totalDetectors);
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.SINGLE_STREAM_DETECTOR_COUNT.getName())) {
                    this.stats.getStat(StatNames.SINGLE_STREAM_DETECTOR_COUNT.getName()).setValue(totalSingleEntityDetectors);
                }
                if (adStatsRequest.getStatsToBeRetrieved().contains(StatNames.HC_DETECTOR_COUNT.getName())) {
                    this.stats.getStat(StatNames.HC_DETECTOR_COUNT.getName()).setValue(totalMultiEntityDetectors);
                }
                adStatsResponse.setClusterStats(this.getClusterStatsMap(adStatsRequest));
                listener.onResponse(adStatsResponse);
            }, e -> listener.onFailure((Exception)e)));
        } else {
            adStatsResponse.setClusterStats(this.getClusterStatsMap(adStatsRequest));
            listener.onResponse(adStatsResponse);
        }
    }

    @Override
    protected void getNodeStats(Client client, MultiResponsesDelegateActionListener<StatsResponse> listener, StatsRequest adStatsRequest) {
        client.execute((ActionType)ADStatsNodesAction.INSTANCE, (ActionRequest)adStatsRequest, ActionListener.wrap(adStatsResponse -> {
            StatsResponse restADStatsResponse = new StatsResponse();
            restADStatsResponse.setStatsNodesResponse((StatsNodesResponse)((Object)adStatsResponse));
            listener.onResponse(restADStatsResponse);
        }, listener::onFailure));
    }
}

