/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.evaluation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.provenance.EvaluationProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.evaluation.RegressionEvaluation;
import org.tribuo.regression.evaluation.RegressionMetric;
import org.tribuo.regression.evaluation.RegressionMetrics;
import org.tribuo.regression.evaluation.RegressionSufficientStatistics;

final class RegressionEvaluationImpl
implements RegressionEvaluation {
    private final Map<MetricID<Regressor>, Double> results;
    private final RegressionMetric.Context context;
    private final RegressionSufficientStatistics memo;
    private final EvaluationProvenance provenance;

    RegressionEvaluationImpl(Map<MetricID<Regressor>, Double> results, RegressionMetric.Context context, EvaluationProvenance provenance) {
        this.results = results;
        this.context = context;
        this.memo = context.getMemo();
        this.provenance = provenance;
    }

    public List<Prediction<Regressor>> getPredictions() {
        return this.context.getPredictions();
    }

    @Override
    public double averageMAE() {
        return this.get((MetricTarget<Regressor>)MetricTarget.macroAverageTarget(), RegressionMetrics.MAE);
    }

    @Override
    public double mae(Regressor variable) {
        return this.get((MetricTarget<Regressor>)new MetricTarget((Output)variable), RegressionMetrics.MAE);
    }

    @Override
    public Map<Regressor, Double> mae() {
        return this.get(RegressionMetrics.MAE);
    }

    @Override
    public double averageR2() {
        return this.get((MetricTarget<Regressor>)MetricTarget.macroAverageTarget(), RegressionMetrics.R2);
    }

    @Override
    public double r2(Regressor variable) {
        return this.get((MetricTarget<Regressor>)new MetricTarget((Output)variable), RegressionMetrics.R2);
    }

    @Override
    public Map<Regressor, Double> r2() {
        return this.get(RegressionMetrics.R2);
    }

    @Override
    public double averageRMSE() {
        return this.get((MetricTarget<Regressor>)MetricTarget.macroAverageTarget(), RegressionMetrics.RMSE);
    }

    @Override
    public double rmse(Regressor variable) {
        return this.get((MetricTarget<Regressor>)new MetricTarget((Output)variable), RegressionMetrics.RMSE);
    }

    @Override
    public Map<Regressor, Double> rmse() {
        return this.get(RegressionMetrics.RMSE);
    }

    @Override
    public double averagedExplainedVariance() {
        return this.get((MetricTarget<Regressor>)MetricTarget.macroAverageTarget(), RegressionMetrics.EV);
    }

    @Override
    public double explainedVariance(Regressor variable) {
        return this.get((MetricTarget<Regressor>)new MetricTarget((Output)variable), RegressionMetrics.EV);
    }

    @Override
    public Map<Regressor, Double> explainedVariance() {
        return this.get(RegressionMetrics.EV);
    }

    public Map<MetricID<Regressor>, Double> asMap() {
        return Collections.unmodifiableMap(this.results);
    }

    public EvaluationProvenance getProvenance() {
        return this.provenance;
    }

    public String toString() {
        return "Multi-dimensional Regression Evaluation\nRMSE = " + RegressionEvaluationImpl.convertKeys(this.rmse()) + "\nMean Absolute Error = " + RegressionEvaluationImpl.convertKeys(this.mae()) + "\nR^2 = " + RegressionEvaluationImpl.convertKeys(this.r2()) + "\nexplained variance = " + RegressionEvaluationImpl.convertKeys(this.explainedVariance());
    }

    private static Map<String, Double> convertKeys(Map<Regressor, Double> map) {
        HashMap<String, Double> outputMap = new HashMap<String, Double>(map.size());
        for (Map.Entry<Regressor, Double> e : map.entrySet()) {
            outputMap.put(e.getKey().getDimensionNamesString(), e.getValue());
        }
        return outputMap;
    }

    private double get(MetricTarget<Regressor> target, RegressionMetrics metric) {
        return this.get(metric.forTarget(target).getID());
    }

    private Map<Regressor, Double> get(RegressionMetrics metric) {
        HashMap<Regressor, Double> map = new HashMap<Regressor, Double>();
        for (Regressor variable : this.memo.domain.getDomain()) {
            MetricTarget target = new MetricTarget((Output)variable);
            map.put(variable, this.get((MetricTarget<Regressor>)target, metric));
        }
        return map;
    }
}

