/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.EncryptionMaterials;

public class GetEncryptionMaterialsOutput {
    private final EncryptionMaterials encryptionMaterials;

    protected GetEncryptionMaterialsOutput(BuilderImpl builder) {
        this.encryptionMaterials = builder.encryptionMaterials();
    }

    public EncryptionMaterials encryptionMaterials() {
        return this.encryptionMaterials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected EncryptionMaterials encryptionMaterials;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GetEncryptionMaterialsOutput model) {
            this.encryptionMaterials = model.encryptionMaterials();
        }

        @Override
        public Builder encryptionMaterials(EncryptionMaterials encryptionMaterials) {
            this.encryptionMaterials = encryptionMaterials;
            return this;
        }

        @Override
        public EncryptionMaterials encryptionMaterials() {
            return this.encryptionMaterials;
        }

        @Override
        public GetEncryptionMaterialsOutput build() {
            if (Objects.isNull(this.encryptionMaterials())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionMaterials`");
            }
            return new GetEncryptionMaterialsOutput(this);
        }
    }

    public static interface Builder {
        public Builder encryptionMaterials(EncryptionMaterials var1);

        public EncryptionMaterials encryptionMaterials();

        public GetEncryptionMaterialsOutput build();
    }
}

