/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.materialproviders.model.RawEcdhStaticConfigurations;

public class StaticConfigurations {
    private final KmsEcdhStaticConfigurations AWS_KMS_ECDH;
    private final RawEcdhStaticConfigurations RAW_ECDH;

    protected StaticConfigurations(BuilderImpl builder) {
        this.AWS_KMS_ECDH = builder.AWS_KMS_ECDH();
        this.RAW_ECDH = builder.RAW_ECDH();
    }

    public KmsEcdhStaticConfigurations AWS_KMS_ECDH() {
        return this.AWS_KMS_ECDH;
    }

    public RawEcdhStaticConfigurations RAW_ECDH() {
        return this.RAW_ECDH;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsEcdhStaticConfigurations AWS_KMS_ECDH;
        protected RawEcdhStaticConfigurations RAW_ECDH;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StaticConfigurations model) {
            this.AWS_KMS_ECDH = model.AWS_KMS_ECDH();
            this.RAW_ECDH = model.RAW_ECDH();
        }

        @Override
        public Builder AWS_KMS_ECDH(KmsEcdhStaticConfigurations AWS_KMS_ECDH) {
            this.AWS_KMS_ECDH = AWS_KMS_ECDH;
            return this;
        }

        @Override
        public KmsEcdhStaticConfigurations AWS_KMS_ECDH() {
            return this.AWS_KMS_ECDH;
        }

        @Override
        public Builder RAW_ECDH(RawEcdhStaticConfigurations RAW_ECDH) {
            this.RAW_ECDH = RAW_ECDH;
            return this;
        }

        @Override
        public RawEcdhStaticConfigurations RAW_ECDH() {
            return this.RAW_ECDH;
        }

        @Override
        public StaticConfigurations build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`StaticConfigurations` is a Union. A Union MUST have one and only one value set.");
            }
            return new StaticConfigurations(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.AWS_KMS_ECDH, this.RAW_ECDH};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder AWS_KMS_ECDH(KmsEcdhStaticConfigurations var1);

        public KmsEcdhStaticConfigurations AWS_KMS_ECDH();

        public Builder RAW_ECDH(RawEcdhStaticConfigurations var1);

        public RawEcdhStaticConfigurations RAW_ECDH();

        public StaticConfigurations build();
    }
}

