/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.transport.index;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/index/IndexSMPolicyRequest;", "Lorg/opensearch/action/index/IndexRequest;", "policy", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "create", "", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "<init>", "(Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;ZLorg/opensearch/action/support/WriteRequest$RefreshPolicy;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getPolicy", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;", "setPolicy", "(Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMPolicy;)V", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class IndexSMPolicyRequest
extends IndexRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SMPolicy policy;
    @NotNull
    private static final String SEQ_NUM_PRIMARY_TERM_UPDATE_ERROR = "Sequence number and primary term must be provided when updating a snapshot management policy";

    @NotNull
    public final SMPolicy getPolicy() {
        return this.policy;
    }

    public final void setPolicy(@NotNull SMPolicy sMPolicy) {
        Intrinsics.checkNotNullParameter((Object)sMPolicy, (String)"<set-?>");
        this.policy = sMPolicy;
    }

    public IndexSMPolicyRequest(@NotNull SMPolicy policy2, boolean create, @NotNull WriteRequest.RefreshPolicy refreshPolicy) {
        Intrinsics.checkNotNullParameter((Object)policy2, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)refreshPolicy, (String)"refreshPolicy");
        this.policy = policy2;
        this.create(create);
        if (policy2.getSeqNo() != -2L && policy2.getPrimaryTerm() != 0L) {
            this.setIfSeqNo(policy2.getSeqNo()).setIfPrimaryTerm(policy2.getPrimaryTerm());
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.policy = SMPolicy.copy$default(policy2, null, null, 0L, null, null, null, false, instant, null, null, 0L, 0L, null, null, 16255, null);
        }
        this.setRefreshPolicy(refreshPolicy);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        boolean invalidSeqNumPrimaryTerm;
        ActionRequestValidationException validationException = null;
        boolean bl = invalidSeqNumPrimaryTerm = this.ifSeqNo() == -2L || this.ifPrimaryTerm() == 0L;
        if (this.opType() != DocWriteRequest.OpType.CREATE && invalidSeqNumPrimaryTerm) {
            validationException = ValidateActions.addValidationError((String)SEQ_NUM_PRIMARY_TERM_UPDATE_ERROR, validationException);
        }
        return validationException;
    }

    public IndexSMPolicyRequest(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        super(sin);
        this.policy = new SMPolicy(sin);
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        this.policy.writeTo(out);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/index/IndexSMPolicyRequest$Companion;", "", "<init>", "()V", "SEQ_NUM_PRIMARY_TERM_UPDATE_ERROR", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

