/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchHit;
import org.opensearch.searchrelevance.dao.JudgmentCacheDao;
import org.opensearch.searchrelevance.executors.JudgmentTaskContext;

public class JudgmentResponseProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(JudgmentResponseProcessor.class);
    private final JudgmentCacheDao judgmentCacheDao;

    public void processSearchResponse(SearchResponse response, String configIndex, ConcurrentMap<String, SearchHit> allHits, JudgmentTaskContext context) {
        try {
            if (response.getHits().getTotalHits().value() == 0L) {
                log.warn("No hits found for search config index: {}", (Object)configIndex);
                context.completeSearchTask(true);
                return;
            }
            for (SearchHit hit : response.getHits().getHits()) {
                allHits.put(hit.getId(), hit);
            }
            log.debug("Collected {} hits from index: {}", (Object)response.getHits().getHits().length, (Object)configIndex);
            context.completeSearchTask(true);
        }
        catch (Exception e) {
            log.error("Failed to process search response for index: {}", (Object)configIndex, (Object)e);
            context.completeSearchTask(false);
        }
    }

    public void processCacheResponse(SearchResponse response, String docId, ConcurrentMap<String, Boolean> processedDocs, JudgmentTaskContext context) {
        try {
            if (response.getHits().getTotalHits().value() > 0L) {
                SearchHit hit = response.getHits().getHits()[0];
                Map source = hit.getSourceAsMap();
                String rating = (String)source.get("rating");
                String storedContextFields = (String)source.get("contextFieldsStr");
                log.info("Found existing judgment for docId: {}, rating: {}, storedContextFields: {}", (Object)docId, (Object)rating, (Object)storedContextFields);
                context.getDocIdToScore().put(docId, rating);
                processedDocs.put(docId, true);
            }
            context.completeCacheTask(true);
        }
        catch (Exception e) {
            log.error("Failed to process cache response for docId: {}", (Object)docId, (Object)e);
            context.completeCacheTask(false);
        }
    }

    public void handleSearchFailure(Exception e, String configIndex, JudgmentTaskContext context) {
        log.error("Search failed for index: {}", (Object)configIndex, (Object)e);
        context.completeSearchTask(false);
        if (!context.isIgnoreFailure()) {
            context.failJudgment(e);
        }
    }

    public void handleCacheFailure(Exception e, String docId, JudgmentTaskContext context) {
        log.error("Cache lookup failed for docId: {}", (Object)docId, (Object)e);
        context.completeCacheTask(false);
    }

    public void handleLLMFailure(Exception e, String queryTextWithReference, boolean ignoreFailure, ActionListener<Map<String, String>> listener) {
        log.error("LLM processing failed for query: {}", (Object)queryTextWithReference, (Object)e);
        if (!ignoreFailure) {
            listener.onFailure(e);
        } else {
            log.warn("Ignoring LLM failure due to ignoreFailure=true", (Throwable)e);
            listener.onResponse(Map.of());
        }
    }

    @Generated
    public JudgmentResponseProcessor(JudgmentCacheDao judgmentCacheDao) {
        this.judgmentCacheDao = judgmentCacheDao;
    }
}

