/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import org.mockito.internal.exceptions.Reporter;

public class Timer {
    private final long durationMillis;
    private long startTime = -1L;

    public Timer(long durationMillis) {
        this.validateInput(durationMillis);
        this.durationMillis = durationMillis;
    }

    public boolean isCounting() {
        assert (this.startTime != -1L);
        return System.currentTimeMillis() - this.startTime <= this.durationMillis;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    private void validateInput(long durationMillis) {
        if (durationMillis < 0L) {
            throw Reporter.cannotCreateTimerWithNegativeDurationTime(durationMillis);
        }
    }

    public long duration() {
        return this.durationMillis;
    }
}

