/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BinaryEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedBooleanEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedByteEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedDoubleEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedFloatEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedIntEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedLongEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$BoxedShortEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$CalendarIntervalEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$DayTimeIntervalEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$EncoderField$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$LocalDateTimeEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$NullEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$StringEncoder$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$YearMonthIntervalEncoder$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UDTRegistration$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ClassTag$;
import scala.reflect.package$;

public final class RowEncoder$ {
    public static final RowEncoder$ MODULE$ = new RowEncoder$();

    public AgnosticEncoder<Row> encoderFor(StructType schema) {
        return this.encoderFor(schema, false);
    }

    public AgnosticEncoder<Row> encoderFor(StructType schema, boolean lenient) {
        return this.encoderForDataType(schema, lenient);
    }

    public AgnosticEncoder<?> encoderForDataType(DataType dataType, boolean lenient) {
        Product product;
        block30: {
            DataType dataType2;
            while (true) {
                boolean bl = false;
                DataType dataType3 = null;
                boolean bl2 = false;
                DataType dataType4 = null;
                dataType2 = dataType;
                if (NullType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$NullEncoder$.MODULE$;
                    break block30;
                }
                if (BooleanType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedBooleanEncoder$.MODULE$;
                    break block30;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedByteEncoder$.MODULE$;
                    break block30;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedShortEncoder$.MODULE$;
                    break block30;
                }
                if (IntegerType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedIntEncoder$.MODULE$;
                    break block30;
                }
                if (LongType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedLongEncoder$.MODULE$;
                    break block30;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedFloatEncoder$.MODULE$;
                    break block30;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BoxedDoubleEncoder$.MODULE$;
                    break block30;
                }
                if (dataType2 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType2;
                    product = new AgnosticEncoders.JavaDecimalEncoder(decimalType, true);
                    break block30;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$BinaryEncoder$.MODULE$;
                    break block30;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$StringEncoder$.MODULE$;
                    break block30;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    bl = true;
                    dataType3 = dataType2;
                    if (SqlApiConf$.MODULE$.get().datetimeJava8ApiEnabled()) {
                        product = new AgnosticEncoders.InstantEncoder(lenient);
                        break block30;
                    }
                }
                if (bl) {
                    product = new AgnosticEncoders.TimestampEncoder(lenient);
                    break block30;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$LocalDateTimeEncoder$.MODULE$;
                    break block30;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    bl2 = true;
                    dataType4 = dataType2;
                    if (SqlApiConf$.MODULE$.get().datetimeJava8ApiEnabled()) {
                        product = new AgnosticEncoders.LocalDateEncoder(lenient);
                        break block30;
                    }
                }
                if (bl2) {
                    product = new AgnosticEncoders.DateEncoder(lenient);
                    break block30;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                    product = AgnosticEncoders$CalendarIntervalEncoder$.MODULE$;
                    break block30;
                }
                if (dataType2 instanceof DayTimeIntervalType) {
                    product = AgnosticEncoders$DayTimeIntervalEncoder$.MODULE$;
                    break block30;
                }
                if (dataType2 instanceof YearMonthIntervalType) {
                    product = AgnosticEncoders$YearMonthIntervalEncoder$.MODULE$;
                    break block30;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dataType = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable)() -> {
                    throw ExecutionErrors$.MODULE$.userDefinedTypeNotAnnotatedAndRegisteredError(userDefinedType);
                });
                product = new AgnosticEncoders.UDTEncoder(userDefinedType, udtClass);
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                product = new AgnosticEncoders.IterableEncoder(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(ArraySeq.class)), this.encoderForDataType(elementType, lenient), containsNull, true);
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                product = new AgnosticEncoders.MapEncoder(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Map.class)), this.encoderForDataType(keyType, lenient), this.encoderForDataType(valueType, lenient), valueContainsNull);
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                product = new AgnosticEncoders.RowEncoder((Seq<AgnosticEncoders.EncoderField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> new AgnosticEncoders.EncoderField(field.name(), MODULE$.encoderForDataType(field.dataType(), lenient), field.nullable(), field.metadata(), AgnosticEncoders$EncoderField$.MODULE$.apply$default$5(), AgnosticEncoders$EncoderField$.MODULE$.apply$default$6()), ClassTag$.MODULE$.apply(AgnosticEncoders.EncoderField.class))));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return product;
    }

    private RowEncoder$() {
    }
}

