/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class GetTracesRequest
extends ActionRequest {
    private String interactionId;
    private int maxResults = 10;
    private int from = 0;

    public GetTracesRequest(String interactionId) {
        this.interactionId = interactionId;
    }

    public GetTracesRequest(String interactionId, int maxResults) {
        this.interactionId = interactionId;
        this.maxResults = maxResults;
    }

    public GetTracesRequest(String interactionId, int maxResults, int from) {
        this.interactionId = interactionId;
        this.maxResults = maxResults;
        this.from = from;
    }

    public GetTracesRequest(StreamInput in) throws IOException {
        super(in);
        this.interactionId = in.readString();
        this.maxResults = in.readInt();
        this.from = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.interactionId);
        out.writeInt(this.maxResults);
        out.writeInt(this.from);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.interactionId == null) {
            exception = ValidateActions.addValidationError((String)"Traces must be retrieved from an interaction", exception);
        }
        if (this.maxResults <= 0) {
            exception = ValidateActions.addValidationError((String)"The number of traces to retrieve must be positive", (ActionRequestValidationException)exception);
        }
        if (this.from < 0) {
            exception = ValidateActions.addValidationError((String)"The starting position must be nonnegative", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    public static GetTracesRequest fromRestRequest(RestRequest request) throws IOException {
        String cid = request.param("message_id");
        if (request.hasParam("next_token")) {
            int from = Integer.parseInt(request.param("next_token"));
            if (request.hasParam("max_results")) {
                int maxResults = Integer.parseInt(request.param("max_results"));
                return new GetTracesRequest(cid, maxResults, from);
            }
            return new GetTracesRequest(cid, 10, from);
        }
        if (request.hasParam("max_results")) {
            int maxResults = Integer.parseInt(request.param("max_results"));
            return new GetTracesRequest(cid, maxResults);
        }
        return new GetTracesRequest(cid);
    }

    @Generated
    public String getInteractionId() {
        return this.interactionId;
    }

    @Generated
    public int getMaxResults() {
        return this.maxResults;
    }

    @Generated
    public int getFrom() {
        return this.from;
    }
}

