/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.ad.caching.ADCacheProvider;
import org.opensearch.ad.caching.ADPriorityCache;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADCheckpointDao;
import org.opensearch.ad.ml.ADColdStart;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.ADCheckpointWriteWorker;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.transport.DeleteADModelAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.transport.BaseDeleteModelTransportAction;
import org.opensearch.timeseries.transport.DeleteModelNodeRequest;
import org.opensearch.timeseries.transport.DeleteModelNodeResponse;
import org.opensearch.transport.TransportService;

public class DeleteADModelTransportAction
extends BaseDeleteModelTransportAction<ThresholdedRandomCutForest, ADPriorityCache, ADCacheProvider, ADTaskCacheManager, ADIndex, ADIndexManagement, ADCheckpointDao, ADCheckpointWriteWorker, AnomalyResult, ADColdStart> {
    private static final Logger LOG = LogManager.getLogger(DeleteADModelTransportAction.class);
    private ADModelManager modelManager;

    @Inject
    public DeleteADModelTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeStateManager nodeStateManager, ADModelManager modelManager, ADCacheProvider cache, ADTaskCacheManager adTaskCacheManager, ADColdStart coldStarter) {
        super(threadPool, clusterService, transportService, actionFilters, nodeStateManager, cache, adTaskCacheManager, coldStarter, DeleteADModelAction.NAME);
        this.modelManager = modelManager;
    }

    @Override
    protected DeleteModelNodeResponse nodeOperation(DeleteModelNodeRequest request) {
        super.nodeOperation(request);
        String adID = request.getConfigID();
        this.modelManager.clear(adID, (ActionListener<Void>)ActionListener.wrap(r -> LOG.info("Deleted model for [{}] with response [{}] ", (Object)adID, r), e -> LOG.error("Fail to delete model for " + adID, (Throwable)e)));
        LOG.info("Finished deleting ad models for {}", (Object)adID);
        return new DeleteModelNodeResponse(this.clusterService.localNode());
    }
}

