# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.logical_router_ports.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ArpTable(VapiInterface):
    """
    
    """
    LIST_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`ArpTable.list`.

    """
    LIST_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`ArpTable.list`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.logical_router_ports.arp_table'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ArpTableStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             logical_router_port_id,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             source=None,
             transport_node_id=None,
             ):
        """
        Returns ARP table (IPv4) or Neighbor Discovery table (IPv6) for the
        Logical Router Port of the given id, on a node if a query parameter
        \"transport_node_id=<transport-node-id>\" is given. The
        transport_node_id parameter is mandatory if the router port is not
        uplink type. Query parameter \"source=realtime\" is the only supported
        source. 
        
        Please use below Policy API. 
        GET
        /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/arp-table
        GET
        /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/arp-table

        .. deprecated:: unknown

        :type  logical_router_port_id: :class:`str`
        :param logical_router_port_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: TransportNode Id (optional)
        :rtype: :class:`com.vmware.nsx.model_client.LogicalRouterPortArpTable`
        :return: com.vmware.nsx.model.LogicalRouterPortArpTable
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_router_ports.ArpTable.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'logical_router_port_id': logical_router_port_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            'source': source,
                            'transport_node_id': transport_node_id,
                            })
class State(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.logical_router_ports.state'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StateStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            logical_router_port_id,
            barrier_id=None,
            request_id=None,
            ):
        """
        Return realized state information of a logical router port. Any
        configuration update that affects the logical router port can use this
        API to get its realized state by passing a request_id returned by the
        configuration change operation. e.g. Update configuration of logical
        router ports, dhcp relays, etc. 
        
        To get all realized entities for the intent use below Policy API. 
        GET
        /policy/api/v1/infra/realized-state/realized-entities?intent_path=<intent-path>
        For realized status of the intent use below Policy API. 
        GET
        /policy/api/v1/infra/realized-state/status?intent_path=<intent-path> 
        <intent-path> can be one of the following. 
        /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
        /infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
        /infra/tier-1s/<tier-1-id>/segments/<segment-id> for DOWNLINK 
        /infra/segments/<segment-id> for DOWNLINK 
        There are specific Policy APIs to get Segment state. 
        GET /policy/api/v1/infra/segments/<segment-id>/state 
        GET
        /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/state 
        For DAD status use below Policy APIs. 
        GET
        /policy/api/v1/infra/segments/<segment-id>/gateway-interface-dad-state 
        GET
        /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/gateway-interface-dad-state
        For DAD status of all interfaces created on Gateway use below Policy
        APIs. 
        GET /policy/api/v1/infra/tier-0s/<tier-0-id>/state 
        GET /policy/api/v1/infra/tier-1s/<tier-1-id>/state

        .. deprecated:: unknown

        :type  logical_router_port_id: :class:`str`
        :param logical_router_port_id: (required)
        :type  barrier_id: :class:`long` or ``None``
        :param barrier_id: (optional)
        :type  request_id: :class:`str` or ``None``
        :param request_id: Realization request ID (optional)
        :rtype: :class:`com.vmware.nsx.model_client.LogicalRouterPortState`
        :return: com.vmware.nsx.model.LogicalRouterPortState
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_router_ports.State.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'logical_router_port_id': logical_router_port_id,
                            'barrier_id': barrier_id,
                            'request_id': request_id,
                            })
class Statistics(VapiInterface):
    """
    
    """
    GET_SOURCE_REALTIME = "realtime"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """
    GET_SOURCE_CACHED = "cached"
    """
    Possible value for ``source`` of method :func:`Statistics.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.logical_router_ports.statistics'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatisticsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            logical_router_port_id,
            source=None,
            transport_node_id=None,
            ):
        """
        Returns the statistics for the Logical Router Port. If query parameter
        \"transport_node_id=<transport-node-id>\" is given, only the statistics
        from the given node for the logical router port will be returned.
        Otherwise the statistics from each node for the same logical router
        port will be returned. The transport_node_id is mandatory if the router
        port is not uplink type. The query parameter \"source=cached\" will be
        ignored and it will always return realtime statistics of the logical
        router port. 
        
        Please use below Policy API. 
        GET
        /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default
        GET
        /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>/statistics?enforcement_point_path=/infra/sites/default/enforcement-points/default

        .. deprecated:: unknown

        :type  logical_router_port_id: :class:`str`
        :param logical_router_port_id: (required)
        :type  source: :class:`str` or ``None``
        :param source: Data source type. (optional)
        :type  transport_node_id: :class:`str` or ``None``
        :param transport_node_id: TransportNode Id (optional)
        :rtype: :class:`com.vmware.nsx.model_client.LogicalRouterPortStatistics`
        :return: com.vmware.nsx.model.LogicalRouterPortStatistics
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_router_ports.Statistics.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'logical_router_port_id': logical_router_port_id,
                            'source': source,
                            'transport_node_id': transport_node_id,
                            })
class _ArpTableStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'logical_router_port_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
            'source': type.OptionalType(type.StringType()),
            'transport_node_id': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-router-ports/{logical-router-port-id}/arp-table',
            path_variables={
                'logical_router_port_id': 'logical-router-port-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
                'source': 'source',
                'transport_node_id': 'transport_node_id',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'LogicalRouterPortArpTable'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.logical_router_ports.arp_table',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'logical_router_port_id': type.StringType(),
            'barrier_id': type.OptionalType(type.IntegerType()),
            'request_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-router-ports/{logical-router-port-id}/state',
            path_variables={
                'logical_router_port_id': 'logical-router-port-id',
            },
             header_parameters={
                   },
            query_parameters={
                'barrier_id': 'barrier_id',
                'request_id': 'request_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'LogicalRouterPortState'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.logical_router_ports.state',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatisticsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'logical_router_port_id': type.StringType(),
            'source': type.OptionalType(type.StringType()),
            'transport_node_id': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-router-ports/{logical-router-port-id}/statistics',
            path_variables={
                'logical_router_port_id': 'logical-router-port-id',
            },
             header_parameters={
                   },
            query_parameters={
                'source': 'source',
                'transport_node_id': 'transport_node_id',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'LogicalRouterPortStatistics'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.logical_router_ports.statistics',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ArpTable': ArpTable,
        'State': State,
        'Statistics': Statistics,
        'statistics': 'com.vmware.nsx.logical_router_ports.statistics_client.StubFactory',
    }

