/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.ruleconfig.ExtensionRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;

public class RuleConfigAPI
extends ApiImplementor {
    private static final String PREFIX = "ruleConfig";
    private static final String ACTION_RESET_RULE_CONFIG_VALUE = "resetRuleConfigValue";
    private static final String ACTION_RESET_ALL_RULE_CONFIG_VALUES = "resetAllRuleConfigValues";
    private static final String ACTION_SET_RULE_CONFIG_VALUE = "setRuleConfigValue";
    private static final String VIEW_RULE_CONFIG_VALUE = "ruleConfigValue";
    private static final String VIEW_ALL_RULE_CONFIGS = "allRuleConfigs";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_VALUE = "value";
    private ExtensionRuleConfig extension;

    public RuleConfigAPI(ExtensionRuleConfig extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_RESET_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}));
        this.addApiAction(new ApiAction(ACTION_RESET_ALL_RULE_CONFIG_VALUES));
        this.addApiAction(new ApiAction(ACTION_SET_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}, new String[]{PARAM_VALUE}));
        this.addApiView(new ApiView(VIEW_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}));
        this.addApiView(new ApiView(VIEW_ALL_RULE_CONFIGS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        switch (name) {
            case "setRuleConfigValue": {
                RuleConfig rc = this.extension.getRuleConfig(params.getString(PARAM_KEY));
                if (rc != null) {
                    if (params.containsKey(PARAM_VALUE)) {
                        this.extension.setRuleConfigValue(rc.getKey(), params.getString(PARAM_VALUE));
                        break;
                    }
                    this.extension.setRuleConfigValue(rc.getKey(), "");
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "resetRuleConfigValue": {
                RuleConfig rc = this.extension.getRuleConfig(params.getString(PARAM_KEY));
                if (rc != null) {
                    this.extension.resetRuleConfigValue(rc.getKey());
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "resetAllRuleConfigValues": {
                this.extension.resetAllRuleConfigValues();
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        switch (name) {
            case "ruleConfigValue": {
                RuleConfig rc = this.extension.getRuleConfig(params.getString(PARAM_KEY));
                if (rc != null) {
                    result = new ApiResponseElement(name, rc.getValue());
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "allRuleConfigs": {
                List<RuleConfig> allRules = this.extension.getAllRuleConfigs();
                ApiResponseList resultList = new ApiResponseList(name);
                for (RuleConfig rc2 : allRules) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_KEY, String.valueOf(rc2.getKey()));
                    map.put("defaultValue", rc2.getDefaultValue());
                    map.put(PARAM_VALUE, String.valueOf(rc2.getValue()));
                    if (Constant.messages.containsKey(rc2.getKey())) {
                        map.put("description", Constant.messages.getString(rc2.getKey()));
                    }
                    resultList.addItem(new ApiResponseSet(PREFIX, map));
                }
                result = resultList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }
}

