/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.Mapping;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mapping.Messages;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String transName;
    private String fileName;
    private String directoryPath;
    private List<MappingIODefinition> inputMappings = new ArrayList<MappingIODefinition>();
    private List<MappingIODefinition> outputMappings = new ArrayList<MappingIODefinition>();
    private MappingParameters mappingParameters = new MappingParameters();
    private Repository repository;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.setDefault();
        try {
            this.readData(stepnode);
        }
        catch (KettleException e) {
            throw new KettleXMLException(Messages.getString("MappingMeta.Exception.ErrorLoadingTransformationStepFromXML"), (Throwable)e);
        }
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleException {
        this.transName = XMLHandler.getTagValue((Node)stepnode, (String)"trans_name");
        this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
        this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
        Node mappingsNode = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
        if (mappingsNode != null) {
            Node inputNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"input");
            int nrInputMappings = XMLHandler.countNodes((Node)inputNode, (String)"mapping");
            for (int i = 0; i < nrInputMappings; ++i) {
                Node mappingNode = XMLHandler.getSubNodeByNr((Node)inputNode, (String)"mapping", (int)i);
                MappingIODefinition inputMappingDefinition = new MappingIODefinition(mappingNode);
                this.inputMappings.add(inputMappingDefinition);
            }
            Node outputNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"output");
            int nrOutputMappings = XMLHandler.countNodes((Node)outputNode, (String)"mapping");
            for (int i = 0; i < nrOutputMappings; ++i) {
                Node mappingNode = XMLHandler.getSubNodeByNr((Node)outputNode, (String)"mapping", (int)i);
                MappingIODefinition outputMappingDefinition = new MappingIODefinition(mappingNode);
                this.outputMappings.add(outputMappingDefinition);
            }
            Node mappingParametersNode = XMLHandler.getSubNode((Node)mappingsNode, (String)"parameters");
            this.mappingParameters = new MappingParameters(mappingParametersNode);
        } else {
            Node inputNode = XMLHandler.getSubNode((Node)stepnode, (String)"input");
            Node outputNode = XMLHandler.getSubNode((Node)stepnode, (String)"output");
            int nrInput = XMLHandler.countNodes((Node)inputNode, (String)"connector");
            int nrOutput = XMLHandler.countNodes((Node)outputNode, (String)"connector");
            MappingIODefinition inputMappingDefinition = new MappingIODefinition();
            inputMappingDefinition.setMainDataPath(true);
            for (int i = 0; i < nrInput; ++i) {
                Node inputConnector = XMLHandler.getSubNodeByNr((Node)inputNode, (String)"connector", (int)i);
                String inputField = XMLHandler.getTagValue((Node)inputConnector, (String)"field");
                String inputMapping = XMLHandler.getTagValue((Node)inputConnector, (String)"mapping");
                inputMappingDefinition.getValueRenames().add(new MappingValueRename(inputField, inputMapping));
            }
            MappingIODefinition outputMappingDefinition = new MappingIODefinition();
            outputMappingDefinition.setMainDataPath(true);
            for (int i = 0; i < nrOutput; ++i) {
                Node outputConnector = XMLHandler.getSubNodeByNr((Node)outputNode, (String)"connector", (int)i);
                String outputField = XMLHandler.getTagValue((Node)outputConnector, (String)"field");
                String outputMapping = XMLHandler.getTagValue((Node)outputConnector, (String)"mapping");
                outputMappingDefinition.getValueRenames().add(new MappingValueRename(outputMapping, outputField));
            }
            this.inputMappings.add(inputMappingDefinition);
            this.outputMappings.add(outputMappingDefinition);
            this.mappingParameters = new MappingParameters();
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_name", (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.openTag((String)"mappings")).append(Const.CR);
        retval.append("      ").append(XMLHandler.openTag((String)"input")).append(Const.CR);
        for (i = 0; i < this.inputMappings.size(); ++i) {
            retval.append(this.inputMappings.get(i).getXML());
        }
        retval.append("      ").append(XMLHandler.closeTag((String)"input")).append(Const.CR);
        retval.append("      ").append(XMLHandler.openTag((String)"output")).append(Const.CR);
        for (i = 0; i < this.outputMappings.size(); ++i) {
            retval.append(this.outputMappings.get(i).getXML());
        }
        retval.append("      ").append(XMLHandler.closeTag((String)"output")).append(Const.CR);
        retval.append("      ").append(this.mappingParameters.getXML()).append(Const.CR);
        retval.append("    ").append(XMLHandler.closeTag((String)"mappings")).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.transName = rep.getStepAttributeString(id_step, "trans_name");
        this.fileName = rep.getStepAttributeString(id_step, "filename");
        this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
        int nrInput = rep.countNrStepAttributes(id_step, "input_field");
        int nrOutput = rep.countNrStepAttributes(id_step, "output_field");
        if (nrInput > 0 || nrOutput > 0) {
            MappingIODefinition inputMappingDefinition = new MappingIODefinition();
            inputMappingDefinition.setMainDataPath(true);
            for (int i = 0; i < nrInput; ++i) {
                String inputField = rep.getStepAttributeString(id_step, i, "input_field");
                String inputMapping = rep.getStepAttributeString(id_step, i, "input_mapping");
                inputMappingDefinition.getValueRenames().add(new MappingValueRename(inputField, inputMapping));
            }
            MappingIODefinition outputMappingDefinition = new MappingIODefinition();
            outputMappingDefinition.setMainDataPath(true);
            for (int i = 0; i < nrOutput; ++i) {
                String outputField = rep.getStepAttributeString(id_step, i, "output_field");
                String outputMapping = rep.getStepAttributeString(id_step, i, "output_mapping");
                outputMappingDefinition.getValueRenames().add(new MappingValueRename(outputMapping, outputField));
            }
            this.inputMappings.add(inputMappingDefinition);
            this.outputMappings.add(outputMappingDefinition);
            this.mappingParameters = new MappingParameters();
        } else {
            int i;
            nrInput = rep.countNrStepAttributes(id_step, "input_input_step");
            nrOutput = rep.countNrStepAttributes(id_step, "output_input_step");
            for (i = 0; i < nrInput; ++i) {
                this.inputMappings.add(new MappingIODefinition(rep, id_step, "input_", i));
            }
            for (i = 0; i < nrOutput; ++i) {
                this.outputMappings.add(new MappingIODefinition(rep, id_step, "output_", i));
            }
            this.mappingParameters = new MappingParameters(rep, id_step);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        int i;
        rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
        rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.transName);
        if (rep.getImportBaseDirectory() != null && !rep.getImportBaseDirectory().isRoot()) {
            this.directoryPath = rep.getImportBaseDirectory().getPath() + this.directoryPath;
        }
        rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
        for (i = 0; i < this.inputMappings.size(); ++i) {
            this.inputMappings.get(i).saveRep(rep, id_transformation, id_step, "input_", i);
        }
        for (i = 0; i < this.outputMappings.size(); ++i) {
            this.outputMappings.get(i).saveRep(rep, id_transformation, id_step, "output_", i);
        }
        this.mappingParameters.saveRep(rep, id_transformation, id_step);
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        TransMeta mappingTransMeta = null;
        try {
            mappingTransMeta = MappingMeta.loadMappingMeta(this.fileName, this.transName, this.directoryPath, this.repository, space);
        }
        catch (KettleException e) {
            throw new KettleStepException(Messages.getString("MappingMeta.Exception.UnableToLoadMappingTransformation"), (Throwable)e);
        }
        ArrayList<MappingValueRename> inputRenameList = new ArrayList<MappingValueRename>();
        for (MappingIODefinition definition : this.inputMappings) {
            RowMetaInterface inputRowMeta;
            if (definition.isMainDataPath() || Const.isEmpty((String)definition.getInputStepname())) {
                inputRowMeta = row.clone();
                for (MappingValueRename valueRename : definition.getValueRenames()) {
                    ValueMetaInterface valueMeta = inputRowMeta.searchValueMeta(valueRename.getSourceValueName());
                    if (valueMeta == null) {
                        throw new KettleStepException(Messages.getString("MappingMeta.Exception.UnableToFindField", valueRename.getSourceValueName()));
                    }
                    valueMeta.setName(valueRename.getTargetValueName());
                }
            } else {
                String[] infoSteps = this.getInfoSteps();
                int infoStepIndex = Const.indexOfString((String)definition.getInputStepname(), (String[])infoSteps);
                if (infoStepIndex < 0) {
                    throw new KettleStepException(Messages.getString("MappingMeta.Exception.UnableToFindMetadataInfo", definition.getInputStepname()));
                }
                inputRowMeta = info[infoStepIndex].clone();
            }
            StepMeta mappingInputStep = mappingTransMeta.findMappingInputStep(definition.getOutputStepname());
            MappingInputMeta mappingInputMeta = (MappingInputMeta)mappingInputStep.getStepMetaInterface();
            mappingInputMeta.setInputRowMeta(inputRowMeta);
            mappingInputMeta.setValueRenames(definition.getValueRenames());
            if (!definition.isRenamingOnOutput()) continue;
            Mapping.addInputRenames(inputRenameList, definition.getValueRenames());
        }
        MappingIODefinition mappingOutputDefinition = null;
        if (nextStep == null) {
            for (MappingIODefinition definition : this.outputMappings) {
                if (!definition.isMainDataPath() && !Const.isEmpty((String)definition.getOutputStepname())) continue;
                mappingOutputDefinition = definition;
            }
        } else {
            for (MappingIODefinition definition : this.outputMappings) {
                if (!nextStep.getName().equals(definition.getOutputStepname()) && !definition.isMainDataPath() && !Const.isEmpty((String)definition.getOutputStepname())) continue;
                mappingOutputDefinition = definition;
            }
        }
        if (mappingOutputDefinition == null) {
            throw new KettleStepException(Messages.getString("MappingMeta.Exception.UnableToFindMappingDefinition"));
        }
        StepMeta mappingOutputStep = mappingTransMeta.findMappingOutputStep(mappingOutputDefinition.getInputStepname());
        MappingOutputMeta mappingOutputMeta = (MappingOutputMeta)mappingOutputStep.getStepMetaInterface();
        mappingOutputMeta.setOutputValueRenames(mappingOutputDefinition.getValueRenames());
        mappingOutputMeta.setInputValueRenames(inputRenameList);
        RowMetaInterface mappingOutputRowMeta = mappingTransMeta.getStepFields(mappingOutputStep);
        row.clear();
        row.addRowMeta(mappingOutputRowMeta);
    }

    @Override
    public String[] getInfoSteps() {
        ArrayList<String> infoSteps = new ArrayList<String>();
        for (MappingIODefinition definition : this.inputMappings) {
            if (definition.isMainDataPath() || Const.isEmpty((String)definition.getInputStepname())) continue;
            infoSteps.add(definition.getInputStepname());
        }
        if (infoSteps.isEmpty()) {
            return null;
        }
        return infoSteps.toArray(new String[infoSteps.size()]);
    }

    @Override
    public String[] getTargetSteps() {
        ArrayList<String> targetSteps = new ArrayList<String>();
        for (MappingIODefinition definition : this.outputMappings) {
            if (definition.isMainDataPath() || Const.isEmpty((String)definition.getOutputStepname())) continue;
            targetSteps.add(definition.getOutputStepname());
        }
        if (targetSteps.isEmpty()) {
            return null;
        }
        return targetSteps.toArray(new String[targetSteps.size()]);
    }

    public static final synchronized TransMeta loadMappingMeta(String fileName, String transName, String directoryPath, Repository rep, VariableSpace space) throws KettleException {
        TransMeta mappingTransMeta = null;
        String realFilename = space.environmentSubstitute(fileName);
        String realTransname = space.environmentSubstitute(transName);
        if (!Const.isEmpty((String)realFilename)) {
            try {
                mappingTransMeta = new TransMeta(realFilename, false);
                LogWriter.getInstance().logDetailed("Loading Mapping from repository", "Mapping transformation was loaded from XML file [" + realFilename + "]", new Object[0]);
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("MappingMeta.Exception.UnableToLoadMapping"), (Throwable)e);
            }
        } else if (!Const.isEmpty((String)realTransname) && directoryPath != null && rep != null) {
            RepositoryDirectory repdir = rep.getDirectoryTree().findDirectory(directoryPath);
            if (repdir != null) {
                try {
                    mappingTransMeta = new TransMeta(rep, realTransname, repdir);
                    LogWriter.getInstance().logDetailed("Loading Mapping from repository", "Mapping transformation [" + realTransname + "] was loaded from the repository", new Object[0]);
                }
                catch (Exception e) {
                    LogWriter.getInstance().logError("Loading Mapping from repository", "Unable to load transformation [" + realTransname + "] : " + e.toString(), new Object[0]);
                    LogWriter.getInstance().logError("Loading Mapping from repository", Const.getStackTracker((Throwable)e), new Object[0]);
                }
            } else {
                throw new KettleException(Messages.getString("MappingMeta.Exception.UnableToLoadTransformation", realTransname) + directoryPath);
            }
        }
        return mappingTransMeta;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("MappingMeta.CheckResult.NotReceivingAnyFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("MappingMeta.CheckResult.StepReceivingFields", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("MappingMeta.CheckResult.StepReceivingFieldsFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("MappingMeta.CheckResult.NoInputReceived"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Mapping(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MappingData();
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public List<MappingIODefinition> getInputMappings() {
        return this.inputMappings;
    }

    public void setInputMappings(List<MappingIODefinition> inputMappings) {
        this.inputMappings = inputMappings;
    }

    public List<MappingIODefinition> getOutputMappings() {
        return this.outputMappings;
    }

    public void setOutputMappings(List<MappingIODefinition> outputMappings) {
        this.outputMappings = outputMappings;
    }

    public MappingParameters getMappingParameters() {
        return this.mappingParameters;
    }

    public void setMappingParameters(MappingParameters mappingParameters) {
        this.mappingParameters = mappingParameters;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = transMeta.environmentSubstitute(this.fileName);
        String realTransname = transMeta.environmentSubstitute(this.transName);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        if (!Const.isEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        } else if (!Const.isEmpty((String)realTransname)) {
            reference.getEntries().add(new ResourceEntry(realTransname, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            TransMeta mappingTransMeta = MappingMeta.loadMappingMeta(this.fileName, this.transName, this.directoryPath, repository, space);
            String proposedNewFilename = mappingTransMeta.exportResources(mappingTransMeta, definitions, resourceNamingInterface, repository);
            String newFilename = "${Internal.Transformation.Filename.Directory}/" + proposedNewFilename;
            mappingTransMeta.setFilename(newFilename);
            this.fileName = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("MappingMeta.Exception.UnableToLoadTransformation", this.fileName));
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }
}

