/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolox.swing.PScrollPaneLayout;
import edu.umd.cs.piccolox.swing.PViewport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollPaneUI;

public class PScrollPane
extends JScrollPane {
    protected PNullAction nullAction = null;
    protected boolean disableKeyActions = false;

    public PScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
        PScrollPaneLayout.UIResource uIResource = new PScrollPaneLayout.UIResource();
        this.setLayout(uIResource);
        uIResource.syncWithScrollPane(this);
    }

    public PScrollPane(Component component) {
        this(component, 20, 30);
    }

    public PScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public PScrollPane() {
        this(null, 20, 30);
    }

    public void setKeyActionsDisabled(boolean bl) {
        if (bl && this.disableKeyActions != bl) {
            this.disableKeyActions = bl;
            this.disableKeyActions();
        } else if (!bl && this.disableKeyActions != bl) {
            this.disableKeyActions = bl;
            this.installCustomKeyActions();
        }
    }

    public void setUI(ScrollPaneUI scrollPaneUI) {
        super.setUI(scrollPaneUI);
        if (!this.disableKeyActions) {
            this.installCustomKeyActions();
        } else {
            this.disableKeyActions();
        }
    }

    protected void installCustomKeyActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("scrollUp", new PScrollAction("scrollUp", 1, -1, true));
        actionMap.put("scrollDown", new PScrollAction("scrollDown", 1, 1, true));
        actionMap.put("scrollLeft", new PScrollAction("scrollLeft", 0, -1, true));
        actionMap.put("scrollRight", new PScrollAction("ScrollRight", 0, 1, true));
        actionMap.put("unitScrollRight", new PScrollAction("UnitScrollRight", 0, 1, false));
        actionMap.put("unitScrollLeft", new PScrollAction("UnitScrollLeft", 0, -1, false));
        actionMap.put("unitScrollUp", new PScrollAction("UnitScrollUp", 1, -1, false));
        actionMap.put("unitScrollDown", new PScrollAction("UnitScrollDown", 1, 1, false));
        actionMap.put("scrollEnd", new PScrollEndAction("ScrollEnd"));
        actionMap.put("scrollHome", new PScrollHomeAction("ScrollHome"));
    }

    protected void disableKeyActions() {
        ActionMap actionMap = this.getActionMap();
        if (this.nullAction == null) {
            this.nullAction = new PNullAction();
        }
        actionMap.put("scrollUp", this.nullAction);
        actionMap.put("scrollDown", this.nullAction);
        actionMap.put("scrollLeft", this.nullAction);
        actionMap.put("scrollRight", this.nullAction);
        actionMap.put("unitScrollRight", this.nullAction);
        actionMap.put("unitScrollLeft", this.nullAction);
        actionMap.put("unitScrollUp", this.nullAction);
        actionMap.put("unitScrollDown", this.nullAction);
        actionMap.put("scrollEnd", this.nullAction);
        actionMap.put("scrollHome", this.nullAction);
    }

    protected JViewport createViewport() {
        return new PViewport();
    }

    protected static class PNullAction
    extends AbstractAction {
        protected PNullAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected static class PScrollEndAction
    extends AbstractAction {
        protected PScrollEndAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JViewport jViewport;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            if ((jScrollPane.getVerticalScrollBar().isShowing() || jScrollPane.getHorizontalScrollBar().isShowing()) && (jViewport = jScrollPane.getViewport()) != null && jViewport.getView() != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = jViewport.getViewSize();
                jViewport.setViewPosition(new Point(dimension.width - rectangle.width, dimension.height - rectangle.height));
            }
        }
    }

    private static class PScrollHomeAction
    extends AbstractAction {
        protected PScrollHomeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JViewport jViewport;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            if ((jScrollPane.getVerticalScrollBar().isShowing() || jScrollPane.getHorizontalScrollBar().isShowing()) && (jViewport = jScrollPane.getViewport()) != null && jViewport.getView() != null) {
                jViewport.setViewPosition(new Point(0, 0));
            }
        }
    }

    protected static class PScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        protected PScrollAction(String string, int n, int n2, boolean bl) {
            super(string);
            this.orientation = n;
            this.direction = n2;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JViewport jViewport;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            if ((this.orientation == 1 && jScrollPane.getVerticalScrollBar().isShowing() || this.orientation == 0 && jScrollPane.getHorizontalScrollBar().isShowing()) && (jViewport = jScrollPane.getViewport()) != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = jViewport.getViewSize();
                int n = component instanceof Scrollable ? (this.block ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? rectangle.height : rectangle.width) : 10);
                if (this.orientation == 1) {
                    rectangle.y += n * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else {
                    rectangle.x += n * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }
    }
}

