/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.FreeColInputDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;

public final class MapSizeDialog
extends FreeColInputDialog<Dimension> {
    private static final int COLUMNS = 5;
    private static final int DEFAULT_HEIGHT = 100;
    private static final int DEFAULT_WIDTH = 40;
    private final JTextField inputWidth = new JTextField(Integer.toString(40), 5);
    private final JTextField inputHeight = new JTextField(Integer.toString(100), 5);

    public MapSizeDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
        JLabel widthLabel = Utility.localizedLabel("width");
        widthLabel.setLabelFor(this.inputWidth);
        JLabel heightLabel = Utility.localizedLabel("height");
        heightLabel.setLabelFor(this.inputHeight);
        MigPanel panel = new MigPanel(new MigLayout("wrap 2"));
        panel.add((Component)Utility.localizedHeader("mapSizeDialog.mapSize", Utility.FONTSPEC_SUBTITLE), "span, align center");
        panel.add((Component)widthLabel, "newline 20");
        panel.add(this.inputWidth);
        panel.add(heightLabel);
        panel.add(this.inputHeight);
        this.initializeInputDialog(frame, true, panel, null, "ok", "cancel");
    }

    @Override
    protected Dimension getInputValue() {
        int height;
        int width;
        try {
            width = Integer.parseInt(this.inputWidth.getText());
            height = Integer.parseInt(this.inputHeight.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return width <= 0 || height <= 0 ? null : new Dimension(width, height);
    }

    @Override
    public void requestFocus() {
        this.inputWidth.requestFocus();
    }
}

