/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.RoadPainter;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.StringUtils;

public final class TileViewer
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(TileViewer.class.getName());
    private static final RescaleOp standardRescale = new RescaleOp(new float[]{0.8f, 0.8f, 0.8f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
    public static final int STATE_OFFSET_X = 25;
    public static final int STATE_OFFSET_Y = 10;
    private final ImageLibrary lib;
    private RoadPainter rp;
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private Font tinyFont;
    private Font emphFont;
    private Font normFont;

    public TileViewer(FreeColClient freeColClient, ImageLibrary lib) {
        super(freeColClient);
        this.lib = lib;
        this.updateScaledVariables();
    }

    public void updateScaledVariables() {
        Dimension tileSize = this.lib.getTileSize();
        this.rp = new RoadPainter(tileSize);
        this.tileHeight = tileSize.height;
        this.tileWidth = tileSize.width;
        this.halfHeight = this.tileHeight / 2;
        this.tinyFont = this.lib.getScaledFont("normal-plain-tiny", null);
        this.emphFont = this.lib.getScaledFont("simple-bold+italic-smaller", null);
        this.normFont = this.lib.getScaledFont("simple-bold-tiny", null);
    }

    public BufferedImage createTileImageWithBeachBorderAndItems(Tile tile) {
        if (!tile.isExplored()) {
            return this.lib.getScaledTerrainImage(null, tile.getX(), tile.getY());
        }
        TileType tileType = tile.getType();
        BufferedImage overlayImage = this.lib.getScaledOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.getForestedTileSize().height : this.tileHeight);
        BufferedImage image = new BufferedImage(this.tileWidth, compoundHeight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(0, compoundHeight - this.tileHeight);
        this.displayAnimatedBaseTiles(g2d, tile, false);
        this.displayTileWithBeach(g2d, tile);
        this.displayTileItems(g2d, tile, null, overlayImage);
        g2d.dispose();
        return image;
    }

    public BufferedImage createTileImage(Tile tile, Player player) {
        TileType tileType = tile.getType();
        BufferedImage overlayImage = this.lib.getScaledOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.getForestedTileSize().height : this.tileHeight);
        BufferedImage image = new BufferedImage(this.tileWidth, compoundHeight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(0, compoundHeight - this.tileHeight);
        this.displayTile(g2d, tile, player, overlayImage);
        g2d.dispose();
        return image;
    }

    public BufferedImage createColonyTileImage(Tile tile, Colony colony) {
        TileType tileType = tile.getType();
        BufferedImage overlayImage = this.lib.getScaledOverlayImage(tile);
        int compoundHeight = overlayImage != null ? overlayImage.getHeight() : (tileType.isForested() ? this.lib.getForestedTileSize().height : this.tileHeight);
        BufferedImage image = new BufferedImage(this.tileWidth, compoundHeight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(0, compoundHeight - this.tileHeight);
        this.displayColonyTile(g2d, tile, colony, overlayImage);
        g2d.dispose();
        return image;
    }

    public void displayColonyTiles(Graphics2D g2d, Tile[][] tiles, Colony colony) {
        for (int x = 0; x < tiles.length; ++x) {
            for (int y = 0; y < tiles[x].length; ++y) {
                if (tiles[x][y] == null) continue;
                int xx = (tiles.length - 1 - x + y) * this.tileWidth / 2;
                int yy = (x + y) * this.tileHeight / 2;
                g2d.translate(xx, yy);
                BufferedImage overlayImage = this.lib.getScaledOverlayImage(tiles[x][y]);
                this.displayColonyTile(g2d, tiles[x][y], colony, overlayImage);
                g2d.translate(-xx, -yy);
            }
        }
    }

    private void displayColonyTile(Graphics2D g2d, Tile tile, Colony colony, BufferedImage overlayImage) {
        Unit unit;
        this.displayTile(g2d, tile, colony.getOwner(), overlayImage);
        ColonyTile colonyTile = colony.getColonyTile(tile);
        if (colonyTile == null) {
            return;
        }
        switch (colonyTile.getNoWorkReason()) {
            case NONE: 
            case COLONY_CENTER: 
            case CLAIM_REQUIRED: {
                break;
            }
            default: {
                g2d.drawImage((Image)this.lib.getScaledImage("image.tile.tileTaken"), 0, 0, null);
            }
        }
        int price = colony.getOwner().getLandPrice(tile);
        if (price > 0 && !tile.hasSettlement()) {
            this.displayCenteredImage(g2d, this.lib.getScaledImage("image.tileitem.nativeLand"));
        }
        if ((unit = colonyTile.getOccupyingUnit()) != null) {
            BufferedImage image = this.lib.getSmallerUnitImage(unit);
            g2d.drawImage((Image)image, this.tileWidth / 4 - image.getWidth() / 2, this.halfHeight - image.getHeight() / 2, null);
            Player owner = this.getMyPlayer();
            String text = Messages.message(unit.getOccupationLabel(owner, false));
            g2d.drawImage((Image)this.lib.getOccupationIndicatorChip(g2d, unit, text), this.lib.scaleInt(25), 0, null);
        }
    }

    private void displayTile(Graphics2D g2d, Tile tile, Player player, BufferedImage overlayImage) {
        this.displayAnimatedBaseTiles(g2d, tile, false);
        this.displayTileWithBeach(g2d, tile);
        if (!tile.isExplored()) {
            return;
        }
        if (!this.getClientOptions().isRiverAnimationEnabled() || !tile.hasRiver() && !this.hasRiverDelta(tile)) {
            this.drawBaseTileTransitions(g2d, tile);
        }
        RescaleOp rop = player.canSee(tile) ? null : standardRescale;
        this.displayTileItems(g2d, tile, rop, overlayImage);
        this.displaySettlementWithChipsOrPopulationNumber(g2d, tile, false, rop);
        this.displayOptionalTileText(g2d, tile);
    }

    public void displayCenteredImage(Graphics2D g2d, BufferedImage image) {
        this.displayCenteredImage(g2d, image, null);
    }

    public void displayCenteredImage(Graphics2D g2d, BufferedImage image, RescaleOp rop) {
        g2d.drawImage(image, rop, (this.tileWidth - image.getWidth()) / 2, (this.tileHeight - image.getHeight()) / 2);
    }

    private void displayLargeCenteredImage(Graphics2D g2d, BufferedImage image, RescaleOp rop) {
        int x = (this.tileWidth - image.getWidth()) / 2;
        int y = this.tileHeight - image.getHeight();
        if (y > 0) {
            y /= 2;
        }
        g2d.drawImage(image, rop, x, y);
    }

    public void displayAnimatedBaseTiles(Graphics2D g2d, Tile tile, boolean freezeAnimation) {
        TileType tileType = tile.getType();
        if (tileType == null) {
            return;
        }
        long ticks = freezeAnimation || !this.getClientOptions().isTerrainAnimationsEnabled() ? 0L : System.currentTimeMillis() / 125L;
        if (tileType.isWater()) {
            List<Direction> directionsWithLand = this.allDirectionsWithLand(tile);
            if (directionsWithLand.isEmpty()) {
                g2d.drawImage((Image)this.lib.getAnimatedScaledTerrainImage(tileType, ticks), 0, 0, null);
            } else {
                g2d.drawImage((Image)this.lib.getAnimatedScaledWaterAndBeachTerrainImage(tileType, directionsWithLand, ticks), 0, 0, null);
            }
            if (this.getClientOptions().isRiverAnimationEnabled() && this.hasRiverDelta(tile)) {
                this.drawBaseTileTransitions(g2d, tile);
                this.drawRiverMouth(g2d, tile, ticks);
            }
        } else if (this.getClientOptions().isRiverAnimationEnabled() && tile.hasRiver()) {
            g2d.drawImage((Image)this.lib.getScaledTerrainImage(tileType, tile.getX(), tile.getY()), 0, 0, null);
            this.drawBaseTileTransitions(g2d, tile);
            BufferedImage img = this.lib.getAnimatedScaledRiverTerrainImage(tile, ticks);
            if (img != null) {
                g2d.drawImage((Image)img, 0, 0, null);
            }
        }
    }

    private List<Direction> allDirectionsWithLand(Tile tile) {
        List<Direction> directionsWithLand = Arrays.asList(Direction.values()).stream().filter(d -> {
            Tile neighbour = tile.getNeighbourOrNull((Direction)d);
            return neighbour != null && neighbour.isLand();
        }).collect(Collectors.toList());
        return directionsWithLand;
    }

    public void displayTileWithBeach(Graphics2D g2d, Tile tile) {
        boolean outForBaseTileAnimation;
        TileType tileType = tile.getType();
        int x = tile.getX();
        int y = tile.getY();
        boolean bl = outForBaseTileAnimation = tileType != null && (tileType.isWater() || this.getClientOptions().isRiverAnimationEnabled() && tile.hasRiver());
        if (!outForBaseTileAnimation) {
            g2d.drawImage((Image)this.lib.getScaledTerrainImage(tileType, x, y), 0, 0, null);
        }
        if (!tile.isExplored()) {
            return;
        }
    }

    void drawBaseTileTransitions(Graphics2D g2d, Tile tile) {
        if (this.getClientOptions().getRange("model.option.graphicsQuality") == 0) {
            return;
        }
        this.drawBaseTileTransitionAtDirection(g2d, tile, Direction.NE);
        this.drawBaseTileTransitionAtDirection(g2d, tile, Direction.SW);
        this.drawBaseTileTransitionAtDirection(g2d, tile, Direction.NW);
        this.drawBaseTileTransitionAtDirection(g2d, tile, Direction.SE);
        if (!this.getClientOptions().isRiverAnimationEnabled()) {
            this.drawRiverMouth(g2d, tile, 0L);
        }
    }

    private void drawBaseTileTransitionAtDirection(Graphics2D g2d, Tile tile, Direction direction) {
        boolean useVariations;
        boolean useNiceCorners = this.getClientOptions().getRange("model.option.graphicsQuality") >= 20;
        BufferedImage transitionImage = this.lib.getBaseTileTransitionImage(tile, direction, useNiceCorners, useVariations = this.getClientOptions().getRange("model.option.graphicsQuality") >= 30);
        if (transitionImage != null) {
            g2d.drawImage((Image)transitionImage, 0, 0, null);
        }
    }

    boolean hasRiverDelta(Tile tile) {
        for (Direction direction : Direction.longSides) {
            Direction reverseDirection;
            int magnitude;
            TileImprovement river;
            Tile borderingTile = tile.getNeighbourOrNull(direction);
            if (borderingTile == null || tile.isLand() || !borderingTile.isLand() || !tile.isExplored() || (river = borderingTile.getRiver()) == null || (magnitude = river.getRiverConnection(reverseDirection = direction.getReverseDirection())) <= 0) continue;
            return true;
        }
        return false;
    }

    private void drawRiverMouth(Graphics2D g2d, Tile tile, long ticks) {
        for (Direction direction : Direction.longSides) {
            Direction reverseDirection;
            int magnitude;
            TileImprovement river;
            Tile borderingTile = tile.getNeighbourOrNull(direction);
            if (borderingTile == null || tile.isLand() || !borderingTile.isLand() || !tile.isExplored() || (river = borderingTile.getRiver()) == null || (magnitude = river.getRiverConnection(reverseDirection = direction.getReverseDirection())) <= 0) continue;
            BufferedImage riverDelta = this.lib.getAnimatedScaledRiverDeltaTerrainImage(direction, ticks);
            g2d.drawImage((Image)riverDelta, 0, 0, null);
        }
    }

    public void displayUnknownTileBorder(Graphics2D g2d, Tile tile) {
        if (!tile.isExplored()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            Tile borderingTile = tile.getNeighbourOrNull(direction);
            if (borderingTile == null || borderingTile.isExplored()) continue;
            g2d.drawImage((Image)this.lib.getBorderImage(null, direction, tile.getX(), tile.getY()), 0, 0, null);
        }
    }

    public void displayOptionalTileText(Graphics2D g2d, Tile tile) {
        String value;
        if (this.tinyFont == null) {
            return;
        }
        String text = null;
        int op = this.getClientOptions().getInteger("model.option.displayTileText");
        switch (op) {
            case 1: {
                text = Messages.getName(tile);
                break;
            }
            case 2: {
                if (tile.getOwner() == null) break;
                text = Messages.message(tile.getOwner().getNationLabel());
                break;
            }
            case 3: {
                if (tile.getRegion() == null) break;
                if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && tile.getRegion().getName() == null) {
                    text = tile.getRegion().getSuffix();
                    break;
                }
                text = Messages.message(tile.getRegion().getLabel());
                break;
            }
            case 0: {
                break;
            }
            default: {
                logger.warning("displayTileText option " + op + " out of range");
            }
        }
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        g2d.setFont(this.tinyFont);
        if (text != null) {
            int b = StringUtils.getBreakingPoint(text);
            if (b == -1) {
                g2d.drawString(text, (this.tileWidth - fm.stringWidth(text)) / 2, (this.tileHeight - fm.getAscent()) / 2);
            } else {
                g2d.drawString(text.substring(0, b), (this.tileWidth - fm.stringWidth(text.substring(0, b))) / 2, this.halfHeight - fm.getAscent() * 2 / 3);
                g2d.drawString(text.substring(b + 1), (this.tileWidth - fm.stringWidth(text.substring(b + 1))) / 2, this.halfHeight + fm.getAscent() * 2 / 3);
            }
        }
        if (FreeColDebugger.debugDisplayCoordinates()) {
            String posString = tile.getX() + ", " + tile.getY();
            if (tile.getHighSeasCount() >= 0) {
                posString = posString + "/" + Integer.toString(tile.getHighSeasCount());
            }
            g2d.drawString(posString, (this.tileWidth - fm.stringWidth(posString)) / 2, (this.tileHeight - fm.getAscent()) / 2);
        }
        if ((value = DebugUtils.getColonyValue(tile)) != null) {
            g2d.drawString(value, (this.tileWidth - fm.stringWidth(value)) / 2, (this.tileHeight - fm.getAscent()) / 2);
        }
    }

    public void displaySettlementWithChipsOrPopulationNumber(Graphics2D g2d, Tile tile, boolean withNumber, RescaleOp rop) {
        Player player = this.getMyPlayer();
        Settlement settlement = tile.getSettlement();
        if (settlement == null) {
            return;
        }
        BufferedImage sImage = this.lib.getScaledSettlementImage(settlement);
        this.displayLargeCenteredImage(g2d, sImage, rop);
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            if (withNumber) {
                Font font;
                Font font2 = font = colony.getPreferredSizeChange() > 0 ? this.emphFont : this.normFont;
                if (font != null) {
                    String populationString = Integer.toString(colony.getApparentUnitCount());
                    String colorString = "color.map.productionBonus." + colony.getProductionBonus();
                    BufferedImage stringImage = this.lib.getStringImage(g2d, populationString, ImageLibrary.getColor(colorString), font);
                    this.displayCenteredImage(g2d, stringImage, rop);
                }
            }
        } else if (settlement instanceof IndianSettlement) {
            BufferedImage chip;
            IndianSettlement is = (IndianSettlement)settlement;
            float xOffset = this.lib.scaleInt(25);
            float yOffset = this.lib.scaleInt(10);
            int colonyLabels = this.getClientOptions().getInteger("model.option.displayColonyLabels");
            if (colonyLabels != 2) {
                chip = this.lib.getIndianSettlementChip(g2d, is);
                int cWidth = chip.getWidth();
                g2d.drawImage(chip, rop, (int)xOffset, (int)yOffset);
                xOffset += (float)(cWidth + 2);
                Unit missionary = is.getMissionary();
                if (missionary != null) {
                    boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                    g2d.drawImage(this.lib.getMissionChip(g2d, missionary.getOwner(), expert), rop, (int)xOffset, (int)yOffset);
                    xOffset += (float)(cWidth + 2);
                }
            }
            if ((chip = this.lib.getAlarmChip(g2d, is, player)) != null) {
                g2d.drawImage(chip, rop, (int)xOffset, (int)yOffset);
            }
        } else {
            logger.warning("Bogus settlement: " + settlement);
        }
    }

    public void displayTileItems(Graphics2D g2d, Tile tile, RescaleOp rop, BufferedImage overlayImage) {
        int startIndex;
        int index;
        BufferedImage image = new BufferedImage(this.tileWidth, this.tileHeight + this.halfHeight, 2);
        Graphics2D g1 = (Graphics2D)image.getGraphics();
        g1.translate(0, this.halfHeight);
        ArrayList<TileItem> tileItems = new ArrayList<TileItem>(tile.getCompleteItems());
        Collections.sort(tileItems, (a, b) -> Integer.valueOf(a.getZIndex()).compareTo(b.getZIndex()));
        for (index = startIndex = 0; index < tileItems.size(); ++index) {
            if (((TileItem)tileItems.get(index)).getZIndex() >= 100) {
                startIndex = index;
                break;
            }
            this.displayTileItem(g1, tile, (TileItem)tileItems.get(index));
            startIndex = index + 1;
        }
        if (overlayImage != null) {
            g1.drawImage((Image)overlayImage, 0, this.tileHeight - overlayImage.getHeight(), null);
        }
        for (index = startIndex; index < tileItems.size(); ++index) {
            if (((TileItem)tileItems.get(index)).getZIndex() >= 200) {
                startIndex = index;
                break;
            }
            this.displayTileItem(g1, tile, (TileItem)tileItems.get(index));
            startIndex = index + 1;
        }
        if (tile.isForested()) {
            BufferedImage forestImage = this.lib.getScaledForestImage(tile.getType(), tile.getRiverStyle());
            g1.drawImage((Image)forestImage, 0, this.tileHeight - forestImage.getHeight(), null);
        } else if (this.getClientOptions().getRange("model.option.graphicsQuality") >= 30) {
            this.drawForestCornerImages(tile, g1);
        }
        for (TileItem ti : tileItems.subList(startIndex, tileItems.size())) {
            this.displayTileItem(g1, tile, ti);
        }
        g1.dispose();
        g2d.drawImage(image, rop, 0, -this.halfHeight);
    }

    private void drawForestCornerImages(Tile tile, Graphics2D g1) {
        this.drawForestCornerImageFor(tile, g1, Direction.NW, Direction.NE, Direction.N);
        this.drawForestCornerImageFor(tile, g1, Direction.SW, Direction.SE, Direction.S);
        this.drawForestCornerImageFor(tile, g1, Direction.NE, Direction.SE, Direction.E);
        this.drawForestCornerImageFor(tile, g1, Direction.NW, Direction.SW, Direction.W);
    }

    private void drawForestCornerImageFor(Tile tile, Graphics2D g1, Direction d1, Direction d2, Direction d3) {
        BufferedImage forestCornerImage;
        if (tile.hasRiver()) {
            return;
        }
        Tile tile1 = tile.getNeighbourOrNull(d1);
        if (tile1 == null || !tile1.isForested()) {
            return;
        }
        Tile tile2 = tile.getNeighbourOrNull(d2);
        if (this.hasSameForestedTileType(tile1, tile2) && (forestCornerImage = this.lib.getForestCornerImage(tile1.getType(), d3)) != null) {
            g1.drawImage((Image)forestCornerImage, 0, this.tileHeight - forestCornerImage.getHeight(), null);
        }
    }

    private boolean hasSameForestedTileType(Tile t1, Tile t2) {
        return t1 != null && t2 != null && t1.isForested() && t1.getType() == t2.getType();
    }

    private void displayTileItem(Graphics2D g2d, Tile tile, TileItem item) {
        if (item instanceof TileImprovement) {
            TileImprovement ti = (TileImprovement)item;
            if (!ti.isComplete()) {
                return;
            }
            if (ti.isRoad()) {
                this.rp.displayRoad(g2d, tile);
            } else if (ti.isRiver()) {
                if (this.getClientOptions().isRiverAnimationEnabled()) {
                    return;
                }
                BufferedImage img = this.lib.getAnimatedScaledRiverTerrainImage(tile, 0L);
                if (img != null) {
                    g2d.drawImage((Image)img, 0, 0, null);
                }
            } else {
                BufferedImage img = this.lib.getTileImprovementImage(ti.getType().getId());
                if (img != null) {
                    g2d.drawImage((Image)img, 0, 0, null);
                }
            }
        } else if (item instanceof LostCityRumour) {
            this.displayCenteredImage(g2d, this.lib.getScaledImage("image.tileitem.lostCityRumour"));
        } else if (item instanceof Resource) {
            this.displayCenteredImage(g2d, this.lib.getScaledResourceImage((Resource)item));
        }
    }
}

