/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.services;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.internal.DefaultProblemsSummaryProgressDetails;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.api.problems.internal.ProblemReportCreator;
import org.gradle.api.problems.internal.ProblemSummarizer;
import org.gradle.api.problems.internal.ProblemSummaryData;
import org.gradle.api.problems.internal.ProblemsInfrastructure;
import org.gradle.api.problems.internal.TaskIdentity;
import org.gradle.api.problems.internal.TaskIdentityProvider;
import org.gradle.internal.buildoption.IntegerInternalOption;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.buildtree.ProblemReporter;
import org.gradle.problems.internal.services.SummarizerStrategy;

public class DefaultProblemSummarizer
implements ProblemSummarizer {
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final Collection<ProblemEmitter> problemEmitters;
    private final ProblemReportCreator problemReportCreator;
    private final SummarizerStrategy summarizerStrategy;
    private final TaskIdentityProvider taskProvider;
    public static final InternalOption<Integer> THRESHOLD_OPTION = new IntegerInternalOption("org.gradle.internal.problem.summary.threshold", 15);
    public static final int THRESHOLD_DEFAULT_VALUE = (Integer)THRESHOLD_OPTION.getDefaultValue();

    public DefaultProblemSummarizer(BuildOperationProgressEventEmitter eventEmitter, CurrentBuildOperationRef currentBuildOperationRef, Collection<ProblemEmitter> problemEmitters, InternalOptions internalOptions, ProblemReportCreator problemReportCreator, TaskIdentityProvider taskProvider) {
        this.eventEmitter = eventEmitter;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.problemEmitters = problemEmitters;
        this.summarizerStrategy = new SummarizerStrategy((Integer)internalOptions.getOption(THRESHOLD_OPTION).get());
        this.problemReportCreator = problemReportCreator;
        this.taskProvider = taskProvider;
    }

    public String getId() {
        return "problem summarizer";
    }

    public void report(File reportDir, ProblemReporter.ProblemConsumer validationFailures) {
        List<ProblemSummaryData> cutOffProblems = this.summarizerStrategy.getCutOffProblems();
        this.problemReportCreator.createReportFile(reportDir, cutOffProblems);
        this.eventEmitter.emitNow(this.currentBuildOperationRef.getId(), (Object)new DefaultProblemsSummaryProgressDetails(cutOffProblems));
    }

    public void emit(InternalProblem problem, @Nullable OperationIdentifier id) {
        if (this.summarizerStrategy.shouldEmit(problem)) {
            problem = this.maybeAddTaskLocation(problem, id);
            this.problemReportCreator.addProblem(problem);
            for (ProblemEmitter problemEmitter : this.problemEmitters) {
                problemEmitter.emit(problem, id);
            }
        }
    }

    @Nonnull
    private InternalProblem maybeAddTaskLocation(InternalProblem problem, @Nullable OperationIdentifier id) {
        TaskIdentity taskIdentity = this.taskProvider.taskIdentityFor(id);
        if (taskIdentity != null) {
            problem = problem.toBuilder(new ProblemsInfrastructure(null, null, null, null, null, null)).taskLocation(taskIdentity.getTaskPath()).build();
        }
        return problem;
    }
}

