/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.utils.CodeUtils;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.JNodeAction;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FridaAction
extends JNodeAction {
    private static final Logger LOG = LoggerFactory.getLogger(FridaAction.class);
    private static final long serialVersionUID = -3084073927621269039L;

    public FridaAction(CodeArea codeArea) {
        super(NLS.str("popup.frida") + " (f)", codeArea);
        this.addKeyBinding(KeyStroke.getKeyStroke(70, 0), "trigger frida");
    }

    @Override
    public void runAction(JNode node) {
        try {
            String fridaSnippet = this.generateFridaSnippet(node);
            LOG.info("Frida snippet:\n{}", (Object)fridaSnippet);
            UiUtils.copyToClipboard(fridaSnippet);
        }
        catch (Exception e) {
            LOG.error("Failed to generate Frida code snippet", (Throwable)e);
            JOptionPane.showMessageDialog(this.getCodeArea().getMainWindow(), e.getLocalizedMessage(), NLS.str("error_dialog.title"), 0);
        }
    }

    @Override
    public boolean isActionEnabled(JNode node) {
        return node instanceof JMethod || node instanceof JClass || node instanceof JField;
    }

    private String generateFridaSnippet(JNode node) {
        if (node instanceof JMethod) {
            return this.generateMethodSnippet((JMethod)node);
        }
        if (node instanceof JClass) {
            return this.generateClassSnippet((JClass)node);
        }
        if (node instanceof JField) {
            return this.generateFieldSnippet((JField)node);
        }
        throw new JadxRuntimeException("Unsupported node type: " + (node != null ? node.getClass() : "null"));
    }

    private String generateMethodSnippet(JMethod jMth) {
        String overload;
        String newMethodName;
        String methodName;
        MethodNode mth = jMth.getJavaMethod().getMethodNode();
        MethodInfo methodInfo = mth.getMethodInfo();
        if (methodInfo.isConstructor()) {
            newMethodName = methodName = "$init";
        } else {
            methodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getName());
            newMethodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getAlias());
        }
        if (this.isOverloaded(mth).booleanValue()) {
            String overloadArgs = methodInfo.getArgumentsTypes().stream().map(this::parseArgType).collect(Collectors.joining(", "));
            overload = ".overload(" + overloadArgs + ")";
        } else {
            overload = "";
        }
        List<String> argNames = this.collectMethodArgNames(jMth.getJavaMethod());
        String args = String.join((CharSequence)", ", argNames);
        String logArgs = argNames.isEmpty() ? "" : ": " + argNames.stream().map(arg -> arg + "=${" + arg + "}").collect(Collectors.joining(", "));
        String shortClassName = mth.getParentClass().getShortName();
        String classSnippet = this.generateClassSnippet(jMth.getJParent());
        if (methodInfo.isConstructor() || methodInfo.getReturnType() == ArgType.VOID) {
            return classSnippet + "\n" + shortClassName + "[\"" + methodName + "\"]" + overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + logArgs + "`);\n    this[\"" + methodName + "\"](" + args + ");\n};";
        }
        return classSnippet + "\n" + shortClassName + "[\"" + methodName + "\"]" + overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + logArgs + "`);\n    let result = this[\"" + methodName + "\"](" + args + ");\n    console.log(`" + shortClassName + "." + newMethodName + " result=${result}`);\n    return result;\n};";
    }

    private List<String> collectMethodArgNames(JavaMethod javaMethod) {
        ICodeInfo codeInfo = javaMethod.getTopParentClass().getCodeInfo();
        int mthDefPos = javaMethod.getDefPos();
        int lineEndPos = CodeUtils.getLineEndForPos((String)codeInfo.getCodeStr(), (int)mthDefPos);
        ArrayList<String> argNames = new ArrayList<String>();
        codeInfo.getCodeMetadata().searchDown(mthDefPos, (pos, ann) -> {
            VarNode varNode;
            ICodeNodeRef declRef;
            if (pos > lineEndPos) {
                return Boolean.TRUE;
            }
            if (ann instanceof NodeDeclareRef && (declRef = ((NodeDeclareRef)ann).getNode()) instanceof VarNode && (varNode = (VarNode)declRef).getMth().equals((Object)javaMethod.getMethodNode())) {
                argNames.add(varNode.getName());
            }
            return null;
        });
        int argsCount = javaMethod.getMethodNode().getMethodInfo().getArgsCount();
        if (argNames.size() != argsCount) {
            LOG.warn("Incorrect args count, expected: {}, got: {}", (Object)argsCount, (Object)argNames.size());
        }
        return argNames;
    }

    private String generateClassSnippet(JClass jc) {
        JavaClass javaClass = jc.getCls();
        String rawClassName = StringEscapeUtils.escapeEcmaScript((String)javaClass.getRawName());
        String shortClassName = javaClass.getName();
        return String.format("let %s = Java.use(\"%s\");", shortClassName, rawClassName);
    }

    private String generateFieldSnippet(JField jf) {
        JavaField javaField = jf.getJavaField();
        String rawFieldName = StringEscapeUtils.escapeEcmaScript((String)javaField.getRawName());
        String fieldName = javaField.getName();
        List methodNodes = javaField.getFieldNode().getParentClass().getMethods();
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.getName().equals(rawFieldName)) continue;
            rawFieldName = "_" + rawFieldName;
            break;
        }
        JClass jc = jf.getRootClass();
        String classSnippet = this.generateClassSnippet(jc);
        return String.format("%s\n%s = %s.%s.value;", classSnippet, fieldName, jc.getName(), rawFieldName);
    }

    public Boolean isOverloaded(MethodNode methodNode) {
        return methodNode.getParentClass().getMethods().stream().anyMatch(m -> m.getName().equals(methodNode.getName()) && !Objects.equals(methodNode.getMethodInfo().getShortId(), m.getMethodInfo().getShortId()));
    }

    private String parseArgType(ArgType x) {
        String typeStr = x.isArray() ? TypeGen.signature((ArgType)x).replace("/", ".") : x.toString();
        return "'" + typeStr + "'";
    }
}

