/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.OperatingSystemMXBean;
import javax.management.ObjectName;
import sun.management.Util;
import sun.management.VMManagement;
import sun.misc.Unsafe;

public class BaseOperatingSystemImpl
implements OperatingSystemMXBean {
    private final VMManagement jvm;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private double[] loadavg = new double[1];

    protected BaseOperatingSystemImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    @Override
    public String getName() {
        return this.jvm.getOsName();
    }

    @Override
    public String getArch() {
        return this.jvm.getOsArch();
    }

    @Override
    public String getVersion() {
        return this.jvm.getOsVersion();
    }

    @Override
    public int getAvailableProcessors() {
        return this.jvm.getAvailableProcessors();
    }

    @Override
    public double getSystemLoadAverage() {
        if (unsafe.getLoadAverage(this.loadavg, 1) == 1) {
            return this.loadavg[0];
        }
        return -1.0;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=OperatingSystem");
    }
}

