/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.metrics;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/metrics/MetricsUpdater;", "", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "updateInterval", "Ljava/time/Duration;", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;)V", "disablePeriodicUpdates", "", "getDisablePeriodicUpdates", "()Z", "setDisablePeriodicUpdates", "(Z)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "subtasks", "", "Lkotlin/Function0;", "", "updateTask", "Ljava/util/concurrent/ScheduledFuture;", "addUpdateTask", "subtask", "stop", "updateMetrics", "jicoco-metrics"})
@SourceDebugExtension(value={"SMAP\nMetricsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsUpdater.kt\norg/jitsi/metrics/MetricsUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n*S KotlinDebug\n*F\n+ 1 MetricsUpdater.kt\norg/jitsi/metrics/MetricsUpdater\n*L\n59#1:76,2\n*E\n"})
public final class MetricsUpdater {
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Duration updateInterval;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<Function0<Unit>> subtasks;
    @Nullable
    private ScheduledFuture<?> updateTask;
    private boolean disablePeriodicUpdates;

    public MetricsUpdater(@NotNull ScheduledExecutorService executor, @NotNull Duration updateInterval) {
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(updateInterval, "updateInterval");
        this.executor = executor;
        this.updateInterval = updateInterval;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.subtasks = new CopyOnWriteArrayList();
    }

    public final boolean getDisablePeriodicUpdates() {
        return this.disablePeriodicUpdates;
    }

    public final void setDisablePeriodicUpdates(boolean bl) {
        this.disablePeriodicUpdates = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addUpdateTask(@NotNull Function0<Unit> subtask) {
        Intrinsics.checkNotNullParameter(subtask, "subtask");
        if (this.disablePeriodicUpdates) {
            this.logger.warn("Periodic updates are disabled, will not execute update task.");
            return;
        }
        this.subtasks.add(subtask);
        MetricsUpdater metricsUpdater = this;
        synchronized (metricsUpdater) {
            boolean bl = false;
            if (this.updateTask == null) {
                this.logger.info("Scheduling metrics update task with interval " + this.updateInterval + ".");
                this.updateTask = this.executor.scheduleAtFixedRate(() -> MetricsUpdater.addUpdateTask$lambda$1$lambda$0(this), 0L, this.updateInterval.toMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateMetrics() {
        MetricsUpdater metricsUpdater = this;
        synchronized (metricsUpdater) {
            boolean bl = false;
            this.logger.debug("Running " + this.subtasks.size() + " subtasks.");
            Iterable $this$forEach$iv = this.subtasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl2 = false;
                try {
                    it.invoke();
                }
                catch (Exception e) {
                    this.logger.warn("Exception while running subtask", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        MetricsUpdater metricsUpdater = this;
        synchronized (metricsUpdater) {
            boolean bl = false;
            ScheduledFuture<?> scheduledFuture = this.updateTask;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this.updateTask = null;
            this.subtasks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void addUpdateTask$lambda$1$lambda$0(MetricsUpdater this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.updateMetrics();
    }
}

