/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildNthRefInstr
extends NoOperandResultBaseInstr {
    public final int group;

    public BuildNthRefInstr(Variable result2, int group2) {
        super(Operation.BUILD_NTHREF, result2);
        this.group = group2;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.group);
    }

    public static BuildNthRefInstr decode(IRReaderDecoder d) {
        return new BuildNthRefInstr(d.decodeVariable(), d.decodeInt());
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildNthRefInstr(ii.getRenamedVariable(this.result), this.group);
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"$'" + this.group + "'"};
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return IRRuntimeHelpers.nthMatch(context, this.group);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildNthRefInstr(this);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        flags2.add(IRFlags.REQUIRES_BACKREF);
        return true;
    }
}

