/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBBase64;

public class CBSecurity {
    public static final byte[] PEM_BEGIN = new String("-----BEGIN").getBytes();
    public static final byte[] PEM_END = new String("-----END").getBytes();
    public static final byte[] PEM_CERT_HEADER = new String("-----BEGIN CERTIFICATE-----").getBytes();
    public static final byte[] PEM_CERT_FOOTER = new String("-----END CERTIFICATE-----").getBytes();
    public static final byte[] PEM_ENC_KEY_HEADER = new String("-----BEGIN ENCRYPTED PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_KEY_HEADER = new String("-----BEGIN PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_ENC_KEY_FOOTER = new String("-----END ENCRYPTED PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_KEY_FOOTER = new String("-----END PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_RSA_KEY_HEADER = new String("-----BEGIN RSA PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_RSA_KEY_FOOTER = new String("-----END RSA PRIVATE KEY-----").getBytes();

    public static int indexOf(byte[] mainArray, byte searchByte) {
        return CBSecurity.indexOf(mainArray, searchByte, 0);
    }

    public static int indexOf(byte[] mainArray, byte searchByte, int fromIndex) {
        int len = mainArray.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= len) {
            return -1;
        }
        for (int i = fromIndex; i < len; ++i) {
            if (mainArray[i] != searchByte) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] mainArray, byte[] searchSequence) {
        return CBSecurity.indexOf(mainArray, searchSequence, 0);
    }

    public static int indexOf(byte[] mainArray, byte[] searchSequence, int fromIndex) {
        byte[] v1 = mainArray;
        byte[] v2 = searchSequence;
        int max = mainArray.length;
        if (fromIndex >= max) {
            if (mainArray.length == 0 && fromIndex == 0 && searchSequence.length == 0) {
                return 0;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (searchSequence.length == 0) {
            return fromIndex;
        }
        byte first = v2[0];
        int i = fromIndex;
        block0: while (true) {
            if (i < max && v1[i] != first) {
                ++i;
                continue;
            }
            if (i >= max) {
                return -1;
            }
            int j = i + 1;
            int end = j + searchSequence.length - 1;
            int k = 1;
            while (j < end) {
                if (v1[j++] == v2[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static boolean isPEM(byte[] test) {
        if (CBSecurity.indexOf(test, PEM_BEGIN) == -1) {
            return false;
        }
        return CBSecurity.indexOf(test, PEM_END) != -1;
    }

    public static byte[] convertFromPEM(byte[] pem) {
        return CBSecurity.convertFromPEM(pem, PEM_BEGIN, PEM_END);
    }

    public static byte[] convertFromPEM(byte[] pem, byte[] header) {
        return CBSecurity.convertFromPEM(pem, header, PEM_END);
    }

    public static byte[] convertFromPEMCertificate(byte[] pem) {
        return CBSecurity.convertFromPEM(pem, PEM_CERT_HEADER, PEM_END);
    }

    public static byte[] convertFromPEM(byte[] pem, byte[] header, byte[] footer) {
        int next;
        int start = CBSecurity.indexOf(pem, header);
        int end = CBSecurity.indexOf(pem, footer);
        if (start == -1 || end == -1) {
            return null;
        }
        start = CBSecurity.indexOf(pem, (byte)10, start) + 1;
        while ((next = CBSecurity.indexOf(pem, (byte)10, start)) < start + 64 && next != -1) {
            start = next + 1;
        }
        if (start == -1) {
            return null;
        }
        int len = end - start;
        byte[] data = new byte[len];
        System.arraycopy(pem, start, data, 0, len);
        return CBBase64.decode(data);
    }

    public static byte[] convertToPEMCertificate(byte[] der) {
        return CBSecurity.convertToPEM(der, PEM_CERT_HEADER, PEM_CERT_FOOTER);
    }

    public static byte[] convertToPEMRSAPrivateKey(byte[] der) {
        return CBSecurity.convertToPEM(der, PEM_RSA_KEY_HEADER, PEM_RSA_KEY_FOOTER);
    }

    public static byte[] convertToPEMEncryptedPrivateKey(byte[] der) {
        return CBSecurity.convertToPEM(der, PEM_ENC_KEY_HEADER, PEM_ENC_KEY_FOOTER);
    }

    public static byte[] convertToPEMPrivateKey(byte[] der) {
        return CBSecurity.convertToPEM(der, PEM_KEY_HEADER, PEM_KEY_FOOTER);
    }

    protected static byte[] convertToPEM(byte[] der, byte[] header, byte[] footer) {
        try {
            byte[] base64Data = CBBase64.encodeFormatted(der, 0, 64);
            int len = header.length + 1 + base64Data.length + footer.length + 1;
            byte[] pem = new byte[len];
            int pos = 0;
            System.arraycopy(header, 0, pem, 0, header.length);
            pos += header.length;
            pem[pos++] = 10;
            System.arraycopy(base64Data, 0, pem, pos, base64Data.length);
            System.arraycopy(footer, 0, pem, pos += base64Data.length, footer.length);
            pem[pos += footer.length] = 10;
            base64Data = null;
            der = null;
            return pem;
        }
        catch (Exception e) {
            System.err.println("error decoding pem file: " + e);
            return null;
        }
    }
}

