/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.light;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.light.EmptyCredentialManager;
import org.keycloak.models.light.LightweightConsentEntity;
import org.keycloak.storage.adapter.AbstractInMemoryUserAdapter;
import org.keycloak.util.JsonSerialization;

@JsonIncludeProperties(value={"id", "createdTimestamp", "emailVerified", "enabled", "roleIds", "groupIds", "attributes", "requiredActions", "federationLink", "consents", "serviceAccountClientLink", "readonly"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class LightweightUserAdapter
extends AbstractInMemoryUserAdapter {
    private Consumer<LightweightUserAdapter> updateHandler;
    public static final String ID_PREFIX = "lightweight-";
    private final Set<LightweightConsentEntity> consents;

    public static boolean isLightweightUser(UserModel user) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && user instanceof LightweightUserAdapter;
    }

    public static boolean isLightweightUser(String id) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && id != null && id.startsWith(ID_PREFIX);
    }

    public static String getLightweightUserId(String id) {
        return id == null || id.length() < ID_PREFIX.length() ? null : id.substring(ID_PREFIX.length());
    }

    public LightweightUserAdapter(KeycloakSession session, String id) {
        super(session, null, ID_PREFIX + (id == null ? SecretGenerator.getInstance().randomString(16) : id));
        this.updateHandler = a -> {};
        this.consents = new HashSet<LightweightConsentEntity>();
    }

    public LightweightUserAdapter(KeycloakSession session, RealmModel realm, String id) {
        super(session, realm, ID_PREFIX + (id == null ? SecretGenerator.getInstance().randomString(16) : id));
        this.updateHandler = a -> {};
        this.consents = new HashSet<LightweightConsentEntity>();
    }

    public void setOwningUserSessionId(String id) {
        this.id = ID_PREFIX + (id == null ? UUID.randomUUID().toString() : id);
        this.update();
    }

    protected LightweightUserAdapter() {
        this.updateHandler = a -> {};
        this.consents = new HashSet<LightweightConsentEntity>();
    }

    public static LightweightUserAdapter fromString(KeycloakSession session, RealmModel realm, String serializedForm) {
        if (serializedForm == null) {
            return null;
        }
        try {
            LightweightUserAdapter res = (LightweightUserAdapter)JsonSerialization.readValue((String)serializedForm, LightweightUserAdapter.class);
            res.session = session;
            res.realm = realm;
            return res;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public SubjectCredentialManager credentialManager() {
        return EmptyCredentialManager.INSTANCE;
    }

    public String serialize() {
        try {
            return JsonSerialization.writeValueAsString((Object)this);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        super.deleteRoleMapping(role);
        this.update();
    }

    @Override
    public void grantRole(RoleModel role) {
        super.grantRole(role);
        this.update();
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
        super.setServiceAccountClientLink(clientInternalId);
        this.update();
    }

    @Override
    public void setFederationLink(String link) {
        super.setFederationLink(link);
        this.update();
    }

    @Override
    public void leaveGroup(GroupModel group) {
        super.leaveGroup(group);
        this.update();
    }

    @Override
    public void joinGroup(GroupModel group) {
        super.joinGroup(group);
        this.update();
    }

    @Override
    public void setEmailVerified(boolean verified) {
        super.setEmailVerified(verified);
        this.update();
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        super.removeRequiredAction(action);
        this.update();
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        super.addRequiredAction(action);
        this.update();
    }

    @Override
    public void removeRequiredAction(String action) {
        super.removeRequiredAction(action);
        this.update();
    }

    @Override
    public void addRequiredAction(String action) {
        super.addRequiredAction(action);
        this.update();
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.update();
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        super.setAttribute(name, values);
        this.update();
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        super.setSingleAttribute(name, value);
        this.update();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.update();
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        super.setCreatedTimestamp(timestamp);
        this.update();
    }

    @Override
    public void setReadonly(boolean flag) {
        super.setReadonly(flag);
        this.update();
    }

    @Override
    public void addDefaults() {
        super.addDefaults();
        this.update();
    }

    @Override
    public void setUsername(String username) {
        super.setUsername(username);
        this.update();
    }

    public void setUpdateHandler(Consumer<LightweightUserAdapter> updateHandler) {
        this.updateHandler = updateHandler == null ? lua -> {} : updateHandler;
    }

    private void update() {
        this.updateHandler.accept(this);
    }

    public void addConsent(UserConsentModel consent) {
        if (consent != null) {
            this.consents.add(LightweightConsentEntity.fromModel(consent));
            this.update();
        }
    }

    public UserConsentModel getConsentByClient(String clientInternalId) {
        return LightweightConsentEntity.toModel(this.realm, this.getConsentEntityByClient(clientInternalId));
    }

    public boolean revokeConsentForClient(String clientInternalId) {
        if (clientInternalId != null) {
            boolean res = this.consents.removeIf(lce -> clientInternalId.equals(lce.getClientId()));
            if (res) {
                this.update();
            }
            return res;
        }
        return false;
    }

    public void updateConsent(UserConsentModel consent) {
        if (consent == null) {
            return;
        }
        String clientId = consent.getClient() == null ? null : consent.getClient().getId();
        LightweightConsentEntity userConsentEntity = this.getConsentEntityByClient(clientId);
        userConsentEntity.setGrantedClientScopesIds(consent.getGrantedClientScopes().stream().map(ClientScopeModel::getId).collect(Collectors.toSet()));
        this.update();
    }

    LightweightConsentEntity getConsentEntityByClient(String clientId) {
        return this.consents.stream().filter(lce -> Objects.equals(clientId, lce.getClientId())).findFirst().orElse(null);
    }

    public Stream<UserConsentModel> getConsentsStream() {
        return this.consents.stream().map(lce -> LightweightConsentEntity.toModel(this.realm, lce));
    }
}

