/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.util.Locale;
import liquibase.GlobalConfiguration;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.PostgresDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public class UpdatedPostgresDatabase
extends PostgresDatabase {
    public int getPriority() {
        return super.getPriority() + 1;
    }

    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null || this.quotingStrategy != ObjectQuotingStrategy.LEGACY) {
            return super.correctObjectName(objectName, objectType);
        }
        if (objectType.equals(Schema.class) && Boolean.TRUE.equals(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getCurrentValue())) {
            return objectName;
        }
        if (objectType.equals(Catalog.class) && !StringUtil.hasLowerCase((String)objectName)) {
            return objectName;
        }
        if (objectName.contains("-") || this.hasMixedCase(objectName) || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
            return objectName;
        }
        return objectName.toLowerCase(Locale.US);
    }
}

