/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class LoadBlockImplicitClosureInstr
extends NoOperandResultBaseInstr
implements FixedArityInstr {
    public LoadBlockImplicitClosureInstr(Variable result2) {
        super(Operation.LOAD_BLOCK_IMPLICIT_CLOSURE, result2);
        assert (result2 != null) : "LoadFrameClosureInstr result is null";
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new LoadBlockImplicitClosureInstr(info.getRenamedVariable(this.result));
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.getCallClosure() instanceof WrappedIRClosure) {
            return NopInstr.NOP;
        }
        return new CopyInstr(ii.getRenamedVariable(this.result), ii.getCallClosure());
    }

    public static LoadBlockImplicitClosureInstr decode(IRReaderDecoder d) {
        return new LoadBlockImplicitClosureInstr(d.decodeVariable());
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        return super.computeScopeFlags(scope, flags2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LoadBlockImplicitClosure(this);
    }
}

