/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;

public class CipherStrings {
    public static final String SSL2_TXT_DES_64_CFB64_WITH_MD5_1 = "DES-CFB-M1";
    public static final String SSL2_TXT_NULL_WITH_MD5 = "NULL-MD5";
    public static final String SSL2_TXT_RC4_128_WITH_MD5 = "RC4-MD5";
    public static final String SSL2_TXT_RC4_128_EXPORT40_WITH_MD5 = "EXP-RC4-MD5";
    public static final String SSL2_TXT_RC2_128_CBC_WITH_MD5 = "RC2-CBC-MD5";
    public static final String SSL2_TXT_RC2_128_CBC_EXPORT40_WITH_MD5 = "EXP-RC2-CBC-MD5";
    public static final String SSL2_TXT_IDEA_128_CBC_WITH_MD5 = "IDEA-CBC-MD5";
    public static final String SSL2_TXT_DES_64_CBC_WITH_MD5 = "DES-CBC-MD5";
    public static final String SSL2_TXT_DES_64_CBC_WITH_SHA = "DES-CBC-SHA";
    public static final String SSL2_TXT_DES_192_EDE3_CBC_WITH_MD5 = "DES-CBC3-MD5";
    public static final String SSL2_TXT_DES_192_EDE3_CBC_WITH_SHA = "DES-CBC3-SHA";
    public static final String SSL2_TXT_RC4_64_WITH_MD5 = "RC4-64-MD5";
    public static final String SSL2_TXT_NULL = "NULL";
    public static final String SSL3_TXT_RSA_NULL_MD5 = "NULL-MD5";
    public static final String SSL3_TXT_RSA_NULL_SHA = "NULL-SHA";
    public static final String SSL3_TXT_RSA_RC4_40_MD5 = "EXP-RC4-MD5";
    public static final String SSL3_TXT_RSA_RC4_128_MD5 = "RC4-MD5";
    public static final String SSL3_TXT_RSA_RC4_128_SHA = "RC4-SHA";
    public static final String SSL3_TXT_RSA_RC2_40_MD5 = "EXP-RC2-CBC-MD5";
    public static final String SSL3_TXT_RSA_IDEA_128_SHA = "IDEA-CBC-SHA";
    public static final String SSL3_TXT_RSA_DES_40_CBC_SHA = "EXP-DES-CBC-SHA";
    public static final String SSL3_TXT_RSA_DES_64_CBC_SHA = "DES-CBC-SHA";
    public static final String SSL3_TXT_RSA_DES_192_CBC3_SHA = "DES-CBC3-SHA";
    public static final String SSL3_TXT_DH_DSS_DES_40_CBC_SHA = "EXP-DH-DSS-DES-CBC-SHA";
    public static final String SSL3_TXT_DH_DSS_DES_64_CBC_SHA = "DH-DSS-DES-CBC-SHA";
    public static final String SSL3_TXT_DH_DSS_DES_192_CBC3_SHA = "DH-DSS-DES-CBC3-SHA";
    public static final String SSL3_TXT_DH_RSA_DES_40_CBC_SHA = "EXP-DH-RSA-DES-CBC-SHA";
    public static final String SSL3_TXT_DH_RSA_DES_64_CBC_SHA = "DH-RSA-DES-CBC-SHA";
    public static final String SSL3_TXT_DH_RSA_DES_192_CBC3_SHA = "DH-RSA-DES-CBC3-SHA";
    public static final String SSL3_TXT_EDH_DSS_DES_40_CBC_SHA = "EXP-EDH-DSS-DES-CBC-SHA";
    public static final String SSL3_TXT_EDH_DSS_DES_64_CBC_SHA = "EDH-DSS-DES-CBC-SHA";
    public static final String SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA = "EDH-DSS-DES-CBC3-SHA";
    public static final String SSL3_TXT_EDH_RSA_DES_40_CBC_SHA = "EXP-EDH-RSA-DES-CBC-SHA";
    public static final String SSL3_TXT_EDH_RSA_DES_64_CBC_SHA = "EDH-RSA-DES-CBC-SHA";
    public static final String SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA = "EDH-RSA-DES-CBC3-SHA";
    public static final String SSL3_TXT_ADH_RC4_40_MD5 = "EXP-ADH-RC4-MD5";
    public static final String SSL3_TXT_ADH_RC4_128_MD5 = "ADH-RC4-MD5";
    public static final String SSL3_TXT_ADH_DES_40_CBC_SHA = "EXP-ADH-DES-CBC-SHA";
    public static final String SSL3_TXT_ADH_DES_64_CBC_SHA = "ADH-DES-CBC-SHA";
    public static final String SSL3_TXT_ADH_DES_192_CBC_SHA = "ADH-DES-CBC3-SHA";
    public static final String SSL3_TXT_FZA_DMS_NULL_SHA = "FZA-NULL-SHA";
    public static final String SSL3_TXT_FZA_DMS_FZA_SHA = "FZA-FZA-CBC-SHA";
    public static final String SSL3_TXT_FZA_DMS_RC4_SHA = "FZA-RC4-SHA";
    public static final String SSL3_TXT_KRB5_DES_64_CBC_SHA = "KRB5-DES-CBC-SHA";
    public static final String SSL3_TXT_KRB5_DES_192_CBC3_SHA = "KRB5-DES-CBC3-SHA";
    public static final String SSL3_TXT_KRB5_RC4_128_SHA = "KRB5-RC4-SHA";
    public static final String SSL3_TXT_KRB5_IDEA_128_CBC_SHA = "KRB5-IDEA-CBC-SHA";
    public static final String SSL3_TXT_KRB5_DES_64_CBC_MD5 = "KRB5-DES-CBC-MD5";
    public static final String SSL3_TXT_KRB5_DES_192_CBC3_MD5 = "KRB5-DES-CBC3-MD5";
    public static final String SSL3_TXT_KRB5_RC4_128_MD5 = "KRB5-RC4-MD5";
    public static final String SSL3_TXT_KRB5_IDEA_128_CBC_MD5 = "KRB5-IDEA-CBC-MD5";
    public static final String SSL3_TXT_KRB5_DES_40_CBC_SHA = "EXP-KRB5-DES-CBC-SHA";
    public static final String SSL3_TXT_KRB5_RC2_40_CBC_SHA = "EXP-KRB5-RC2-CBC-SHA";
    public static final String SSL3_TXT_KRB5_RC4_40_SHA = "EXP-KRB5-RC4-SHA";
    public static final String SSL3_TXT_KRB5_DES_40_CBC_MD5 = "EXP-KRB5-DES-CBC-MD5";
    public static final String SSL3_TXT_KRB5_RC2_40_CBC_MD5 = "EXP-KRB5-RC2-CBC-MD5";
    public static final String SSL3_TXT_KRB5_RC4_40_MD5 = "EXP-KRB5-RC4-MD5";
    public static final String SSL_TXT_NULL_WITH_MD5 = "NULL-MD5";
    public static final String SSL_TXT_RC4_128_WITH_MD5 = "RC4-MD5";
    public static final String SSL_TXT_RC4_128_EXPORT40_WITH_MD5 = "EXP-RC4-MD5";
    public static final String SSL_TXT_RC2_128_CBC_WITH_MD5 = "RC2-CBC-MD5";
    public static final String SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5 = "EXP-RC2-CBC-MD5";
    public static final String SSL_TXT_IDEA_128_CBC_WITH_MD5 = "IDEA-CBC-MD5";
    public static final String SSL_TXT_DES_64_CBC_WITH_MD5 = "DES-CBC-MD5";
    public static final String SSL_TXT_DES_64_CBC_WITH_SHA = "DES-CBC-SHA";
    public static final String SSL_TXT_DES_192_EDE3_CBC_WITH_MD5 = "DES-CBC3-MD5";
    public static final String SSL_TXT_DES_192_EDE3_CBC_WITH_SHA = "DES-CBC3-SHA";
    public static final String SSL_TXT_KRB5_DES_64_CBC_SHA = "KRB5-DES-CBC-SHA";
    public static final String SSL_TXT_KRB5_DES_192_CBC3_SHA = "KRB5-DES-CBC3-SHA";
    public static final String SSL_TXT_KRB5_RC4_128_SHA = "KRB5-RC4-SHA";
    public static final String SSL_TXT_KRB5_IDEA_128_CBC_SHA = "KRB5-IDEA-CBC-SHA";
    public static final String SSL_TXT_KRB5_DES_64_CBC_MD5 = "KRB5-DES-CBC-MD5";
    public static final String SSL_TXT_KRB5_DES_192_CBC3_MD5 = "KRB5-DES-CBC3-MD5";
    public static final String SSL_TXT_KRB5_RC4_128_MD5 = "KRB5-RC4-MD5";
    public static final String SSL_TXT_KRB5_IDEA_128_CBC_MD5 = "KRB5-IDEA-CBC-MD5";
    public static final String SSL_TXT_KRB5_DES_40_CBC_SHA = "EXP-KRB5-DES-CBC-SHA";
    public static final String SSL_TXT_KRB5_RC2_40_CBC_SHA = "EXP-KRB5-RC2-CBC-SHA";
    public static final String SSL_TXT_KRB5_RC4_40_SHA = "EXP-KRB5-RC4-SHA";
    public static final String SSL_TXT_KRB5_DES_40_CBC_MD5 = "EXP-KRB5-DES-CBC-MD5";
    public static final String SSL_TXT_KRB5_RC2_40_CBC_MD5 = "EXP-KRB5-RC2-CBC-MD5";
    public static final String SSL_TXT_KRB5_RC4_40_MD5 = "EXP-KRB5-RC4-MD5";
    public static final String SSL_TXT_LOW = "LOW";
    public static final String SSL_TXT_MEDIUM = "MEDIUM";
    public static final String SSL_TXT_HIGH = "HIGH";
    public static final String SSL_TXT_kFZA = "kFZA";
    public static final String SSL_TXT_aFZA = "aFZA";
    public static final String SSL_TXT_eFZA = "eFZA";
    public static final String SSL_TXT_FZA = "FZA";
    public static final String SSL_TXT_aNULL = "aNULL";
    public static final String SSL_TXT_eNULL = "eNULL";
    public static final String SSL_TXT_NULL = "NULL";
    public static final String SSL_TXT_kKRB5 = "kKRB5";
    public static final String SSL_TXT_aKRB5 = "aKRB5";
    public static final String SSL_TXT_KRB5 = "KRB5";
    public static final String SSL_TXT_kRSA = "kRSA";
    public static final String SSL_TXT_kDHr = "kDHr";
    public static final String SSL_TXT_kDHd = "kDHd";
    public static final String SSL_TXT_kEDH = "kEDH";
    public static final String SSL_TXT_kDHE = "kDHE";
    public static final String SSL_TXT_kEECDH = "kEECDH";
    public static final String SSL_TXT_kECDHE = "kECDHE";
    public static final String SSL_TXT_aRSA = "aRSA";
    public static final String SSL_TXT_aDSS = "aDSS";
    public static final String SSL_TXT_aDH = "aDH";
    public static final String SSL_TXT_aECDSA = "aECDSA";
    public static final String SSL_TXT_DSS = "DSS";
    public static final String SSL_TXT_DH = "DH";
    public static final String SSL_TXT_DHE = "DHE";
    public static final String SSL_TXT_EDH = "EDH";
    public static final String SSL_TXT_ADH = "ADH";
    public static final String SSL_TXT_RSA = "RSA";
    public static final String SSL_TXT_ECDH = "ECDH";
    public static final String SSL_TXT_EECDH = "EECDH";
    public static final String SSL_TXT_ECDHE = "ECDHE";
    public static final String SSL_TXT_AECDH = "AECDH";
    public static final String SSL_TXT_ECDSA = "ECDSA";
    public static final String SSL_TXT_DES = "DES";
    public static final String SSL_TXT_3DES = "3DES";
    public static final String SSL_TXT_RC4 = "RC4";
    public static final String SSL_TXT_RC2 = "RC2";
    public static final String SSL_TXT_IDEA = "IDEA";
    public static final String SSL_TXT_SEED = "SEED";
    public static final String SSL_TXT_AES128 = "AES128";
    public static final String SSL_TXT_AES256 = "AES256";
    public static final String SSL_TXT_AES = "AES";
    public static final String SSL_TXT_AES_GCM = "AESGCM";
    public static final String SSL_TXT_AES_CCM = "AESCCM";
    public static final String SSL_TXT_AES_CCM_8 = "AESCCM8";
    public static final String SSL_TXT_CAMELLIA128 = "CAMELLIA128";
    public static final String SSL_TXT_CAMELLIA256 = "CAMELLIA256";
    public static final String SSL_TXT_CAMELLIA = "CAMELLIA";
    public static final String SSL_TXT_CHACHA20 = "CHACHA20";
    public static final String SSL_TXT_GOST = "GOST89";
    public static final String SSL_TXT_ARIA = "ARIA";
    public static final String SSL_TXT_ARIA_GCM = "ARIAGCM";
    public static final String SSL_TXT_ARIA128 = "ARIA128";
    public static final String SSL_TXT_ARIA256 = "ARIA256";
    public static final String SSL_TXT_MD5 = "MD5";
    public static final String SSL_TXT_SHA1 = "SHA1";
    public static final String SSL_TXT_SHA = "SHA";
    public static final String SSL_TXT_SHA256 = "SHA256";
    public static final String SSL_TXT_SHA384 = "SHA384";
    public static final String SSL_TXT_EXP = "EXP";
    public static final String SSL_TXT_EXPORT = "EXPORT";
    public static final String SSL_TXT_EXP40 = "EXPORT40";
    public static final String SSL_TXT_EXP56 = "EXPORT56";
    public static final String SSL_TXT_SSLV2 = "SSLv2";
    public static final String SSL_TXT_SSLV3 = "SSLv3";
    public static final String SSL_TXT_TLSV1 = "TLSv1";
    public static final String SSL_TXT_TLSV1_1 = "TLSv1.1";
    public static final String SSL_TXT_TLSV1_2 = "TLSv1.2";
    public static final String SSL_TXT_ALL = "ALL";
    public static final String SSL_TXT_ECC = "ECCdraft";
    public static final String SSL_TXT_CMPALL = "COMPLEMENTOFALL";
    public static final String SSL_TXT_CMPDEF = "COMPLEMENTOFDEFAULT";
    public static final String SSL_DEFAULT_CIPHER_LIST = "ALL:!EXPORT:!LOW:!aNULL:!eNULL:!SSLv2";
    public static final String TLS_DEFAULT_CIPHERSUITES = "TLS_AES_256_GCM_SHA384:TLS_CHACHA20_POLY1305_SHA256:TLS_AES_128_GCM_SHA256";
    public static final long SSL_MKEY_MASK = 255L;
    public static final long SSL_kRSA = 1L;
    public static final long SSL_kDHr = 2L;
    public static final long SSL_kDHd = 4L;
    public static final long SSL_kFZA = 8L;
    public static final long SSL_kDHE = 16L;
    public static final long SSL_kEDH = 16L;
    public static final long SSL_kKRB5 = 32L;
    public static final long SSL_kECDH = 64L;
    public static final long SSL_kECDHE = 128L;
    public static final long SSL_kEECDH = 128L;
    public static final long SSL_aNULL = 2048L;
    public static final long SSL_AUTH_MASK = 32512L;
    public static final long SSL_EDH = 30480L;
    public static final long SSL_aRSA = 256L;
    public static final long SSL_aDSS = 512L;
    public static final long SSL_DSS = 512L;
    public static final long SSL_aFZA = 1024L;
    public static final long SSL_aDH = 4096L;
    public static final long SSL_aKRB5 = 8192L;
    public static final long SSL_aECDSA = 16384L;
    public static final long SSL_eFZA = 0x100000L;
    public static final long SSL_ADH = 2064L;
    public static final long SSL_RSA = 257L;
    public static final long SSL_DH = 22L;
    public static final long SSL_ECDH = 192L;
    public static final long SSL_FZA = 1049608L;
    public static final long SSL_KRB5 = 8224L;
    public static final long SSL_ENC_MASK = 71270400L;
    public static final long SSL_DES = 1L;
    public static final long SSL_3DES = 2L;
    public static final long SSL_RC4 = 4L;
    public static final long SSL_RC2 = 8L;
    public static final long SSL_IDEA = 16L;
    public static final long SSL_eNULL = 32L;
    public static final long SSL_AES128 = 64L;
    public static final long SSL_AES256 = 128L;
    public static final long SSL_CAMELLIA128 = 256L;
    public static final long SSL_CAMELLIA256 = 512L;
    public static final long SSL_eGOST2814789CNT = 1024L;
    public static final long SSL_SEED = 2048L;
    public static final long SSL_AES128GCM = 4096L;
    public static final long SSL_AES256GCM = 8192L;
    public static final long SSL_AES128CCM = 16384L;
    public static final long SSL_AES256CCM = 32768L;
    public static final long SSL_AES128CCM8 = 65536L;
    public static final long SSL_AES256CCM8 = 131072L;
    public static final long SSL_eGOST2814789CNT12 = 262144L;
    public static final long SSL_CHACHA20POLY1305 = 524288L;
    public static final long SSL_ARIA128GCM = 0x100000L;
    public static final long SSL_ARIA256GCM = 0x200000L;
    public static final long SSL_AESGCM = 12288L;
    public static final long SSL_AESCCM = 245760L;
    public static final long SSL_AES = 258240L;
    public static final long SSL_CAMELLIA = 768L;
    public static final long SSL_CHACHA20 = 524288L;
    public static final long SSL_ARIAGCM = 0x300000L;
    public static final long SSL_ARIA = 0x300000L;
    public static final long SSL_MAC_MASK = 0xC00000L;
    public static final long SSL_MD5 = 0x400000L;
    public static final long SSL_SHA1 = 0x800000L;
    public static final long SSL_SHA = 0x800000L;
    public static final long SSL_SHA256 = 16L;
    public static final long SSL_SHA384 = 32L;
    @Deprecated
    public static final long SSL_SSL_MASK = 0x3000000L;
    public static final long SSL_SSLV2 = 0x1000000L;
    public static final long SSL_SSLV3 = 0x2000000L;
    public static final long SSL_TLSV1 = 0x2000000L;
    public static final long SSL_EXP_MASK = 3L;
    public static final long SSL_NOT_EXP = 1L;
    public static final long SSL_EXPORT = 2L;
    public static final long SSL_STRONG_MASK = 252L;
    public static final long SSL_STRONG_NONE = 4L;
    public static final long SSL_EXP40 = 8L;
    public static final long SSL_MICRO = 8L;
    public static final long SSL_EXP56 = 16L;
    public static final long SSL_MINI = 16L;
    public static final long SSL_LOW = 32L;
    public static final long SSL_MEDIUM = 64L;
    public static final long SSL_HIGH = 128L;
    public static final long SSL_FIPS = 256L;
    public static final long SSL_NOT_DEFAULT = 512L;
    @Deprecated
    public static final long SSL_ALL = 0xFFFFFFFFL;
    @Deprecated
    public static final long SSL_ALL_CIPHERS = 0x4FFFFFFL;
    @Deprecated
    public static final long SSL_ALL_STRENGTHS = 255L;
    public static final long SSL_PKEY_RSA_ENC = 0L;
    public static final long SSL_PKEY_RSA_SIGN = 1L;
    public static final long SSL_PKEY_DSA_SIGN = 2L;
    public static final long SSL_PKEY_DH_RSA = 3L;
    public static final long SSL_PKEY_DH_DSA = 4L;
    public static final long SSL_PKEY_ECC = 5L;
    public static final long SSL_PKEY_NUM = 6L;
    public static final long SSL3_CK_RSA_NULL_MD5 = 0x3000001L;
    public static final long SSL3_CK_RSA_NULL_SHA = 0x3000002L;
    public static final long SSL3_CK_RSA_RC4_40_MD5 = 0x3000003L;
    public static final long SSL3_CK_RSA_RC4_128_MD5 = 0x3000004L;
    public static final long SSL3_CK_RSA_RC4_128_SHA = 0x3000005L;
    public static final long SSL3_CK_RSA_RC2_40_MD5 = 0x3000006L;
    public static final long SSL3_CK_RSA_IDEA_128_SHA = 0x3000007L;
    public static final long SSL3_CK_RSA_DES_40_CBC_SHA = 0x3000008L;
    public static final long SSL3_CK_RSA_DES_64_CBC_SHA = 0x3000009L;
    public static final long SSL3_CK_RSA_DES_192_CBC3_SHA = 0x300000AL;
    public static final long SSL3_CK_DH_DSS_DES_40_CBC_SHA = 0x300000BL;
    public static final long SSL3_CK_DH_DSS_DES_64_CBC_SHA = 0x300000CL;
    public static final long SSL3_CK_DH_DSS_DES_192_CBC3_SHA = 0x300000DL;
    public static final long SSL3_CK_DH_RSA_DES_40_CBC_SHA = 0x300000EL;
    public static final long SSL3_CK_DH_RSA_DES_64_CBC_SHA = 0x300000FL;
    public static final long SSL3_CK_DH_RSA_DES_192_CBC3_SHA = 0x3000010L;
    public static final long SSL3_CK_EDH_DSS_DES_40_CBC_SHA = 0x3000011L;
    public static final long SSL3_CK_EDH_DSS_DES_64_CBC_SHA = 50331666L;
    public static final long SSL3_CK_EDH_DSS_DES_192_CBC3_SHA = 0x3000013L;
    public static final long SSL3_CK_EDH_RSA_DES_40_CBC_SHA = 50331668L;
    public static final long SSL3_CK_EDH_RSA_DES_64_CBC_SHA = 50331669L;
    public static final long SSL3_CK_EDH_RSA_DES_192_CBC3_SHA = 50331670L;
    public static final long SSL3_CK_ADH_RC4_40_MD5 = 50331671L;
    public static final long SSL3_CK_ADH_RC4_128_MD5 = 50331672L;
    public static final long SSL3_CK_ADH_DES_40_CBC_SHA = 50331673L;
    public static final long SSL3_CK_ADH_DES_64_CBC_SHA = 50331674L;
    public static final long SSL3_CK_ADH_DES_192_CBC_SHA = 50331675L;
    public static final long SSL3_CK_FZA_DMS_NULL_SHA = 50331676L;
    public static final long SSL3_CK_FZA_DMS_FZA_SHA = 50331677L;
    public static final long SSL3_CK_KRB5_DES_64_CBC_SHA = 50331678L;
    public static final long SSL3_CK_KRB5_DES_192_CBC3_SHA = 50331679L;
    public static final long SSL3_CK_KRB5_RC4_128_SHA = 0x3000020L;
    public static final long SSL3_CK_KRB5_IDEA_128_CBC_SHA = 50331681L;
    public static final long SSL3_CK_KRB5_DES_64_CBC_MD5 = 0x3000022L;
    public static final long SSL3_CK_KRB5_DES_192_CBC3_MD5 = 0x3000023L;
    public static final long SSL3_CK_KRB5_RC4_128_MD5 = 50331684L;
    public static final long SSL3_CK_KRB5_IDEA_128_CBC_MD5 = 50331685L;
    public static final long SSL3_CK_KRB5_DES_40_CBC_SHA = 50331686L;
    public static final long SSL3_CK_KRB5_RC2_40_CBC_SHA = 50331687L;
    public static final long SSL3_CK_KRB5_RC4_40_SHA = 50331688L;
    public static final long SSL3_CK_KRB5_DES_40_CBC_MD5 = 50331689L;
    public static final long SSL3_CK_KRB5_RC2_40_CBC_MD5 = 50331690L;
    public static final long SSL3_CK_KRB5_RC4_40_MD5 = 50331691L;
    public static final long TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_MD5 = 0x3000060L;
    public static final long TLS1_CK_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = 50331745L;
    public static final long TLS1_CK_RSA_EXPORT1024_WITH_DES_CBC_SHA = 50331746L;
    public static final long TLS1_CK_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 0x3000063L;
    public static final long TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_SHA = 50331748L;
    public static final long TLS1_CK_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 50331749L;
    public static final long TLS1_CK_DHE_DSS_WITH_RC4_128_SHA = 0x3000066L;
    public static final long TLS1_CK_RSA_WITH_AES_128_SHA = 50331695L;
    public static final long TLS1_CK_DH_DSS_WITH_AES_128_SHA = 0x3000030L;
    public static final long TLS1_CK_DH_RSA_WITH_AES_128_SHA = 0x3000031L;
    public static final long TLS1_CK_DHE_DSS_WITH_AES_128_SHA = 0x3000032L;
    public static final long TLS1_CK_DHE_RSA_WITH_AES_128_SHA = 0x3000033L;
    public static final long TLS1_CK_ADH_WITH_AES_128_SHA = 0x3000034L;
    public static final long TLS1_CK_RSA_WITH_AES_256_SHA = 0x3000035L;
    public static final long TLS1_CK_DH_DSS_WITH_AES_256_SHA = 0x3000036L;
    public static final long TLS1_CK_DH_RSA_WITH_AES_256_SHA = 0x3000037L;
    public static final long TLS1_CK_DHE_DSS_WITH_AES_256_SHA = 0x3000038L;
    public static final long TLS1_CK_DHE_RSA_WITH_AES_256_SHA = 0x3000039L;
    public static final long TLS1_CK_ADH_WITH_AES_256_SHA = 0x300003AL;
    public static final long TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA = 50380801L;
    public static final long TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA = 50380802L;
    public static final long TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = 0x300C003L;
    public static final long TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 50380804L;
    public static final long TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 50380805L;
    public static final long TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA = 50380806L;
    public static final long TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA = 50380807L;
    public static final long TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = 50380808L;
    public static final long TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 50380809L;
    public static final long TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 50380810L;
    public static final long TLS1_CK_ECDH_RSA_WITH_NULL_SHA = 50380811L;
    public static final long TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA = 0x300C00CL;
    public static final long TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA = 50380813L;
    public static final long TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 50380814L;
    public static final long TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 50380815L;
    public static final long TLS1_CK_ECDHE_RSA_WITH_NULL_SHA = 50380816L;
    public static final long TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA = 50380817L;
    public static final long TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA = 50380818L;
    public static final long TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 50380819L;
    public static final long TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 50380820L;
    public static final long TLS1_CK_ECDH_anon_WITH_NULL_SHA = 50380821L;
    public static final long TLS_ECDH_anon_WITH_RC4_128_SHA = 50380822L;
    public static final long TLS_ECDH_anon_WITH_DES_192_CBC3_SHA = 50380823L;
    public static final long TLS_ECDH_anon_WITH_AES_128_CBC_SHA = 50380824L;
    public static final long TLS_ECDH_anon_WITH_AES_256_CBC_SHA = 50380825L;
    public static final String TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5 = "EXP1024-RC4-MD5";
    public static final String TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = "EXP1024-RC2-CBC-MD5";
    public static final String TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA = "EXP1024-DES-CBC-SHA";
    public static final String TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = "EXP1024-DHE-DSS-DES-CBC-SHA";
    public static final String TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA = "EXP1024-RC4-SHA";
    public static final String TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = "EXP1024-DHE-DSS-RC4-SHA";
    public static final String TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA = "DHE-DSS-RC4-SHA";
    public static final String TLS1_TXT_RSA_WITH_AES_128_SHA = "AES128-SHA";
    public static final String TLS1_TXT_DH_DSS_WITH_AES_128_SHA = "DH-DSS-AES128-SHA";
    public static final String TLS1_TXT_DH_RSA_WITH_AES_128_SHA = "DH-RSA-AES128-SHA";
    public static final String TLS1_TXT_DHE_DSS_WITH_AES_128_SHA = "DHE-DSS-AES128-SHA";
    public static final String TLS1_TXT_DHE_RSA_WITH_AES_128_SHA = "DHE-RSA-AES128-SHA";
    public static final String TLS1_TXT_ADH_WITH_AES_128_SHA = "ADH-AES128-SHA";
    public static final String TLS1_TXT_RSA_WITH_AES_256_SHA = "AES256-SHA";
    public static final String TLS1_TXT_DH_DSS_WITH_AES_256_SHA = "DH-DSS-AES256-SHA";
    public static final String TLS1_TXT_DH_RSA_WITH_AES_256_SHA = "DH-RSA-AES256-SHA";
    public static final String TLS1_TXT_DHE_DSS_WITH_AES_256_SHA = "DHE-DSS-AES256-SHA";
    public static final String TLS1_TXT_DHE_RSA_WITH_AES_256_SHA = "DHE-RSA-AES256-SHA";
    public static final String TLS1_TXT_ADH_WITH_AES_256_SHA = "ADH-AES256-SHA";
    public static final String TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA = "ECDH-ECDSA-NULL-SHA";
    public static final String TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA = "ECDH-ECDSA-RC4-SHA";
    public static final String TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA = "ECDH-ECDSA-DES-CBC3-SHA";
    public static final String TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA = "ECDHE-ECDSA-NULL-SHA";
    public static final String TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA = "ECDHE-ECDSA-RC4-SHA";
    public static final String TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA = "ECDHE-ECDSA-DES-CBC3-SHA";
    public static final String TLS1_TXT_ECDH_RSA_WITH_NULL_SHA = "ECDH-RSA-NULL-SHA";
    public static final String TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA = "ECDH-RSA-RC4-SHA";
    public static final String TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA = "ECDH-RSA-DES-CBC3-SHA";
    public static final String TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA = "ECDHE-RSA-NULL-SHA";
    public static final String TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA = "ECDHE-RSA-RC4-SHA";
    public static final String TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA = "ECDHE-RSA-DES-CBC3-SHA";
    public static final String TLS1_TXT_ECDH_anon_WITH_NULL_SHA = "AECDH-NULL-SHA";
    private static final Map<String, Def> Definitions = new HashMap<String, Def>(48, 1.0f);
    private static final Map<String, Def> CipherNames;
    static final Map<String, String> SuiteToOSSL;

    static Collection<Def> matchingCiphers(String cipherString, String[] all, boolean setSuite) {
        LinkedList<Def> matchedList = new LinkedList<Def>();
        HashSet<Def> removed = null;
        int offset = 0;
        String[] parts = cipherString.split("[:, ]+");
        if (parts.length >= 1 && "DEFAULT".equals(parts[0])) {
            Collection<Def> matching = CipherStrings.matchingCiphers(SSL_DEFAULT_CIPHER_LIST, all, setSuite);
            matchedList.addAll(matching);
            ++offset;
        }
        block8: for (int i2 = offset; i2 < parts.length; ++i2) {
            String[] defs;
            Collection<Def> matching;
            String part = parts[i2];
            if (part.equals("@STRENGTH")) {
                Collections.sort(matchedList);
                continue;
            }
            int index = 0;
            if (part.length() > 0) {
                switch (part.charAt(0)) {
                    case '!': 
                    case '+': 
                    case '-': {
                        ++index;
                    }
                }
            }
            if ((matching = (defs = part.substring(index).split("[+]")).length == 1 ? CipherStrings.matchingExact(defs[0], all, setSuite) : CipherStrings.matching(defs, all, setSuite)) == null) continue;
            if (index > 0) {
                switch (part.charAt(0)) {
                    case '!': {
                        matchedList.removeAll(matching);
                        if (removed == null) {
                            removed = new HashSet<Def>();
                        }
                        removed.addAll(matching);
                        break;
                    }
                    case '+': {
                        for (Def def : matching) {
                            if (removed != null && removed.contains(def) || !matchedList.remove(def)) continue;
                            matchedList.add(def);
                        }
                        continue block8;
                    }
                    case '-': {
                        matchedList.removeAll(matching);
                    }
                }
                continue;
            }
            for (Def def : matching) {
                if (removed != null && removed.contains(def) || matchedList.contains(def)) continue;
                matchedList.add(def);
            }
        }
        return matchedList;
    }

    private static Collection<Def> matchingExact(String name2, String[] all, boolean setSuite) {
        Def pattern = Definitions.get(name2);
        if (pattern != null) {
            return CipherStrings.matchingPattern(pattern, all, true, setSuite);
        }
        Def def = CipherNames.get(name2);
        if (def != null) {
            if (setSuite) {
                for (String entry : all) {
                    if (!name2.equals(SuiteToOSSL.get(entry))) continue;
                    return Collections.singleton(def.setCipherSuite(entry));
                }
            } else {
                return Collections.singleton(def);
            }
        }
        return null;
    }

    private static Collection<Def> matching(String[] defs, String[] all, boolean setSuite) {
        Collection<Def> matching = null;
        for (String name2 : defs) {
            Def pattern = Definitions.get(name2);
            if (pattern == null) continue;
            if (matching == null) {
                matching = CipherStrings.matchingPattern(pattern, all, true, setSuite);
                continue;
            }
            matching.retainAll(CipherStrings.matchingPattern(pattern, all, false, setSuite));
        }
        return matching;
    }

    private static Collection<Def> matchingPattern(Def pattern, String[] all, boolean useSet, boolean setSuite) {
        AbstractCollection matching = useSet ? new LinkedHashSet() : new ArrayList(all.length);
        for (String entry : all) {
            Def def;
            String ossl = SuiteToOSSL.get(entry);
            if (ossl == null || (def = CipherNames.get(ossl)) == null || !pattern.matches(def)) continue;
            if (setSuite) {
                matching.add((Def)def.setCipherSuite(entry));
                continue;
            }
            matching.add((Def)def);
        }
        return matching;
    }

    static {
        Definitions.put(SSL_TXT_ALL, new Def(0, SSL_TXT_ALL, 0L, 0xFFFFFFDFL, 0xFFFFFFFFL, 0L, 0, 0, 0xFFFFFFFFL, 0xFFFFFFFFL));
        Definitions.put(SSL_TXT_CMPALL, new Def(0, SSL_TXT_CMPALL, 0L, 32L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_CMPDEF, new Def(0, SSL_TXT_CMPDEF, 0L, 2064L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_kKRB5, new Def(0, SSL_TXT_kKRB5, 0L, 32L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_kRSA, new Def(0, SSL_TXT_kRSA, 0L, 1L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_kDHr, new Def(0, SSL_TXT_kDHr, 0L, 2L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_kDHd, new Def(0, SSL_TXT_kDHd, 0L, 4L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_kEDH, new Def(0, SSL_TXT_kEDH, 0L, 16L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_kFZA, new Def(0, SSL_TXT_kFZA, 0L, 8L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_DH, new Def(0, SSL_TXT_DH, 0L, 22L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_ECC, new Def(0, SSL_TXT_ECC, 0L, 192L, 0L, 0L, 0, 0, 255L, 0L));
        Definitions.put(SSL_TXT_EDH, new Def(0, SSL_TXT_EDH, 0L, 30480L, 0L, 0L, 0, 0, 32767L, 0L));
        Definitions.put(SSL_TXT_aKRB5, new Def(0, SSL_TXT_aKRB5, 0L, 8192L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_aRSA, new Def(0, SSL_TXT_aRSA, 0L, 256L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_aDSS, new Def(0, SSL_TXT_aDSS, 0L, 512L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_aFZA, new Def(0, SSL_TXT_aFZA, 0L, 1024L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_aNULL, new Def(0, SSL_TXT_aNULL, 0L, 2048L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_aDH, new Def(0, SSL_TXT_aDH, 0L, 4096L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_DSS, new Def(0, SSL_TXT_DSS, 0L, 512L, 0L, 0L, 0, 0, 32512L, 0L));
        Definitions.put(SSL_TXT_DES, new Def(0, SSL_TXT_DES, 0L, 1L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_3DES, new Def(0, SSL_TXT_3DES, 0L, 2L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_RC4, new Def(0, SSL_TXT_RC4, 0L, 4L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_RC2, new Def(0, SSL_TXT_RC2, 0L, 8L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_IDEA, new Def(0, SSL_TXT_IDEA, 0L, 16L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_eNULL, new Def(0, SSL_TXT_eNULL, 0L, 32L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_eFZA, new Def(0, SSL_TXT_eFZA, 0L, 0x100000L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_AES, new Def(0, SSL_TXT_AES, 0L, 258240L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_MD5, new Def(0, SSL_TXT_MD5, 0L, 0x400000L, 0L, 0L, 0, 0, 0xC00000L, 0L));
        Definitions.put(SSL_TXT_SHA1, new Def(0, SSL_TXT_SHA1, 0L, 0x800000L, 0L, 0L, 0, 0, 0xC00000L, 0L));
        Definitions.put(SSL_TXT_SHA, new Def(0, SSL_TXT_SHA, 0L, 0x800000L, 0L, 0L, 0, 0, 0xC00000L, 0L));
        Definitions.put("NULL", new Def(0, "NULL", 0L, 32L, 0L, 0L, 0, 0, 71270400L, 0L));
        Definitions.put(SSL_TXT_KRB5, new Def(0, SSL_TXT_KRB5, 0L, 8224L, 0L, 0L, 0, 0, 32767L, 0L));
        Definitions.put(SSL_TXT_RSA, new Def(0, SSL_TXT_RSA, 0L, 257L, 0L, 0L, 0, 0, 32767L, 0L));
        Definitions.put(SSL_TXT_ADH, new Def(0, SSL_TXT_ADH, 0L, 2064L, 0L, 0L, 0, 0, 32767L, 0L));
        Definitions.put(SSL_TXT_FZA, new Def(0, SSL_TXT_FZA, 0L, 1049608L, 0L, 0L, 0, 0, 0x43FFFFFL, 0L));
        Definitions.put(SSL_TXT_SSLV2, new Def(0, SSL_TXT_SSLV2, 0L, 0x1000000L, 0L, 0L, 0, 0, 0x3000000L, 0L));
        Definitions.put(SSL_TXT_SSLV3, new Def(0, SSL_TXT_SSLV3, 0L, 0x2000000L, 0L, 0L, 0, 0, 0x3000000L, 0L));
        Definitions.put(SSL_TXT_TLSV1, new Def(0, SSL_TXT_TLSV1, 0L, 0x2000000L, 0L, 0L, 0, 0, 0x3000000L, 0L));
        Definitions.put(SSL_TXT_EXP, new Def(0, SSL_TXT_EXP, 0L, 0L, 2L, 0L, 0, 0, 0L, 3L));
        Definitions.put(SSL_TXT_EXPORT, new Def(0, SSL_TXT_EXPORT, 0L, 0L, 2L, 0L, 0, 0, 0L, 3L));
        Definitions.put(SSL_TXT_EXP40, new Def(0, SSL_TXT_EXP40, 0L, 0L, 8L, 0L, 0, 0, 0L, 252L));
        Definitions.put(SSL_TXT_EXP56, new Def(0, SSL_TXT_EXP56, 0L, 0L, 16L, 0L, 0, 0, 0L, 252L));
        Definitions.put(SSL_TXT_LOW, new Def(0, SSL_TXT_LOW, 0L, 0L, 32L, 0L, 0, 0, 0L, 252L));
        Definitions.put(SSL_TXT_MEDIUM, new Def(0, SSL_TXT_MEDIUM, 0L, 0L, 64L, 0L, 0, 0, 0L, 252L));
        Definitions.put(SSL_TXT_HIGH, new Def(0, SSL_TXT_HIGH, 0L, 0L, 128L, 0L, 0, 0, 0L, 252L));
        ArrayList<Def> Ciphers = new ArrayList<Def>(96);
        Ciphers.add(new Def(1, "NULL-MD5", 0x3000001L, 37749025L, 5L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_RSA_NULL_SHA, 0x3000002L, 41943329L, 5L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-RC4-MD5", 0x3000003L, 37748997L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "RC4-MD5", 0x3000004L, 37748997L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_RSA_RC4_128_SHA, 0x3000005L, 41943301L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-RC2-CBC-MD5", 0x3000006L, 37749001L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_RSA_IDEA_128_SHA, 0x3000007L, 41943313L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_RSA_DES_40_CBC_SHA, 0x3000008L, 41943297L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "DES-CBC-SHA", 0x3000009L, 41943297L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "DES-CBC3-SHA", 0x300000AL, 41943299L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_DSS_DES_40_CBC_SHA, 0x300000BL, 41947141L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_DSS_DES_64_CBC_SHA, 0x300000CL, 41947141L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_DSS_DES_192_CBC3_SHA, 0x300000DL, 41947142L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_RSA_DES_40_CBC_SHA, 0x300000EL, 41947139L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_RSA_DES_64_CBC_SHA, 0x300000FL, 41947139L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_DH_RSA_DES_192_CBC3_SHA, 0x3000010L, 41947138L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_DSS_DES_40_CBC_SHA, 0x3000011L, 41943569L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_DSS_DES_64_CBC_SHA, 50331666L, 41943569L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA, 0x3000013L, 41943570L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_RSA_DES_40_CBC_SHA, 50331668L, 41943313L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_RSA_DES_64_CBC_SHA, 50331669L, 41943313L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA, 50331670L, 41943314L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_ADH_RC4_40_MD5, 50331671L, 37750804L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_ADH_RC4_128_MD5, 50331672L, 37750804L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_ADH_DES_40_CBC_SHA, 50331673L, 41945105L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_ADH_DES_64_CBC_SHA, 50331674L, 41945105L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, SSL3_TXT_ADH_DES_192_CBC_SHA, 50331675L, 41945106L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_FZA_DMS_NULL_SHA, 50331676L, 41944104L, 5L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, SSL3_TXT_FZA_DMS_FZA_SHA, 50331677L, 42992648L, 5L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-DES-CBC-SHA", 50331678L, 41951265L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-DES-CBC3-SHA", 50331679L, 0x2802022L, 129L, 0L, 112, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-RC4-SHA", 0x3000020L, 41951268L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-IDEA-CBC-SHA", 50331681L, 41951280L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-DES-CBC-MD5", 0x3000022L, 37756961L, 33L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-DES-CBC3-MD5", 0x3000023L, 0x2402022L, 129L, 0L, 112, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-RC4-MD5", 50331684L, 0x2402024L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "KRB5-IDEA-CBC-MD5", 50331685L, 37756976L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-DES-CBC-SHA", 50331686L, 41951265L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-RC2-CBC-SHA", 50331687L, 0x2802028L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-RC4-SHA", 50331688L, 41951268L, 10L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-DES-CBC-MD5", 50331689L, 37756961L, 10L, 0L, 40, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-RC2-CBC-MD5", 50331690L, 37756968L, 10L, 0L, 40, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, "EXP-KRB5-RC4-MD5", 50331691L, 0x2402024L, 10L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_WITH_AES_128_SHA, 50331695L, 42201537L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, TLS1_TXT_DH_DSS_WITH_AES_128_SHA, 0x3000030L, 42201284L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, TLS1_TXT_DH_RSA_WITH_AES_128_SHA, 0x3000031L, 42201282L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_DSS_WITH_AES_128_SHA, 0x3000032L, 42201808L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_RSA_WITH_AES_128_SHA, 0x3000033L, 42201552L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ADH_WITH_AES_128_SHA, 0x3000034L, 42203344L, 129L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_WITH_AES_256_SHA, 0x3000035L, 42201537L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, TLS1_TXT_DH_DSS_WITH_AES_256_SHA, 0x3000036L, 42201284L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(0, TLS1_TXT_DH_RSA_WITH_AES_256_SHA, 0x3000037L, 42201282L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_DSS_WITH_AES_256_SHA, 0x3000038L, 42201808L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_RSA_WITH_AES_256_SHA, 0x3000039L, 42201552L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ADH_WITH_AES_256_SHA, 0x300003AL, 42203344L, 129L, 0L, 256, 256, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5, 0x3000060L, 37748997L, 18L, 0L, 56, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5, 50331745L, 37749001L, 18L, 0L, 56, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA, 50331746L, 41943297L, 18L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA, 0x3000063L, 41943569L, 18L, 0L, 56, 56, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA, 50331748L, 41943301L, 18L, 0L, 56, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA, 50331749L, 41943572L, 18L, 0L, 56, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA, 0x3000066L, 41943572L, 65L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA, 50380801L, 41959520L, 1L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA, 50380802L, 41959492L, 1L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA, 0x300C003L, 41959490L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA, 50380806L, 41959584L, 1L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA, 50380807L, 41959556L, 1L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA, 50380808L, 41959554L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_RSA_WITH_NULL_SHA, 50380811L, 41943392L, 1L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA, 0x300C00CL, 41943364L, 1L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA, 50380813L, 41943362L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA, 50380816L, 41943456L, 1L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA, 50380817L, 41943428L, 1L, 0L, 128, 128, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA, 50380818L, 41943426L, 129L, 0L, 168, 168, 0x4FFFFFFL, 255L));
        Ciphers.add(new Def(1, TLS1_TXT_ECDH_anon_WITH_NULL_SHA, 50380821L, 41945248L, 1L, 0L, 0, 0, 0x4FFFFFFL, 255L));
        CipherNames = new HashMap<String, Def>(Ciphers.size() + 64, 1.0f);
        SuiteToOSSL = new HashMap<String, String>(120, 1.0f);
        SuiteToOSSL.put("SSL_RSA_WITH_NULL_MD5", "NULL-MD5");
        SuiteToOSSL.put("SSL_RSA_WITH_NULL_SHA", SSL3_TXT_RSA_NULL_SHA);
        SuiteToOSSL.put("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5");
        SuiteToOSSL.put("SSL_RSA_WITH_RC4_128_MD5", "RC4-MD5");
        SuiteToOSSL.put("SSL_RSA_WITH_RC4_128_SHA", SSL3_TXT_RSA_RC4_128_SHA);
        SuiteToOSSL.put("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "EXP-RC2-CBC-MD5");
        SuiteToOSSL.put("SSL_RSA_WITH_IDEA_CBC_SHA", SSL3_TXT_RSA_IDEA_128_SHA);
        SuiteToOSSL.put("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_RSA_DES_40_CBC_SHA);
        SuiteToOSSL.put("SSL_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA");
        SuiteToOSSL.put("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA");
        SuiteToOSSL.put("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_EDH_DSS_DES_40_CBC_SHA);
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-CBC-SHA");
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA);
        SuiteToOSSL.put("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_EDH_RSA_DES_40_CBC_SHA);
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_DES_CBC_SHA", SSL3_TXT_EDH_RSA_DES_64_CBC_SHA);
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA);
        SuiteToOSSL.put("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", SSL3_TXT_ADH_RC4_40_MD5);
        SuiteToOSSL.put("SSL_DH_anon_WITH_RC4_128_MD5", SSL3_TXT_ADH_RC4_128_MD5);
        SuiteToOSSL.put("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_ADH_DES_40_CBC_SHA);
        SuiteToOSSL.put("SSL_DH_anon_WITH_DES_CBC_SHA", SSL3_TXT_ADH_DES_64_CBC_SHA);
        SuiteToOSSL.put("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_ADH_DES_192_CBC_SHA);
        SuiteToOSSL.put("TLS_RSA_WITH_NULL_MD5", "NULL-MD5");
        SuiteToOSSL.put("TLS_RSA_WITH_NULL_SHA", SSL3_TXT_RSA_NULL_SHA);
        SuiteToOSSL.put("TLS_RSA_WITH_NULL_SHA256", "NULL-SHA256");
        SuiteToOSSL.put("TLS_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5");
        SuiteToOSSL.put("TLS_RSA_WITH_RC4_128_MD5", "RC4-MD5");
        SuiteToOSSL.put("TLS_RSA_WITH_RC4_128_SHA", SSL3_TXT_RSA_RC4_128_SHA);
        SuiteToOSSL.put("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "EXP-RC2-CBC-MD5");
        SuiteToOSSL.put("TLS_RSA_WITH_IDEA_CBC_SHA", SSL3_TXT_RSA_IDEA_128_SHA);
        SuiteToOSSL.put("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_RSA_DES_40_CBC_SHA);
        SuiteToOSSL.put("TLS_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA");
        SuiteToOSSL.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA");
        SuiteToOSSL.put("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_EDH_DSS_DES_40_CBC_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-CBC-SHA");
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_EDH_DSS_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_EDH_RSA_DES_40_CBC_SHA);
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_DES_CBC_SHA", SSL3_TXT_EDH_RSA_DES_64_CBC_SHA);
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_EDH_RSA_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", SSL3_TXT_ADH_RC4_40_MD5);
        SuiteToOSSL.put("TLS_DH_anon_WITH_RC4_128_MD5", SSL3_TXT_ADH_RC4_128_MD5);
        SuiteToOSSL.put("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", SSL3_TXT_ADH_DES_40_CBC_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_DES_CBC_SHA", SSL3_TXT_ADH_DES_64_CBC_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", SSL3_TXT_ADH_DES_192_CBC_SHA);
        SuiteToOSSL.put("TLS_RSA_WITH_AES_128_CBC_SHA", TLS1_TXT_RSA_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_RSA_WITH_AES_256_CBC_SHA", TLS1_TXT_RSA_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DH_DSS_WITH_AES_128_CBC_SHA", TLS1_TXT_DH_DSS_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_DH_DSS_WITH_AES_256_CBC_SHA", TLS1_TXT_DH_DSS_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DH_RSA_WITH_AES_128_CBC_SHA", TLS1_TXT_DH_RSA_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_DH_RSA_WITH_AES_256_CBC_SHA", TLS1_TXT_DH_RSA_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", TLS1_TXT_DHE_DSS_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", TLS1_TXT_DHE_DSS_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", TLS1_TXT_DHE_RSA_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", TLS1_TXT_DHE_RSA_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_128_CBC_SHA", TLS1_TXT_ADH_WITH_AES_128_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_256_CBC_SHA", TLS1_TXT_ADH_WITH_AES_256_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_128_CBC_SHA256", "ADH-AES128-SHA256");
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_256_CBC_SHA256", "ADH-AES256-SHA256");
        SuiteToOSSL.put("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA", TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA);
        SuiteToOSSL.put("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA", TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA);
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_RC4_128_SHA", TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA);
        SuiteToOSSL.put("SSL_CK_RC4_128_WITH_MD5", "RC4-MD5");
        SuiteToOSSL.put("SSL_CK_RC4_128_EXPORT40_WITH_MD5", "EXP-RC4-MD5");
        SuiteToOSSL.put("SSL_CK_RC2_128_CBC_WITH_MD5", "RC2-MD5");
        SuiteToOSSL.put("SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5", "EXP-RC2-MD5");
        SuiteToOSSL.put("SSL_CK_IDEA_128_CBC_WITH_MD5", "IDEA-CBC-MD5");
        SuiteToOSSL.put("SSL_CK_DES_64_CBC_WITH_MD5", "DES-CBC-MD5");
        SuiteToOSSL.put("SSL_CK_DES_192_EDE3_CBC_WITH_MD5", "DES-CBC3-MD5");
        String name2 = "ECDHE-ECDSA-AES128-SHA";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES128-SHA");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-ECDSA-AES256-SHA";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES256-SHA");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-ECDSA-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-ECDSA-AES128-SHA256";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-ECDSA-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-ECDSA-AES256-SHA384";
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES256-SHA384");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES128-SHA";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES128-SHA");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES256-SHA";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES256-SHA");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201537L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES128-SHA256";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDHE-RSA-AES256-SHA384";
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES256-SHA384");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES128-SHA";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "ECDH-ECDSA-AES128-SHA");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES256-SHA";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "ECDH-ECDSA-AES256-SHA");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "ECDH-ECDSA-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES128-SHA256";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "ECDH-ECDSA-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "ECDH-ECDSA-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDH-ECDSA-AES256-SHA384";
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "ECDH-ECDSA-AES256-SHA384");
        CipherNames.put(name2, new Def(name2, 42201280L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES128-SHA";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "ECDH-RSA-AES128-SHA");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES256-SHA";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "ECDH-RSA-AES256-SHA");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "ECDH-RSA-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES128-SHA256";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "ECDH-RSA-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "ECDH-RSA-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "ECDH-RSA-AES256-SHA384";
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "ECDH-RSA-AES256-SHA384");
        CipherNames.put(name2, new Def(name2, 42201536L, 129L, 256, 384, 0x4FFFFFFL, 255L));
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA);
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA);
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_RC4_128_SHA", TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA);
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA);
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_RC4_128_SHA", TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA);
        name2 = "AECDH-AES128-SHA";
        SuiteToOSSL.put("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "AECDH-AES128-SHA");
        CipherNames.put(name2, new Def(name2, 42203328L, 129L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "AECDH-AES256-SHA";
        SuiteToOSSL.put("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "AECDH-AES256-SHA");
        CipherNames.put(name2, new Def(name2, 42203328L, 129L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "AECDH-DES-CBC3-SHA";
        SuiteToOSSL.put("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "AECDH-DES-CBC3-SHA");
        CipherNames.put(name2, new Def(name2, 0x2800882L, 129L, 168, 168, 0x4FFFFFFL, 255L));
        name2 = "AECDH-RC4-SHA";
        SuiteToOSSL.put("TLS_ECDH_anon_WITH_RC4_128_SHA", "AECDH-RC4-SHA");
        CipherNames.put(name2, new Def(name2, 41945220L, 1L, 128, 128, 0x4FFFFFFL, 255L));
        name2 = "DHE-RSA-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "DHE-RSA-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201552L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-RSA-AES128-SHA256";
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "DHE-RSA-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201552L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-RSA-AES256-SHA256";
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "DHE-RSA-AES256-SHA256");
        CipherNames.put(name2, new Def(name2, 42201552L, 1L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-RSA-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "DHE-RSA-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201552L, 1L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "DHE-DSS-AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "DHE-DSS-AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201808L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-DSS-AES128-SHA256";
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "DHE-DSS-AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201808L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-DSS-AES256-SHA256";
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "DHE-DSS-AES256-SHA256");
        CipherNames.put(name2, new Def(name2, 42201808L, 1L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "DHE-DSS-AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "DHE-DSS-AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201808L, 1L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "AES128-GCM-SHA256";
        SuiteToOSSL.put("TLS_RSA_WITH_AES_128_GCM_SHA256", "AES128-GCM-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "AES128-SHA256";
        SuiteToOSSL.put("TLS_RSA_WITH_AES_128_CBC_SHA256", "AES128-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "AES256-SHA256";
        SuiteToOSSL.put("TLS_RSA_WITH_AES_256_CBC_SHA256", "AES256-SHA256");
        CipherNames.put(name2, new Def(name2, 42201536L, 1L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "AES256-GCM-SHA384";
        SuiteToOSSL.put("TLS_RSA_WITH_AES_256_GCM_SHA384", "AES256-GCM-SHA384");
        CipherNames.put(name2, new Def(name2, 42201536L, 1L, 256, 384, 0x4FFFFFFL, 255L));
        SuiteToOSSL.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA);
        SuiteToOSSL.put("TLS_ECDHE_RSA_WITH_NULL_SHA", TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA);
        SuiteToOSSL.put("TLS_ECDH_ECDSA_WITH_NULL_SHA", TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA);
        SuiteToOSSL.put("TLS_ECDH_RSA_WITH_NULL_SHA", TLS1_TXT_ECDH_RSA_WITH_NULL_SHA);
        SuiteToOSSL.put("TLS_ECDH_anon_WITH_NULL_SHA", TLS1_TXT_ECDH_anon_WITH_NULL_SHA);
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_128_GCM_SHA256", "ADH-AES128-GCM-SHA256");
        SuiteToOSSL.put("TLS_DH_anon_WITH_AES_256_GCM_SHA384", "ADH-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_128_CBC_SHA", TLS1_TXT_ADH_WITH_AES_128_SHA);
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_128_CBC_SHA256", "ADH-AES128-SHA256");
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_128_GCM_SHA256", "ADH-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_256_CBC_SHA", TLS1_TXT_ADH_WITH_AES_256_SHA);
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_256_CBC_SHA256", "ADH-AES256-SHA256");
        SuiteToOSSL.put("SSL_DH_anon_WITH_AES_256_GCM_SHA384", "ADH-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_128_CBC_SHA", TLS1_TXT_DHE_DSS_WITH_AES_128_SHA);
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_128_CBC_SHA256", "DHE-DSS-AES128-SHA256");
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_128_GCM_SHA256", "DHE-DSS-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_256_CBC_SHA", TLS1_TXT_DHE_DSS_WITH_AES_256_SHA);
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_256_CBC_SHA256", "DHE-DSS-AES256-SHA256");
        SuiteToOSSL.put("SSL_DHE_DSS_WITH_AES_256_GCM_SHA384", "DHE-DSS-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_128_CBC_SHA", TLS1_TXT_DHE_RSA_WITH_AES_128_SHA);
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", "DHE-RSA-AES128-SHA256");
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_128_GCM_SHA256", "DHE-RSA-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_256_CBC_SHA", TLS1_TXT_DHE_RSA_WITH_AES_256_SHA);
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", "DHE-RSA-AES256-SHA256");
        SuiteToOSSL.put("SSL_DHE_RSA_WITH_AES_256_GCM_SHA384", "DHE-RSA-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_ECDH_anon_WITH_AES_128_CBC_SHA", "AECDH-AES128-SHA");
        SuiteToOSSL.put("SSL_ECDH_anon_WITH_AES_256_CBC_SHA", "AECDH-AES256-SHA");
        SuiteToOSSL.put("SSL_ECDH_anon_WITH_NULL_SHA", TLS1_TXT_ECDH_anon_WITH_NULL_SHA);
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "ECDH-ECDSA-AES128-SHA");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "ECDH-ECDSA-AES128-SHA256");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "ECDH-ECDSA-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "ECDH-ECDSA-AES256-SHA");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "ECDH-ECDSA-AES256-SHA384");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "ECDH-ECDSA-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_ECDH_ECDSA_WITH_NULL_SHA", TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA);
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_128_CBC_SHA", "ECDH-RSA-AES128-SHA");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_128_CBC_SHA256", "ECDH-RSA-AES128-SHA256");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_128_GCM_SHA256", "ECDH-RSA-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_256_CBC_SHA", "ECDH-RSA-AES256-SHA");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_256_CBC_SHA384", "ECDH-RSA-AES256-SHA384");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_AES_256_GCM_SHA384", "ECDH-RSA-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_ECDH_RSA_WITH_NULL_SHA", TLS1_TXT_ECDH_RSA_WITH_NULL_SHA);
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES128-SHA");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES128-SHA256");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES256-SHA");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES256-SHA384");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_ECDHE_ECDSA_WITH_NULL_SHA", TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA);
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES128-SHA");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES128-SHA256");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES256-SHA");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES128-SHA384");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_ECDHE_RSA_WITH_NULL_SHA", TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA);
        SuiteToOSSL.put("SSL_RSA_WITH_AES_128_CBC_SHA", TLS1_TXT_RSA_WITH_AES_128_SHA);
        SuiteToOSSL.put("SSL_RSA_WITH_AES_128_CBC_SHA256", "AES128-SHA256");
        SuiteToOSSL.put("SSL_RSA_WITH_AES_128_GCM_SHA256", "AES128-GCM-SHA256");
        SuiteToOSSL.put("SSL_RSA_WITH_AES_256_CBC_SHA", TLS1_TXT_RSA_WITH_AES_256_SHA);
        SuiteToOSSL.put("SSL_RSA_WITH_AES_256_CBC_SHA256", "AES256-SHA256");
        SuiteToOSSL.put("SSL_RSA_WITH_AES_256_GCM_SHA384", "AES256-GCM-SHA384");
        SuiteToOSSL.put("SSL_RSA_WITH_NULL_SHA256", "NULL-SHA256");
        name2 = "TLS_AES_128_GCM_SHA256";
        SuiteToOSSL.put("TLS_AES_128_GCM_SHA256", "TLS_AES_128_GCM_SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "TLS_AES_256_GCM_SHA384";
        SuiteToOSSL.put("TLS_AES_256_GCM_SHA384", "TLS_AES_256_GCM_SHA384");
        CipherNames.put(name2, new Def(name2, 42201280L, 1L, 256, 384, 0x4FFFFFFL, 255L));
        name2 = "TLS_CHACHA20_POLY1305_SHA256";
        SuiteToOSSL.put("TLS_CHACHA20_POLY1305_SHA256", "TLS_CHACHA20_POLY1305_SHA256");
        CipherNames.put(name2, new Def(name2, 0x2880000L, 1L, 256, 256, 0x4FFFFFFL, 255L));
        name2 = "TLS_AES_128_CCM_SHA256";
        SuiteToOSSL.put("TLS_AES_128_CCM_SHA256", "TLS_AES_128_CCM_SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 1L, 128, 256, 0x4FFFFFFL, 255L));
        name2 = "TLS_AES_128_CCM_8_SHA256";
        SuiteToOSSL.put("TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_8_SHA256");
        CipherNames.put(name2, new Def(name2, 42201280L, 1L, 256, 384, 0x4FFFFFFL, 255L));
        for (Def def : Ciphers) {
            CipherNames.put(def.name, def);
        }
    }

    static final class Def
    implements Comparable<Def>,
    Cloneable {
        final boolean valid;
        final String name;
        private final long id;
        final long algorithms;
        private final long algStrength;
        final int algStrengthBits;
        final int algBits;
        private final long mask;
        private final long algStrengthMask;
        private long algorithm_mkey;
        private long algorithm_auth;
        private long algorithm_enc;
        private long algorithm_mac;
        private int min_tls;
        private int max_tls;
        private volatile String cipherSuite;

        Def(int valid, String name2, long id2, long algorithms, long algo_strength, long algorithm2, int strength_bits, int alg_bits, long mask, long maskStrength) {
            this.valid = valid != 0;
            this.name = name2;
            this.id = id2;
            this.algorithms = algorithms;
            this.algStrength = algo_strength;
            this.algStrengthBits = strength_bits;
            this.algBits = alg_bits;
            this.mask = mask;
            this.algStrengthMask = maskStrength;
        }

        Def(String name2, long algorithms, long algo_strength, int strength_bits, int alg_bits, long mask, long maskStrength) {
            this.valid = true;
            this.name = name2;
            this.id = 0L;
            this.algorithms = algorithms;
            this.algStrength = algo_strength;
            this.algStrengthBits = strength_bits;
            this.algBits = alg_bits;
            this.mask = mask;
            this.algStrengthMask = maskStrength;
        }

        Def(int valid, String name2, String stdname, long id2, long algorithm_mkey, long algorithm_auth, long algorithm_enc, long algorithm_mac, int min_tls, int max_tls) {
            this.valid = valid != 0;
            this.name = name2;
            this.id = id2;
            this.algorithm_mkey = algorithm_mkey;
            this.algorithm_auth = algorithm_auth;
            this.algorithm_enc = algorithm_enc;
            this.algorithm_mac = algorithm_mac;
            this.min_tls = min_tls;
            this.max_tls = max_tls;
            this.algorithms = algorithm_mkey;
            this.algStrength = 0L;
            this.algStrengthBits = 0;
            this.algBits = 0;
            this.mask = 0L;
            this.algStrengthMask = 0L;
        }

        public String getCipherSuite() {
            return this.cipherSuite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Def setCipherSuite(String suite) {
            String cipherSuite = this.cipherSuite;
            if (cipherSuite == null) {
                Def def = this;
                synchronized (def) {
                    if (this.cipherSuite == null) {
                        this.cipherSuite = suite;
                        return this;
                    }
                }
                cipherSuite = suite;
            }
            if (suite.equals(cipherSuite)) {
                return this;
            }
            try {
                Def clone = (Def)super.clone();
                clone.cipherSuite = suite;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Def) {
                return this.name.equals(((Def)other).name);
            }
            return false;
        }

        @Override
        public int compareTo(Def that) {
            return this.algStrengthBits - that.algStrengthBits;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '<' + this.name + '>';
        }

        public boolean matches(Def current) {
            long ma = this.mask & current.algorithms;
            long ma_s = this.algStrengthMask & current.algStrength;
            return (ma != 0L || ma_s != 0L) && (ma & this.algorithms) == ma && (ma_s & this.algStrength) == ma_s;
        }
    }
}

