/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class SetRoleNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    SetRoleNode(String roleName, int type, ContextManager cm) throws StandardException {
        super(cm);
        this.name = roleName;
        this.type = type;
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.type == 1 ? "roleName: ?\n" : "rolename: " + this.name + "\n");
    }

    @Override
    public String statementToString() {
        return "SET ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetRoleConstantAction(this.name, this.type);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.type == 1) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getMiscResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    private void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        List<ParameterNode> parameterList = this.getCompilerContext().getParameterList();
        SanityManager.ASSERT((parameterList != null && parameterList.size() == 1 ? 1 : 0) != 0);
        ParameterNode.generateParameterValueSet(acb, 1, parameterList);
    }

    @Override
    int activationKind() {
        if (this.type == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }
}

