/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class SetTransactionIsolationNode
extends TransactionStatementNode {
    private int isolationLevel;

    SetTransactionIsolationNode(int isolationLevel, ContextManager cm) {
        super(cm);
        this.isolationLevel = isolationLevel;
    }

    @Override
    public String toString() {
        return "isolationLevel: " + this.isolationLevel + "\n" + super.toString();
    }

    @Override
    String statementToString() {
        return "SET TRANSACTION ISOLATION";
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getSetTransactionResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetTransactionIsolationConstantAction(this.isolationLevel);
    }
}

