/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcs.log.ui.VcsLogBookmark;
import com.intellij.vcs.log.ui.VcsLogBookmarkProviderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogBookmarkNode;", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "Lcom/intellij/vcs/log/ui/VcsLogBookmark;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/VcsLogBookmark;)V", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.vcs.log.impl"})
public final class VcsLogBookmarkNode
extends BookmarkNode<VcsLogBookmark> {
    public VcsLogBookmarkNode(@NotNull Project project, @NotNull VcsLogBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        super(project, (Bookmark)bookmark);
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildren() {
        return CollectionsKt.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        VcsLogBookmark bookmark = (VcsLogBookmark)this.getValue();
        String description = this.getBookmarkDescription();
        if (description == null && this.getBookmarkGroup() != null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String defaultDescription = VcsLogBookmarkProviderKt.access$getDefaultBookmarkDescription(project, bookmark.getRoot(), bookmark.getHash());
            if (defaultDescription != null) {
                description = defaultDescription;
                BookmarkGroup bookmarkGroup = this.getBookmarkGroup();
                if (bookmarkGroup != null) {
                    Intrinsics.checkNotNull((Object)bookmark);
                    bookmarkGroup.setDescription((Bookmark)bookmark, description);
                }
            }
        }
        presentation.setIcon(this.wrapIcon(null));
        if (description != null) {
            presentation.setPresentableText(description);
            presentation.addText(description, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.addText(" " + bookmark.getHash().asString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            presentation.addText(bookmark.getHash().asString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

