/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.installer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.python.community.impl.installer.ResourceTypeBinaryInstaller;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstaller;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ$\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/community/impl/installer/PySdkToInstallManager;", "", "<init>", "()V", "cpythonInstallers", "", "Lcom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller;", "getAvailableVersionsToInstall", "", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "getLanguageLevelInstallations", "product", "Lcom/jetbrains/python/sdk/Product;", "PkgBinaryInstaller", "ExeBinaryInstaller", "intellij.python.community.impl.installer"})
@SourceDebugExtension(value={"SMAP\nPySdkToInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkToInstallManager.kt\ncom/intellij/python/community/impl/installer/PySdkToInstallManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n136#2,9:63\n216#2:72\n217#2:75\n145#2:76\n1#3:73\n1#3:74\n463#4:77\n413#4:78\n1252#5,2:79\n774#5:81\n865#5,2:82\n1374#5:84\n1460#5,2:85\n774#5:87\n865#5,2:88\n1563#5:90\n1634#5,3:91\n1462#5,3:94\n1374#5:97\n1460#5,2:98\n774#5:100\n865#5,2:101\n1563#5:103\n1634#5,3:104\n1462#5,3:107\n1255#5:110\n*S KotlinDebug\n*F\n+ 1 PySdkToInstallManager.kt\ncom/intellij/python/community/impl/installer/PySdkToInstallManager\n*L\n41#1:63,9\n41#1:72\n41#1:75\n41#1:76\n41#1:74\n47#1:77\n47#1:78\n47#1:79,2\n49#1:81\n49#1:82,2\n50#1:84\n50#1:85,2\n51#1:87\n51#1:88,2\n51#1:90\n51#1:91,3\n50#1:94,3\n54#1:97\n54#1:98,2\n55#1:100\n55#1:101,2\n55#1:103\n55#1:104,3\n54#1:107,3\n47#1:110\n*E\n"})
public final class PySdkToInstallManager {
    @NotNull
    public static final PySdkToInstallManager INSTANCE = new PySdkToInstallManager();
    @NotNull
    private static final List<ResourceTypeBinaryInstaller> cpythonInstallers;

    private PySdkToInstallManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, BinaryInstallation> getAvailableVersionsToInstall() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = PySdkToInstallManager.getLanguageLevelInstallations$default(this, null, 1, null);
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            LanguageLevel k = (LanguageLevel)entry.getKey();
            List v = (List)entry.getValue();
            if ((BinaryInstallation)CollectionsKt.firstOrNull((List)v) != null) {
                BinaryInstallation it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)k, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<LanguageLevel, List<BinaryInstallation>> getLanguageLevelInstallations(Product product) {
        void $this$mapValuesTo$iv$iv;
        Map<LanguageLevel, List<Release>> $this$mapValues$iv = SdksKeeper.INSTANCE.pythonReleasesByLanguageLevel();
        boolean $i$f$mapValues = false;
        Map<LanguageLevel, List<Release>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Iterable list$iv$iv;
            Iterable destination$iv$iv2;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List releases = (List)entry2.getValue();
            Iterable iterable = releases;
            boolean $i$f$filter = false;
            void var19_19 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Release it = (Release)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getProduct() == product)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                Release release = (Release)element$iv$iv;
                boolean bl4 = false;
                List<Binary> list2 = release.getBinaries();
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Object element$iv$iv22;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2 = list2;
                    boolean $i$f$filter2 = false;
                    Iterable iterable2 = $this$filter$iv2;
                    Iterable destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv22 : $this$filterTo$iv$iv2) {
                        Binary it = (Binary)element$iv$iv22;
                        boolean bl5 = false;
                        if (!Binary.isCompatible$default(it, null, null, 3, null)) continue;
                        destination$iv$iv4.add(element$iv$iv22);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv4;
                    boolean $i$f$map = false;
                    destination$iv$iv4 = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    element$iv$iv22 = $this$mapTo$iv$iv.iterator();
                    while (element$iv$iv22.hasNext()) {
                        void it;
                        Object item$iv$iv = element$iv$iv22.next();
                        Binary bl5 = (Binary)item$iv$iv;
                        Iterable iterable3 = destination$iv$iv2;
                        boolean bl6 = false;
                        iterable3.add(TuplesKt.to((Object)release, (Object)it));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List releaseBinaries = (List)destination$iv$iv3;
            $this$flatMap$iv = releaseBinaries;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ResourceTypeBinaryInstaller it;
                void $this$filterTo$iv$iv3;
                list$iv$iv = (Pair)element$iv$iv;
                boolean bl7 = false;
                Release release = (Release)list$iv$iv.component1();
                Binary binary = (Binary)list$iv$iv.component2();
                Iterable $this$filter$iv3 = cpythonInstallers;
                boolean $i$f$filter3 = false;
                destination$iv$iv2 = $this$filter$iv3;
                Collection destination$iv$iv5 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                    it = (ResourceTypeBinaryInstaller)element$iv$iv3;
                    boolean bl8 = false;
                    if (!it.canInstall(binary)) continue;
                    destination$iv$iv5.add(element$iv$iv3);
                }
                $this$filter$iv3 = (List)destination$iv$iv5;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv3 = $this$map$iv;
                destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void installer;
                    it = (ResourceTypeBinaryInstaller)item$iv$iv;
                    Collection collection = destination$iv$iv5;
                    boolean bl9 = false;
                    collection.add(new BinaryInstallation(release, binary, (BinaryInstaller)installer));
                }
                list$iv$iv = (List)destination$iv$iv5;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            map4.put(k, list);
        }
        return destination$iv$iv;
    }

    static /* synthetic */ Map getLanguageLevelInstallations$default(PySdkToInstallManager pySdkToInstallManager, Product product, int n, Object object) {
        if ((n & 1) != 0) {
            product = Product.CPython;
        }
        return pySdkToInstallManager.getLanguageLevelInstallations(product);
    }

    static {
        Object[] objectArray = new ResourceTypeBinaryInstaller[]{new ExeBinaryInstaller(), new PkgBinaryInstaller()};
        cpythonInstallers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/community/impl/installer/PySdkToInstallManager$ExeBinaryInstaller;", "Lcom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller;", "<init>", "()V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl.installer"})
    public static final class ExeBinaryInstaller
    extends ResourceTypeBinaryInstaller {
        public ExeBinaryInstaller() {
            super(ResourceType.MICROSOFT_WINDOWS_EXECUTABLE);
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "/repair", "/quiet", "InstallAllUsers=0"};
            return new GeneralCommandLine(stringArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/community/impl/installer/PySdkToInstallManager$PkgBinaryInstaller;", "Lcom/intellij/python/community/impl/installer/ResourceTypeBinaryInstaller;", "<init>", "()V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl.installer"})
    public static final class PkgBinaryInstaller
    extends ResourceTypeBinaryInstaller {
        public PkgBinaryInstaller() {
            super(ResourceType.APPLE_SOFTWARE_PACKAGE);
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{"installer", "-pkg", ((Object)path2.toAbsolutePath()).toString(), "-target", "/"};
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
            Object[] objectArray = new Object[]{resource.getFileName()};
            String string = PySdkBundle.message("python.sdk.running.sudo.prompt", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine, (String)string);
        }
    }
}

